# バッチ設計書 15-BatchExecHashWindowAggregate

## 概要

本ドキュメントは、Apache Flink Table Plannerにおけるハッシュベースのウィンドウ集約処理のバッチ実行ノードの設計を記述したものである。

### 本バッチの処理概要

BatchExecHashWindowAggregateは、ハッシュテーブルを使用してタンブリング、ホッピング、セッションなどのウィンドウ集約を実行するバッチ実行ノードである。GROUP BY window()関数を使用したクエリに対応する。

**業務上の目的・背景**：ウィンドウ集約は、時間やその他の属性に基づいてデータをグループ化し、各ウィンドウ内でデータを集約する処理である。例えば、5分ごとの売上合計、1時間ごとのユーザー数といった時系列集計に使用される。ハッシュベースのウィンドウ集約は、ハッシュテーブルを使用してウィンドウごとの集約を効率的に行う。

**バッチの実行タイミング**：Flink SQLクエリの実行時、GROUP BY TUMBLE()/HOP()/SESSION()などのウィンドウ関数を含むクエリにおいて呼び出される。Plannerがハッシュベースのウィンドウ集約が適切と判断した場合に使用される。

**主要な処理内容**：
1. 入力ストリームからデータを受信
2. 時間フィールドに基づいてウィンドウを割り当て
3. グルーピングキーとウィンドウキーに基づいてハッシュテーブルを構築
4. 各ウィンドウに対して集約関数を適用
5. ウィンドウプロパティ（開始時刻、終了時刻、行時刻）を出力に追加
6. 集約結果を出力

**前後の処理との関連**：入力としてExchange（データパーティショニング）やCalc（フィルタ・射影）ノードを受け取る。2段階集約の場合、enableAssignPaneでペイン割り当てを制御し、isMerge/isFinalで処理を制御する。

**影響範囲**：Flink Table APIおよびSQL APIを使用するすべてのバッチジョブにおいて、ウィンドウ集約を使用するクエリに影響する。

## バッチ種別

集計処理（ウィンドウ集約）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（クエリ実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Flink SQLクエリの実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データストリーム | 入力ストリームが存在すること |
| ウィンドウ定義 | LogicalWindowでウィンドウタイプとサイズが定義されていること |
| 時間フィールド | 入力に時間フィールド（イベント時間または処理時間）が存在すること |

### 実行可否判定

Flink Plannerがハッシュベースのウィンドウ集約の使用を決定した場合のみ実行される。ソートベース（BatchExecSortWindowAggregate）との選択は、データ特性とコスト見積もりに基づく。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| grouping | int[] | Yes | N/A | グルーピングキーのフィールドインデックス |
| auxGrouping | int[] | Yes | N/A | 補助グルーピングキーのフィールドインデックス |
| aggCalls | AggregateCall[] | Yes | N/A | 集約関数呼び出しの配列 |
| window | LogicalWindow | Yes | N/A | ウィンドウ定義（タンブリング、ホッピング等） |
| inputTimeFieldIndex | int | Yes | N/A | 入力時間フィールドのインデックス |
| inputTimeIsDate | boolean | Yes | N/A | 入力時間がDATE型かどうか |
| namedWindowProperties | NamedWindowProperty[] | Yes | N/A | ウィンドウプロパティ（開始、終了、行時刻） |
| aggInputRowType | RowType | Yes | N/A | 集約入力の行型 |
| enableAssignPane | boolean | Yes | N/A | ペイン割り当てを有効にするか |
| isMerge | boolean | Yes | N/A | 中間結果のマージかどうか |
| isFinal | boolean | Yes | N/A | 最終集約かどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 入力ストリーム | RowData | 集約対象のデータストリーム（時間フィールドを含む） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 集約結果ストリーム | RowData | グルーピングキー、ウィンドウプロパティ、集約結果を含むレコード |

### 出力ファイル仕様

ファイル出力なし（ストリーム出力のみ）

## 処理フロー

### 処理シーケンス

```
1. 入力変換の取得
   └─ 入力ストリームをTransformationとして取得
2. AggregateInfoListの構築
   └─ 集約関数情報をバッチ用に変換
3. ウィンドウ定義の取得
   └─ WindowCodeGenerator.getWindowDef()でウィンドウサイズとスライドサイズを取得
4. HashWindowCodeGeneratorの構築
   └─ 全パラメータを設定してコードジェネレーターを構築
5. オペレーターコード生成
   └─ hashWindowCodeGenerator.gen()でオペレーターを生成
6. Transformationの作成
   └─ 生成されたオペレーターとメモリ設定を適用
7. 結果の出力
   └─ 集約結果を後続ノードに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力ストリーム取得]
    B --> C[AggregateInfoList構築]
    C --> D[ウィンドウサイズ/スライドサイズ取得]
    D --> E[HashWindowCodeGenerator構築]
    E --> F[オペレーターコード生成]
    F --> G[管理メモリ設定]
    G --> H[Transformation作成]
    H --> I[ウィンドウ割り当て]
    I --> J[ハッシュ集約実行]
    J --> K[ウィンドウプロパティ追加]
    K --> L[結果出力]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチノードはインメモリ処理であり、直接的なデータベース操作は行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OutOfMemoryError | メモリ不足 | ハッシュテーブルがメモリを超過 | TABLE_EXEC_RESOURCE_HASH_AGG_MEMORYを増加 |
| IllegalArgumentException | 不正なウィンドウ定義 | ウィンドウサイズ/スライドが不正 | ウィンドウ定義を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Flinkジョブ設定に依存 |
| リトライ間隔 | Flinkジョブ設定に依存 |
| リトライ対象エラー | 一時的なリソース不足 |

### 障害時対応

ジョブ失敗時は、Flink Checkpointから再開するか、ジョブを最初から再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体（Flinkジョブ単位） |
| コミットタイミング | ジョブ完了時 |
| ロールバック条件 | ジョブ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | データサイズに依存 |
| 目標処理時間 | クエリ複雑度とデータサイズに依存 |
| メモリ使用量上限 | TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY設定値 |

## 排他制御

同一ジョブ内で複数のタスクが並列実行される。各タスクは独立したハッシュテーブルを保持し、明示的な排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Transformation作成時 | ノード情報、ウィンドウ定義 |
| 進捗ログ | 処理中 | 処理件数、ウィンドウ数 |
| 終了ログ | 処理完了時 | 処理完了ステータス |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | ジョブ設定に依存 | Flink監視システム |
| メモリ使用量 | 管理メモリ上限 | Flink監視システム |

## 備考

- HashWindowCodeGeneratorを使用してオペレーターコードを生成
- TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMITでグループバッファサイズを制御
- TABLE_EXEC_RESOURCE_HASH_AGG_MEMORYで管理メモリを設定
- NamedWindowPropertyでwindow_start、window_end、rowtime等の属性を出力
- enableAssignPaneで2段階集約時のペイン（ウィンドウスライス）割り当てを制御
