# バッチ設計書 16-BatchExecSortWindowAggregate

## 概要

本ドキュメントは、Apache Flink Table Plannerにおけるソートベースのウィンドウ集約処理のバッチ実行ノードの設計を記述したものである。

### 本バッチの処理概要

BatchExecSortWindowAggregateは、ソート済みデータに対してタンブリング、ホッピング、セッションなどのウィンドウ集約を実行するバッチ実行ノードである。入力データがグルーピングキーと時間フィールドでソートされていることを前提とし、順次処理によりウィンドウ集約を行う。

**業務上の目的・背景**：ソートベースのウィンドウ集約は、入力データが既にソートされている場合や、メモリ効率を重視する場合に有効である。ハッシュベースと異なり、メモリ内にすべてのウィンドウを保持する必要がないため、大量のウィンドウが発生する場合でもメモリ効率が良い。

**バッチの実行タイミング**：Flink SQLクエリの実行時、GROUP BY TUMBLE()/HOP()/SESSION()などのウィンドウ関数を含むクエリにおいて呼び出される。入力が既にソートされている場合や、Plannerがソートベースのウィンドウ集約が適切と判断した場合に使用される。

**主要な処理内容**：
1. ソート済み入力ストリームからデータを受信
2. グルーピングキーとウィンドウの変化を検出
3. 同一ウィンドウのレコードに対して集約関数を適用
4. ウィンドウが変わったタイミングで集約結果を出力
5. ウィンドウプロパティ（開始時刻、終了時刻、行時刻）を追加
6. グルーピングキーがない場合は全体集約を実行

**前後の処理との関連**：入力としてSort（ソート）やExchange（データパーティショニング）ノードを受け取る。InputSortedExecNodeインターフェースを実装し、入力がソートされていることを表明する。2段階集約の場合、enableAssignPane/isMerge/isFinalフラグで処理を制御する。

**影響範囲**：Flink Table APIおよびSQL APIを使用するすべてのバッチジョブにおいて、ソートベースのウィンドウ集約が選択されるクエリに影響する。

## バッチ種別

集計処理（ウィンドウ集約）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（クエリ実行時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Flink SQLクエリの実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データストリーム | グルーピングキーと時間フィールドでソート済みの入力ストリーム |
| ウィンドウ定義 | LogicalWindowでウィンドウタイプとサイズが定義されていること |
| 時間フィールド | 入力に時間フィールドが存在すること |

### 実行可否判定

Flink Plannerがソートベースのウィンドウ集約の使用を決定した場合のみ実行される。入力が既にソートされている場合やメモリ効率を重視する場合に選択される。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| grouping | int[] | Yes | N/A | グルーピングキーのフィールドインデックス |
| auxGrouping | int[] | Yes | N/A | 補助グルーピングキーのフィールドインデックス |
| aggCalls | AggregateCall[] | Yes | N/A | 集約関数呼び出しの配列 |
| window | LogicalWindow | Yes | N/A | ウィンドウ定義 |
| inputTimeFieldIndex | int | Yes | N/A | 入力時間フィールドのインデックス |
| inputTimeIsDate | boolean | Yes | N/A | 入力時間がDATE型かどうか |
| namedWindowProperties | NamedWindowProperty[] | Yes | N/A | ウィンドウプロパティ |
| aggInputRowType | RowType | Yes | N/A | 集約入力の行型 |
| enableAssignPane | boolean | Yes | N/A | ペイン割り当てを有効にするか |
| isMerge | boolean | Yes | N/A | 中間結果のマージかどうか |
| isFinal | boolean | Yes | N/A | 最終集約かどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソート済み入力ストリーム | RowData | グルーピングキーと時間でソートされたデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 集約結果ストリーム | RowData | グルーピングキー、ウィンドウプロパティ、集約結果を含むレコード |

### 出力ファイル仕様

ファイル出力なし（ストリーム出力のみ）

## 処理フロー

### 処理シーケンス

```
1. 入力変換の取得
   └─ ソート済み入力ストリームをTransformationとして取得
2. AggregateInfoListの構築
   └─ 集約関数情報をバッチ用に変換
3. ウィンドウ定義の取得
   └─ WindowCodeGenerator.getWindowDef()でウィンドウサイズとスライドサイズを取得
4. SortWindowCodeGeneratorの構築
   └─ 全パラメータを設定してコードジェネレーターを構築
5. コード生成
   └─ グルーピングキーの有無に応じて異なるメソッドを使用
   └─ grouping.length == 0: genWithoutKeys()
   └─ grouping.length > 0: genWithKeys()
6. Transformationの作成
   └─ 生成されたオペレーターを使用してTransformationを作成
7. 結果の出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ソート済み入力取得]
    B --> C[AggregateInfoList構築]
    C --> D[ウィンドウサイズ/スライドサイズ取得]
    D --> E[SortWindowCodeGenerator構築]
    E --> F{グルーピングキー有無}
    F -->|なし| G[genWithoutKeys]
    F -->|あり| H[genWithKeys]
    G --> I[Transformation作成]
    H --> I
    I --> J[ウィンドウ割り当て]
    J --> K[ソート集約実行]
    K --> L[ウィンドウプロパティ追加]
    L --> M[結果出力]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチノードはインメモリ処理であり、直接的なデータベース操作は行わない。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| N/A | N/A | N/A | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalStateException | 入力順序エラー | 入力がソートされていない | 前段のソート処理を確認 |
| IllegalArgumentException | 不正なウィンドウ定義 | ウィンドウサイズ/スライドが不正 | ウィンドウ定義を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Flinkジョブ設定に依存 |
| リトライ間隔 | Flinkジョブ設定に依存 |
| リトライ対象エラー | 一時的なリソース不足 |

### 障害時対応

ジョブ失敗時は、Flink Checkpointから再開するか、ジョブを最初から再実行する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体（Flinkジョブ単位） |
| コミットタイミング | ジョブ完了時 |
| ロールバック条件 | ジョブ失敗時 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | データサイズに依存 |
| 目標処理時間 | クエリ複雑度とデータサイズに依存 |
| メモリ使用量上限 | ウィンドウ毎の状態のみ保持（ハッシュより少ない） |

## 排他制御

同一ジョブ内で複数のタスクが並列実行される。各タスクは独立して処理を行い、明示的な排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Transformation作成時 | ノード情報、ウィンドウ定義 |
| 進捗ログ | 処理中 | 処理件数、ウィンドウ数 |
| 終了ログ | 処理完了時 | 処理完了ステータス |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | ジョブ設定に依存 | Flink監視システム |
| 処理件数 | データサイズに依存 | Flink監視システム |

## 備考

- InputSortedExecNodeインターフェースを実装し、入力がソートされていることを表明
- SortWindowCodeGeneratorを使用してオペレーターコードを生成
- TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMITでグループバッファサイズを制御
- ハッシュウィンドウ集約と異なり、管理メモリの明示的確保は不要
- grouping.lengthが0の場合はgenWithoutKeys()、それ以外はgenWithKeys()を使用
