# バッチ設計書 21-BatchExecSortLimit

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecSortLimitバッチ実行ノードの設計仕様を記述したものです。このノードはソート処理と制限（LIMIT）処理を組み合わせたTop-N処理を実行します。

### 本バッチの処理概要

BatchExecSortLimitは、ORDER BY句とLIMIT句を組み合わせたSQL文（例：`SELECT * FROM table ORDER BY col LIMIT n`）を効率的に実行するためのバッチ実行ノードです。データを指定されたソート順で並べ替え、上位N件のみを出力します。

**業務上の目的・背景**：大規模データセットから上位N件のレコードを効率的に取得する必要があるビジネスシナリオ（売上上位商品の抽出、パフォーマンス上位のユーザー特定など）において、全データをソートするのではなく、ヒープベースのアルゴリズムを使用して必要なレコードのみを保持することでメモリ効率とパフォーマンスを最適化します。

**バッチの実行タイミング**：Flink SQLクエリの実行時、オプティマイザがORDER BY + LIMIT句を検出した際に自動的に実行計画に組み込まれます。

**主要な処理内容**：
1. 入力データストリームからレコードを受信
2. PriorityQueue（ヒープ）を使用してソート順で上位limitEnd件を保持
3. 全入力処理後、limitStartからlimitEndの範囲のレコードを出力

**前後の処理との関連**：前段のデータソースまたは変換処理からデータを受け取り、ソート済みの制限付き結果を後段の処理（Sink等）に渡します。

**影響範囲**：このバッチはメモリ内でヒープを構築するため、limitEndの値が大きい場合はメモリ使用量に影響を与えます。

## バッチ種別

データ変換処理（ソート・フィルタリング）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行（ORDER BY + LIMIT句） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データ | 有効なRowData形式のデータストリーム |
| limitEnd制約 | limitEndがLong.MAX_VALUEでないこと |
| ソート仕様 | 有効なSortSpecが指定されていること |

### 実行可否判定

limitEndがLong.MAX_VALUEの場合、TableExceptionをスローして処理を中断します。これは、無制限のソートは別のオペレータ（BatchExecSort）で処理されるべきであるためです。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| sortSpec | SortSpec | Yes | - | ソート仕様（ソートキーと昇順/降順） |
| limitStart | long | Yes | - | 出力開始位置（0始まり） |
| limitEnd | long | Yes | - | 出力終了位置（排他） |
| isGlobal | boolean | Yes | - | グローバルソートかローカルソートか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| inputEdge | RowData | 上流の実行ノードからの入力データストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ノード | RowData | ソートされた制限付きレコード |

### 出力ファイル仕様

N/A（メモリ内処理、下流ノードへのストリーム出力）

## 処理フロー

### 処理シーケンス

```
1. オペレータ初期化
   └─ PriorityQueueの生成、Comparatorの初期化
2. 入力レコード処理
   └─ 各レコードをヒープに追加（limitEnd件を超えたら最小要素を削除）
3. 入力終了処理
   └─ isGlobalの場合：ヒープをソートしてlimitStart〜limitEnd範囲を出力
   └─ ローカルの場合：ヒープ内の全レコードを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[PriorityQueue初期化]
    B --> C[入力レコード受信]
    C --> D{ヒープサイズ >= limitEnd?}
    D -->|Yes| E{新レコードがヒープトップより優先?}
    D -->|No| F[レコードをヒープに追加]
    E -->|Yes| G[ヒープトップを削除して新レコード追加]
    E -->|No| H[レコード破棄]
    F --> I{入力終了?}
    G --> I
    H --> I
    I -->|No| C
    I -->|Yes| J{isGlobal?}
    J -->|Yes| K[ヒープをソート]
    K --> L[limitStart〜limitEnd範囲を出力]
    J -->|No| M[ヒープ全体を出力]
    L --> N[バッチ終了]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のみ）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | 設定エラー | limitEndがLong.MAX_VALUE | 無制限ソートにはBatchExecSortを使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（Flinkフレームワーク管理） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Flinkのチェックポイント/リスタート機能による自動リカバリに依存します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | 処理失敗時（Flink管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | limitEnd件数に依存 |
| 目標処理時間 | O(n log k) ※n=入力件数、k=limitEnd |
| メモリ使用量上限 | limitEnd * レコードサイズ |

## 排他制御

同一ジョブ内での並列実行はFlinkにより管理されます。isGlobalがfalseの場合は各パーティションで独立して処理され、isGlobalがtrueの場合は最終的な結果が集約されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | オペレータopen時 | 初期化完了 |
| 進捗ログ | N/A | - |
| 終了ログ | endInput時 | 処理完了 |
| エラーログ | エラー発生時 | TableException詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| メモリ使用量 | Flinkタスクマネージャ設定による | Flink WebUI |
| 処理時間 | アプリケーション定義 | Flink Metrics |

## 備考

- SortLimitOperatorはBoundedOneInputインターフェースを実装しており、有界データソースに対してのみ動作します
- ヒープは逆順比較を使用し、最小要素（ソート順で最も優先度が低い要素）をヒープトップに配置することで、効率的な要素入れ替えを実現しています
- 入力データが既にソート済みの場合でもヒープ処理を行うため、今後の最適化候補として識別されています（TODOコメントあり）
