# バッチ設計書 22-BatchExecLimit

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecLimitバッチ実行ノードの設計仕様を記述したものです。このノードはデータストリームから指定された範囲の行のみを出力する制限（LIMIT）処理を実行します。

### 本バッチの処理概要

BatchExecLimitは、SQL文のLIMIT句（例：`SELECT * FROM table LIMIT n`または`SELECT * FROM table LIMIT m, n`）を実行するためのバッチ実行ノードです。ORDER BY句を伴わない単純な行数制限を行い、入力ストリームから指定された範囲の行のみを出力します。

**業務上の目的・背景**：大規模データセットからサンプルデータを取得したい場合や、ページング処理を行う場合など、全データを処理せずに指定件数のデータのみを取得する必要があるビジネスシナリオにおいて、処理コストを削減し効率的なデータ取得を実現します。

**バッチの実行タイミング**：Flink SQLクエリの実行時、オプティマイザがLIMIT句（ORDER BY句なし）を検出した際に自動的に実行計画に組み込まれます。

**主要な処理内容**：
1. 入力データストリームからレコードを受信
2. カウンタを用いてレコード数を追跡
3. limitStartからlimitEndの範囲内のレコードのみを下流に出力

**前後の処理との関連**：前段のデータソースまたは変換処理からデータを受け取り、制限付き結果を後段の処理（Sink等）に渡します。ソートが必要な場合はBatchExecSortLimitが使用されます。

**影響範囲**：このバッチは軽量な処理であり、メモリ使用量への影響は最小限です。ただし、limitStartが大きい場合でも、そこまでの全レコードを処理する必要があります。

## バッチ種別

データフィルタリング処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行（LIMIT句） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データ | 有効なRowData形式のデータストリーム |
| limitStart | 0以上の整数値 |
| limitEnd | limitStart以上の整数値 |

### 実行可否判定

入力パラメータが有効な範囲内であれば実行可能です。limitEndに到達した後は追加のレコードは処理されませんが、現在の実装では早期終了（stopEarly）は未実装です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| limitStart | long | Yes | - | 出力開始位置（0始まり） |
| limitEnd | long | Yes | - | 出力終了位置（排他） |
| isGlobal | boolean | Yes | - | グローバル制限かローカル制限か |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| inputEdge | RowData | 上流の実行ノードからの入力データストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ノード | RowData | 制限範囲内のレコード |

### 出力ファイル仕様

N/A（メモリ内処理、下流ノードへのストリーム出力）

## 処理フロー

### 処理シーケンス

```
1. オペレータ初期化
   └─ カウンタを0に初期化
2. 入力レコード処理
   └─ カウンタをインクリメント
   └─ isGlobalかつカウンタ > limitStartの場合、またはローカルの場合に出力
   └─ カウンタ >= limitEndで処理終了（ただし早期終了は未実装）
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[カウンタ初期化 count=0]
    B --> C[入力レコード受信]
    C --> D{count < limitEnd?}
    D -->|Yes| E[count++]
    E --> F{isGlobal?}
    F -->|Yes| G{count > limitStart?}
    F -->|No| H[レコード出力]
    G -->|Yes| H
    G -->|No| I[スキップ]
    H --> J{次のレコード?}
    I --> J
    J -->|Yes| C
    J -->|No| K[バッチ終了]
    D -->|No| L[レコード破棄]
    L --> J
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のみ）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | - | 通常のエラーケースなし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（Flinkフレームワーク管理） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Flinkのチェックポイント/リスタート機能による自動リカバリに依存します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | 処理失敗時（Flink管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | limitEnd件数 |
| 目標処理時間 | O(limitEnd) |
| メモリ使用量上限 | 最小限（カウンタのみ） |

## 排他制御

同一ジョブ内での並列実行はFlinkにより管理されます。isGlobalがfalseの場合は各パーティションで独立して処理されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | オペレータ初期化時 | 初期化完了 |
| 進捗ログ | N/A | - |
| 終了ログ | 処理完了時 | 処理完了 |
| エラーログ | エラー発生時 | 例外詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理件数 | Flink Metricsで監視 | Flink WebUI |
| 処理時間 | アプリケーション定義 | Flink Metrics |

## 備考

- LimitOperatorはOneInputStreamOperatorインターフェースを実装しています
- コード内のTODOコメントにより、stopEarly機能の実装が今後の課題として識別されています
- isGlobalフラグにより、分散処理時のローカル制限とグローバル制限の動作を制御します
- BatchExecSortLimitと異なり、ソート処理を行わないため、入力順序がそのまま出力順序になります
- 分散処理時にisGlobalがtrueの場合、limitStartより前のレコードはスキップされますが、ローカルの場合は全パーティションから出力されます
