# バッチ設計書 25-BatchExecPythonCalc

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecPythonCalcバッチ実行ノードの設計仕様を記述したものです。このノードはPythonユーザー定義スカラー関数（UDF）を使用した計算処理を実行します。

### 本バッチの処理概要

BatchExecPythonCalcは、Pythonで実装されたスカラー関数（UDF）を含む計算処理を実行するためのバッチ実行ノードです。Pythonワーカープロセスと連携し、行単位でPython関数を評価して結果を返します。Pandas UDFにも対応しており、Arrowフォーマットによるベクトル化処理も可能です。

**業務上の目的・背景**：データサイエンスや機械学習の分野では、Pythonエコシステム（NumPy、Pandas、scikit-learnなど）の活用が一般的です。BatchExecPythonCalcにより、Flinkのバッチ処理パイプラインにPythonの豊富なライブラリを統合し、複雑なデータ変換やML推論をSQLクエリ内で実行できます。

**バッチの実行タイミング**：Flink SQLクエリの実行時、オプティマイザがPython UDFを含む射影または条件を検出した際に自動的に実行計画に組み込まれます。

**主要な処理内容**：
1. 入力データストリームからレコードを受信
2. Python UDF呼び出しに必要な入力フィールドを抽出
3. Pythonワーカープロセスに入力を送信し、UDFを評価
4. Python UDFの結果と転送フィールドを結合して出力レコードを構築

**前後の処理との関連**：通常のデータ変換処理と同様に、任意の入力ノードからデータを受け取り、後続のノードにデータを渡します。Python UDFを含まない射影はBatchExecCalcで処理されます。

**影響範囲**：Pythonワーカープロセスの起動とプロセス間通信のオーバーヘッドがあるため、純粋なJava処理より遅延が大きくなる可能性があります。

## バッチ種別

Python UDF計算処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行（Python UDFを含む式） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データ | 有効なRowData形式のデータストリーム |
| Python環境 | Python実行環境が利用可能 |
| UDF登録 | Python UDFがカタログに登録済み |

### 実行可否判定

入力プロパティが1つ、射影リスト内にPython UDF呼び出しが含まれていれば実行可能です。Python環境が利用できない場合は実行時エラーとなります。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| projection | List<RexNode> | Yes | - | 射影式のリスト（Python UDF呼び出しを含む） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| inputEdge | RowData | 上流の実行ノードからの入力データストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ノード | RowData | 転送フィールド + Python UDF結果 |

### 出力ファイル仕様

N/A（メモリ内処理、下流ノードへのストリーム出力）

## 処理フロー

### 処理シーケンス

```
1. オペレータ生成
   └─ Python設定の抽出（CommonPythonUtil.extractPythonConfiguration）
   └─ PythonFunctionInfoの抽出
   └─ UDF入力オフセットの計算
   └─ 転送フィールドの特定
   └─ Python Operatorの生成（InProcess or Embedded）
2. 入力レコード処理
   └─ 転送フィールドの射影
   └─ UDF入力フィールドの射影
   └─ Pythonワーカーへの送信
3. Python処理
   └─ Python UDFの評価
   └─ 結果の返却
4. 出力処理
   └─ 転送フィールド + UDF結果を結合
   └─ 下流に送信
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Python設定抽出]
    B --> C[PythonFunctionInfo生成]
    C --> D[Python Operator生成]
    D --> E[入力レコード受信]
    E --> F[転送フィールド射影]
    F --> G[UDF入力フィールド射影]
    G --> H[Pythonワーカーへ送信]
    H --> I[Python UDF評価]
    I --> J[結果受信]
    J --> K[転送フィールド + UDF結果結合]
    K --> L[下流に送信]
    L --> M{次のレコード?}
    M -->|Yes| E
    M -->|No| N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のみ）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | Python Operator構築失敗 | Python環境エラー | Python設定確認 |
| RuntimeException | UDF実行エラー | Python UDF内で例外発生 | UDF実装確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（Flinkフレームワーク管理） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Flinkのチェックポイント/リスタート機能による自動リカバリに依存します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | 処理失敗時（Flink管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力件数に依存 |
| 目標処理時間 | Python UDFの複雑度に依存 |
| メモリ使用量上限 | ManagedMemoryUseCaseで管理可能 |

## 排他制御

同一ジョブ内での並列実行はFlinkにより管理されます。各タスクスロットでPythonワーカープロセスが起動されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | オペレータ生成時 | Python Operator生成完了 |
| 警告ログ | Pandas UDF使用時 | process modeへのフォールバック |
| 終了ログ | 処理完了時 | 処理完了 |
| エラーログ | エラー発生時 | 例外詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理件数 | Flink Metricsで監視 | Flink WebUI |
| Pythonメモリ使用量 | Managed Memory設定 | Flink Metrics |

## 備考

- BatchExecPythonCalcはCommonExecPythonCalcを継承しています
- 3種類のPython Operatorをサポート：
  - PythonScalarFunctionOperator（InProcessモード、通常のUDF）
  - EmbeddedPythonScalarFunctionOperator（Embeddedモード、通常のUDF）
  - ArrowPythonScalarFunctionOperator（Pandas UDF、ベクトル化処理）
- Pandas UDF（Arrow形式）はprocess modeでのみサポートされ、それ以外のモードでは警告とともにフォールバック
- CommonPythonUtil.isPythonWorkerUsingManagedMemory()がtrueの場合、ManagedMemoryUseCase.PYTHONが宣言される
- 転送フィールド（RexInputRef）とUDF呼び出し（RexCall）が分離され、効率的なデータ転送を実現
- ProjectionCodeGeneratorで入力射影コードを動的生成
