# バッチ設計書 26-BatchExecPythonAsyncCalc

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecPythonAsyncCalcバッチ実行ノードの設計仕様を記述したものです。このノードはPython非同期ユーザー定義スカラー関数（Async UDF）を使用した計算処理を実行します。

### 本バッチの処理概要

BatchExecPythonAsyncCalcは、Pythonで実装された非同期スカラー関数（Async UDF）を含む計算処理を実行するためのバッチ実行ノードです。Python UDFが外部サービス呼び出しなどのI/O操作を含む場合に、非同期処理により高いスループットを実現します。

**業務上の目的・背景**：機械学習モデルへの推論リクエスト、外部APIへの呼び出し、データベースルックアップなど、I/Oバウンドな処理をPython UDF内で行う場合、同期的な処理ではレイテンシがボトルネックとなります。BatchExecPythonAsyncCalcは非同期処理により、I/O待ち時間を他のレコード処理で有効活用し、全体のスループットを向上させます。

**バッチの実行タイミング**：Flink SQLクエリの実行時、オプティマイザがPython Async UDFを含む射影または条件を検出した際に自動的に実行計画に組み込まれます。

**主要な処理内容**：
1. 入力データストリームからレコードを受信
2. Python Async UDF呼び出しに必要な入力フィールドを抽出
3. 非同期でPythonワーカープロセスにリクエストを送信
4. 非同期レスポンスを受信し、元のレコードと結合して出力

**前後の処理との関連**：通常のデータ変換処理と同様に、任意の入力ノードからデータを受け取り、後続のノードにデータを渡します。同期Python UDFはBatchExecPythonCalcで処理されます。

**影響範囲**：非同期処理のため、入力順序と出力順序が異なる場合があります。順序保証が必要な場合は追加の構成が必要です。

## バッチ種別

Python Async UDF計算処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行（Python Async UDFを含む式） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データ | 有効なRowData形式のデータストリーム |
| Python環境 | Python実行環境が利用可能 |
| Async UDF登録 | Python Async UDFがカタログに登録済み |

### 実行可否判定

入力プロパティが1つ、射影リスト内にPython Async UDF呼び出しが含まれていれば実行可能です。Python環境が利用できない場合は実行時エラーとなります。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| projection | List<RexNode> | Yes | - | 射影式のリスト（Python Async UDF呼び出しを含む） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| inputEdge | RowData | 上流の実行ノードからの入力データストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ノード | RowData | 入力フィールド + Python Async UDF結果 |

### 出力ファイル仕様

N/A（メモリ内処理、下流ノードへのストリーム出力）

## 処理フロー

### 処理シーケンス

```
1. オペレータ生成
   └─ CommonExecPythonAsyncCalcの変換処理を継承
   └─ Python設定の抽出
   └─ 非同期オペレータの生成
2. 入力レコード処理
   └─ UDF入力フィールドの射影
   └─ 非同期リクエストをPythonワーカーに送信
3. 非同期レスポンス処理
   └─ Python Async UDFの結果を受信
   └─ 元のレコードと結果を結合
4. 出力処理
   └─ 結合されたレコードを下流に送信
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Python設定抽出]
    B --> C[非同期オペレータ生成]
    C --> D[入力レコード受信]
    D --> E[UDF入力フィールド射影]
    E --> F[非同期リクエスト送信]
    F --> G[Pythonワーカー処理]
    G --> H[非同期レスポンス受信]
    H --> I[元のレコードと結果結合]
    I --> J[下流に送信]
    J --> K{次のレコード?}
    K -->|Yes| D
    K -->|No| L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のみ）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | Python Operator構築失敗 | Python環境エラー | Python設定確認 |
| RuntimeException | Async UDF実行エラー | Python Async UDF内で例外発生 | UDF実装確認 |
| TimeoutException | 非同期タイムアウト | 応答時間超過 | タイムアウト設定調整 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | Async I/O設定に依存 |
| リトライ間隔 | Async I/O設定に依存 |
| リトライ対象エラー | タイムアウトエラー |

### 障害時対応

Flinkのチェックポイント/リスタート機能による自動リカバリに依存します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | 処理失敗時（Flink管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力件数に依存 |
| 目標処理時間 | I/Oレイテンシと並列度に依存 |
| メモリ使用量上限 | ManagedMemoryUseCaseで管理可能 |

## 排他制御

同一ジョブ内での並列実行はFlinkにより管理されます。非同期処理により、複数のリクエストが並行して処理されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | オペレータ生成時 | 非同期オペレータ生成完了 |
| 進捗ログ | N/A | - |
| 終了ログ | 処理完了時 | 処理完了 |
| エラーログ | エラー発生時 | 例外詳細、タイムアウト情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理件数 | Flink Metricsで監視 | Flink WebUI |
| 非同期キューサイズ | Async I/O設定 | Flink Metrics |
| タイムアウト発生率 | アプリケーション定義 | Flink Metrics |

## 備考

- BatchExecPythonAsyncCalcはCommonExecPythonAsyncCalcを継承しています
- CommonExecPythonAsyncCalcはFlinkのAsync I/Oメカニズムを活用して非同期処理を実現
- projectionパラメータにはPython Async UDF呼び出しを含む式リストを指定
- 非同期処理のため、入力順序と出力順序が異なる場合があり、順序保証が必要な場合は設定が必要
- JSON直列化/逆直列化をサポートするため、@JsonCreatorと@JsonPropertyアノテーションが使用されている
- RowType形式で入出力の型情報を管理
