# バッチ設計書 27-BatchExecExpand

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecExpandバッチ実行ノードの設計仕様を記述したものです。このノードは1つの入力行を複数の出力行に展開する処理を実行します。

### 本バッチの処理概要

BatchExecExpandは、SQLのグルーピングセット機能（CUBE、ROLLUP、GROUPING SETS）を実装するために、1つの入力レコードを複数の出力レコードに展開するバッチ実行ノードです。各展開パターンに対応する射影式に基づいて、入力レコードから複数の異なる出力レコードを生成します。

**業務上の目的・背景**：データ集計において、複数のグルーピング組み合わせ（例：地域別、製品別、地域×製品別など）を同時に計算する必要がある場合、CUBE、ROLLUP、GROUPING SETS機能を使用します。BatchExecExpandはこれらの機能の基盤として、1つのレコードを各グルーピングパターンに対応する複数のレコードに展開します。

**バッチの実行タイミング**：Flink SQLクエリの実行時、オプティマイザがCUBE、ROLLUP、またはGROUPING SETS句を含むGROUP BY句を検出した際に自動的に実行計画に組み込まれます。

**主要な処理内容**：
1. 入力データストリームからレコードを受信
2. 各展開パターン（projects）に対して射影式を評価
3. 各パターンから生成された出力レコードを下流に送信

**前後の処理との関連**：データソースや前段の変換処理からデータを受け取り、展開後のデータをAggregateノードに渡します。Aggregateノードはグループ化IDによって各グルーピングパターンを識別し、適切に集約処理を行います。

**影響範囲**：出力レコード数は入力レコード数 × 展開パターン数となるため、メモリとネットワーク帯域に影響を与えます。

## バッチ種別

データ展開処理（グルーピングセット展開）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行（CUBE/ROLLUP/GROUPING SETS句） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データ | 有効なRowData形式のデータストリーム |
| projectsパラメータ | 1つ以上の展開パターン（射影リストのリスト） |
| パターンの一貫性 | 全パターンの射影数が同一であること |

### 実行可否判定

入力プロパティが1つ、projectsが空でなく、全パターンの射影数が一致していれば実行可能です。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| projects | List<List<RexNode>> | Yes | - | 展開パターンごとの射影式リスト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| inputEdge | RowData | 上流の実行ノードからの入力データストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ノード | RowData | 展開後のレコード（パターン数 × 入力レコード数） |

### 出力ファイル仕様

N/A（メモリ内処理、下流ノードへのストリーム出力）

## 処理フロー

### 処理シーケンス

```
1. オペレータ生成
   └─ ExpandCodeGeneratorでExpandオペレータのコードを動的生成
   └─ 各展開パターンの射影コードを生成
   └─ コンパイルしてCodeGenOperatorFactoryを作成
2. 入力レコード処理
   └─ 各展開パターン（projects）をループ
   └─ 各パターンの射影式を評価して出力レコードを生成
3. 出力処理
   └─ 生成された全出力レコードを下流に送信
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ExpandCodeGenerator実行]
    B --> C[オペレータ生成・コンパイル]
    C --> D[入力レコード受信]
    D --> E[パターンインデックス i=0]
    E --> F{i < パターン数?}
    F -->|Yes| G[projects[i]の射影式評価]
    G --> H[出力レコード生成]
    H --> I[下流に送信]
    I --> J[i++]
    J --> F
    F -->|No| K{次の入力レコード?}
    K -->|Yes| D
    K -->|No| L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のみ）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | パラメータエラー | projectsが空または不整合 | クエリの修正 |
| CodeGenerationException | コード生成エラー | 不正な射影式 | クエリの修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（Flinkフレームワーク管理） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Flinkのチェックポイント/リスタート機能による自動リカバリに依存します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | 処理失敗時（Flink管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力件数 × 展開パターン数 |
| 目標処理時間 | O(n × p) ※n=入力件数、p=パターン数 |
| メモリ使用量上限 | 最小限（1レコード分のバッファ） |

## 排他制御

同一ジョブ内での並列実行はFlinkにより管理されます。ステートレスな処理であるため、並列度に関わらず独立して処理可能です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | オペレータ生成時 | コード生成完了 |
| 進捗ログ | N/A | - |
| 終了ログ | 処理完了時 | 処理完了 |
| エラーログ | エラー発生時 | 例外詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 出力件数 | Flink Metricsで監視 | Flink WebUI |
| 処理時間 | アプリケーション定義 | Flink Metrics |

## 備考

- BatchExecExpandはCommonExecExpandを継承しており、ストリーム処理版のStreamExecExpandと共通の基底クラスを持ちます
- retainHeader=falseで動作し、レコードヘッダ情報は保持されません
- ExpandCodeGeneratorによりパターンごとの射影コードが動的生成されます
- 入力プロパティのチェック（サイズ==1）は基底クラスで実行されます
- projectsの各要素は同じサイズ（射影数）である必要があり、これも基底クラスでチェックされます
- CUBE、ROLLUP、GROUPING SETSの各機能は、適切なprojectsを生成することで実現されます
- 展開後のレコードには通常、グループ化IDが含まれ、後続のAggregateノードでグループ識別に使用されます
