# バッチ設計書 28-BatchExecUnion

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecUnionバッチ実行ノードの設計仕様を記述したものです。このノードは複数の入力ストリームを1つのストリームに統合する論理的な結合処理を実行します。

### 本バッチの処理概要

BatchExecUnionは、SQL文のUNION ALL句を実行するためのバッチ実行ノードです。複数の入力データストリームを1つのストリームに統合します。これは物理的な処理ではなく、論理的な統合であり、実際のデータ変換は行われません。

**業務上の目的・背景**：複数のデータソースからのデータを結合して分析する場合や、異なる条件で抽出したデータを統合する場合など、複数のストリームを1つにまとめる必要があるビジネスシナリオで使用されます。UNION ALLは重複を除外しないため、全てのレコードがそのまま出力されます。

**バッチの実行タイミング**：Flink SQLクエリの実行時、オプティマイザがUNION ALL句を検出した際に自動的に実行計画に組み込まれます。

**主要な処理内容**：
1. 複数の入力データストリームを受信
2. 全入力ストリームのレコードを1つの出力ストリームに統合
3. 統合されたレコードを下流に送信

**前後の処理との関連**：複数のデータソースや変換処理からデータを受け取り、統合後のデータを後続の処理（Filter、Join、Aggregate、Sink等）に渡します。

**影響範囲**：論理的な統合であるため、処理コストは最小限です。ただし、出力レコード数は全入力レコード数の合計となります。

## バッチ種別

データ統合処理（論理的結合）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行（UNION ALL句） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データ | 有効なRowData形式の複数データストリーム |
| スキーマ一致 | 全入力ストリームのスキーマが互換性を持つこと |

### 実行可否判定

複数の入力プロパティが指定されていれば実行可能です。入力ストリームが1つ以上であれば処理は実行されます。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| inputProperties | List<InputProperty> | Yes | - | 複数の入力プロパティリスト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| inputEdges | List<RowData> | 上流の複数実行ノードからの入力データストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ノード | RowData | 統合されたレコード |

### 出力ファイル仕様

N/A（メモリ内処理、下流ノードへのストリーム出力）

## 処理フロー

### 処理シーケンス

```
1. Transformation生成
   └─ 各入力エッジのTransformationを取得
   └─ UnionTransformationを生成
2. 実行時処理
   └─ 各入力ストリームからレコードを受信
   └─ 変換なしで下流に送信
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力Transformationリスト作成]
    B --> C[各入力エッジのTransformation取得]
    C --> D[UnionTransformation生成]
    D --> E[入力1からレコード受信]
    D --> F[入力2からレコード受信]
    D --> G[入力Nからレコード受信]
    E --> H[下流に送信]
    F --> H
    G --> H
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（論理的統合処理のみ）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | - | 通常のエラーケースなし | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（Flinkフレームワーク管理） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Flinkのチェックポイント/リスタート機能による自動リカバリに依存します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | 処理失敗時（Flink管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 全入力件数の合計 |
| 目標処理時間 | O(n) ※n=全入力レコード数 |
| メモリ使用量上限 | 最小限（データ変換なし） |

## 排他制御

同一ジョブ内での並列実行はFlinkにより管理されます。各入力ストリームは独立して処理されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | Transformation生成時 | 初期化完了 |
| 進捗ログ | N/A | - |
| 終了ログ | 処理完了時 | 処理完了 |
| エラーログ | エラー発生時 | 例外詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 出力件数 | Flink Metricsで監視 | Flink WebUI |
| 処理時間 | アプリケーション定義 | Flink Metrics |

## 備考

- BatchExecUnionはCommonExecUnionを継承しており、ストリーム処理版のStreamExecUnionと共通の基底クラスを持ちます
- 「not a physical node」とJavaDocで明記されており、論理的な統合のみを行います
- UnionTransformationを使用して複数の入力を統合します
- ExecNodeMetadataでproducedTransformationsが指定されていないのは、物理的なオペレータを生成しないためです
- UNION ALL相当の処理であり、重複除外は行いません。重複除外が必要な場合はUNION（DISTINCT）を使用し、後続にDistinctノードが追加されます
- 全入力ストリームのスキーマは互換性を持つ必要があります（列数と型が一致）
