# バッチ設計書 3-BatchExecValues

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecValuesバッチ実行ノードの設計仕様を記載する。このノードは、指定されたリテラル値（定数値）からレコードを生成してデータを提供する。

### 本バッチの処理概要

BatchExecValuesは、SQLのVALUES句やTable APIで直接指定されたリテラル値を読み取り、RowData形式のレコードとして出力する実行ノードである。RexLiteral形式で表現されたタプルリストからデータを生成する。

**業務上の目的・背景**：SQLクエリのVALUES句（例：`VALUES (1, 'a'), (2, 'b')`）やINSERT文のリテラル値を処理する際に使用される。テスト目的のデータ生成や、定数テーブルの作成、設定値のインライン指定などに活用される。

**バッチの実行タイミング**：Flinkジョブのバッチ実行時に、リテラル値を含むクエリ実行時に使用される。外部データソースへのアクセスを伴わないため、即座に実行可能。

**主要な処理内容**：
1. RexLiteralのタプルリストを受け取る
2. CommonExecValuesの親クラスメソッドでTransformationを生成
3. レガシー変換に有界性マークを付与
4. RowData形式でリテラル値を出力

**前後の処理との関連**：前提となるバッチはなく、定数データの生成元となる。後続には射影、フィルタ、結合、集約などの各種処理ノードが接続可能。

**影響範囲**：リテラル値の型と件数が後続処理に影響。メモリ上でデータを保持するため、大量のリテラル値指定は非推奨。

## バッチ種別

データソース（リテラル値生成）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ジョブ実行時（随時） |
| 実行時刻 | ジョブスケジュールに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Flinkジョブ実行時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| タプルリスト定義 | RexLiteral形式のタプルリストが定義されていること |
| 型互換性 | リテラル値と出力RowTypeが互換性を持つこと |

### 実行可否判定

タプルリストが空でなく、各タプルの型が出力型と一致すること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| tuples | List<List<RexLiteral>> | Yes | - | リテラル値のタプルリスト |
| outputType | RowType | Yes | - | 出力行の型定義 |
| tableConfig | ReadableConfig | Yes | - | テーブル設定 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| リテラル値 | RexLiteral | SQL/Table APIで指定されたリテラル値 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Transformation<RowData> | RowData | リテラル値から生成されたレコードを後続ノードへ出力 |

### 出力ファイル仕様

ファイル出力はなく、Flink内部のTransformationチェーンへ出力。

## 処理フロー

### 処理シーケンス

```
1. translateToPlanInternal呼び出し
   └─ PlannerBaseとExecNodeConfigを受け取る
2. 親クラスメソッド呼び出し
   └─ super.translateToPlanInternalを呼び出し
3. CommonExecValuesでTransformation生成
   └─ リテラル値からRowDataへの変換
4. 有界マーク付与
   └─ makeLegacySourceTransformationsBoundedを呼び出し
5. Transformation返却
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tuplesリスト取得]
    B --> C[CommonExecValues処理]
    C --> D[Transformation生成]
    D --> E[有界マーク付与]
    E --> F[Transformation返却]
    F --> G[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。リテラル値の生成のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | 型エラー | リテラル型と出力型の不一致 | 型定義を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（静的データ生成） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

リテラル値の生成は決定論的なため、ジョブ再実行で同一結果が得られる。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | タプル数（通常は少量） |
| 目標処理時間 | 即座（メモリ上のデータ） |
| メモリ使用量上限 | タプル数に比例 |

## 排他制御

並列度1で実行（静的データ生成のため）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | タプル数 |
| 終了ログ | 処理完了時 | 生成レコード数 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 出力レコード数 | タプル数と一致 | Flink Metrics |

## 備考

- FlinkVersion v2.0以降で使用可能
- ExecNodeMetadataのname: "batch-exec-values"
- VALUES_TRANSFORMATION定数を使用
- JSON形式でのシリアライズ/デシリアライズ対応（@JsonCreator）
