# バッチ設計書 30-BatchExecPythonCorrelate

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecPythonCorrelateバッチ実行ノードの設計仕様を記述したものです。このノードはPythonユーザー定義テーブル関数（UDTF）との結合処理を実行します。

### 本バッチの処理概要

BatchExecPythonCorrelateは、SQL文のLATERAL TABLE句でPythonテーブル関数を使用する場合のバッチ実行ノードです。入力テーブルの各行に対してPython UDTFを呼び出し、その結果と入力行を結合します。Pythonワーカープロセスと連携し、Python環境で実装されたテーブル関数を評価します。

**業務上の目的・背景**：Pythonエコシステムの豊富なライブラリ（NLPツール、機械学習モデル、データ処理ライブラリなど）を活用して、1行の入力から複数行を生成する処理を実現します。例えば、テキストのトークン化、ML推論結果の複数行展開、複雑なデータ変換などに使用されます。

**バッチの実行タイミング**：Flink SQLクエリの実行時、オプティマイザがPython UDTFを含むLATERAL TABLE句を検出した際に自動的に実行計画に組み込まれます。

**主要な処理内容**：
1. 入力データストリームからレコードを受信
2. Python UDTFに必要な入力フィールドを抽出
3. Pythonワーカープロセスに入力を送信し、UDTFを評価
4. Python UDTFの結果と入力レコードを結合して出力

**前後の処理との関連**：任意のデータソースや変換処理からデータを受け取り、Python UDTF結合後のデータを後続の処理に渡します。Java/Scala UDTFの場合はBatchExecCorrelateが使用されます。

**影響範囲**：Pythonワーカープロセスとの通信オーバーヘッドがあるため、純粋なJava処理より遅延が大きくなる可能性があります。

## バッチ種別

Python UDTFテーブル関数結合処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行（Python UDTF含むLATERAL TABLE句） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 入力データ | 有効なRowData形式のデータストリーム |
| Python環境 | Python実行環境が利用可能 |
| UDTF登録 | Python UDTFがカタログに登録済み |

### 実行可否判定

入力プロパティが1つ、Python UDTFの呼び出し式が有効であれば実行可能です。Python環境が利用できない場合は実行時エラーとなります。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| joinType | FlinkJoinType | Yes | - | 結合タイプ（INNER/LEFT） |
| invocation | RexCall | Yes | - | Python UDTF呼び出し式 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| inputEdge | RowData | 上流の実行ノードからの入力データストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ノード | RowData | 入力レコード + Python UDTF出力 |

### 出力ファイル仕様

N/A（メモリ内処理、下流ノードへのストリーム出力）

## 処理フロー

### 処理シーケンス

```
1. オペレータ生成
   └─ Python設定の抽出
   └─ PythonFunctionInfoの抽出
   └─ UDTF入力オフセットの計算
   └─ Python Table Function Operatorの生成（InProcess or Embedded）
2. 入力レコード処理
   └─ UDTF入力フィールドの射影
   └─ Pythonワーカーへの送信
3. Python処理
   └─ Python UDTFの評価（0行以上の出力）
   └─ 結果の返却
4. 結合処理
   └─ 入力レコードとUDTF出力を結合
   └─ INNER JOIN: 出力がある場合のみ結合
   └─ LEFT JOIN: 出力がない場合はNULL埋め
5. 出力処理
   └─ 結合されたレコードを下流に送信
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Python設定抽出]
    B --> C[PythonFunctionInfo生成]
    C --> D[Python Operator生成]
    D --> E[入力レコード受信]
    E --> F[UDTF入力フィールド射影]
    F --> G[Pythonワーカーへ送信]
    G --> H[Python UDTF評価]
    H --> I{UDTF出力あり?}
    I -->|Yes| J[入力 + UDTF出力を結合]
    J --> K[下流に送信]
    I -->|No| L{LEFT JOIN?}
    L -->|Yes| M[入力 + NULL出力]
    M --> K
    L -->|No| N[スキップ]
    K --> O{次の入力レコード?}
    N --> O
    O -->|Yes| E
    O -->|No| P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のみ）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | Python Operator構築失敗 | Python環境エラー | Python設定確認 |
| RuntimeException | UDTF実行エラー | Python UDTF内で例外発生 | UDTF実装確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（Flinkフレームワーク管理） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Flinkのチェックポイント/リスタート機能による自動リカバリに依存します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | バッチ全体 |
| コミットタイミング | 処理完了時 |
| ロールバック条件 | 処理失敗時（Flink管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力件数 × UDTFの平均出力件数 |
| 目標処理時間 | Python UDTFの複雑度に依存 |
| メモリ使用量上限 | ManagedMemoryUseCaseで管理可能 |

## 排他制御

同一ジョブ内での並列実行はFlinkにより管理されます。各タスクスロットでPythonワーカープロセスが起動されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | オペレータ生成時 | Python Operator生成完了 |
| 進捗ログ | N/A | - |
| 終了ログ | 処理完了時 | 処理完了 |
| エラーログ | エラー発生時 | 例外詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 出力件数 | Flink Metricsで監視 | Flink WebUI |
| Pythonメモリ使用量 | Managed Memory設定 | Flink Metrics |

## 備考

- BatchExecPythonCorrelateはCommonExecPythonCorrelateを継承しています
- 2種類のPython Operatorをサポート：
  - PythonTableFunctionOperator（InProcessモード）
  - EmbeddedPythonTableFunctionOperator（Embeddedモード）
- FlinkJoinTypeでINNER JOINまたはLEFT OUTER JOINを指定可能
- CommonPythonUtil.isPythonWorkerUsingManagedMemory()がtrueの場合、ManagedMemoryUseCase.PYTHONが宣言される
- ProjectionCodeGeneratorでUDTF入力射影コードを動的生成
- PYTHON_CORRELATE_TRANSFORMATIONという名前でTransformationが生成される
- BatchExecCorrelateとは異なり、conditionパラメータはサポートされていません（基底クラスの差異）
