# バッチ設計書 31-BatchExecWindowTableFunction

## 概要

本ドキュメントは、Apache Flinkのバッチ処理におけるウィンドウテーブル値関数（Window Table-Valued Function）の実行ノードである`BatchExecWindowTableFunction`の設計仕様を定義するものです。

### 本バッチの処理概要

BatchExecWindowTableFunctionは、時間属性に基づいてデータをウィンドウに割り当てるバッチ実行ノードです。SQL構文におけるウィンドウテーブル値関数（TUMBLE、HOP、CUMULATE等）をバッチモードで実行するための変換処理を担当します。

**業務上の目的・背景**：時系列データの分析において、データを一定の時間間隔（ウィンドウ）ごとにグループ化する必要があります。例えば、1時間ごとの売上集計、5分間隔のセンサーデータ集約などの業務要件を満たすため、ウィンドウベースのデータ処理が必要となります。本バッチは、このようなウィンドウ処理をバッチモードで効率的に実行するための基盤を提供します。

**バッチの実行タイミング**：クエリ実行時にプランナーによって自動的に生成・実行されます。ユーザーがTUMBLE、HOP、CUMULATEなどのウィンドウテーブル値関数を使用したSQLクエリを実行した際に、クエリプランの一部として組み込まれます。

**主要な処理内容**：
1. 入力データの時間属性フィールドを解析し、ウィンドウ割り当て戦略（TimeAttributeWindowingStrategy）を適用
2. 整列ウィンドウ（Aligned Window：TUMBLE、HOP、CUMULATE）の場合、AlignedWindowTableFunctionOperatorを使用してウィンドウ境界を計算
3. 各入力レコードに対してウィンドウの開始時刻・終了時刻・タイムスタンプを付与した出力レコードを生成
4. タイムゾーンを考慮したウィンドウ境界の計算（ShiftTimeZone対応）

**前後の処理との関連**：前段としてBatchExecTableSourceScanやBatchExecCalc等からのデータ入力を受け取ります。後段としてBatchExecHashWindowAggregateやBatchExecSortWindowAggregate等のウィンドウ集約処理に接続されることが一般的です。

**影響範囲**：ウィンドウテーブル値関数を使用するすべてのバッチSQLクエリに影響します。特にイベント時間ベースの時系列分析処理全般に関係します。

## バッチ種別

データ変換 / ウィンドウ処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 時間属性の存在 | 入力データに有効な時間属性フィールドが存在すること |
| イベント時間使用 | バッチモードではイベント時間（Event Time）のみサポート。処理時間（Processing Time）は未サポート |
| 整列ウィンドウ | バッチモードではセッションウィンドウ等の非整列ウィンドウは未サポート |

### 実行可否判定

ウィンドウ戦略がイベント時間ベースかつ整列ウィンドウである場合のみ実行可能。処理時間ウィンドウや非整列ウィンドウを指定した場合はTableExceptionがスローされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| windowingStrategy | TimeAttributeWindowingStrategy | Yes | - | ウィンドウ割り当て戦略（ウィンドウタイプ、サイズ、スライド等を含む） |
| inputProperty | InputProperty | Yes | - | 入力プロパティ（分散特性、優先度等） |
| outputType | RowType | Yes | - | 出力行の型定義 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 上流ExecNode | RowData | 時間属性フィールドを含む入力レコードストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ExecNode | RowData | 入力カラム＋ウィンドウ開始/終了/タイムスタンプを含む出力レコード |

### 出力ファイル仕様

N/A（メモリ内データ変換のため）

## 処理フロー

### 処理シーケンス

```
1. ウィンドウ戦略の検証
   └─ 処理時間ウィンドウの場合はエラー
2. ウィンドウタイプの判定
   └─ 整列/非整列ウィンドウの判別
3. 整列ウィンドウの場合：AlignedWindowTableFunctionOperator生成
   └─ GroupWindowAssignerの作成
   └─ タイムゾーン設定の適用
   └─ オペレーターの初期化
4. 入力変換の接続
   └─ OneInputTransformationの生成
5. 出力型情報の設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{処理時間か?}
    B -->|Yes| C[TableException: 未サポート]
    B -->|No| D{整列ウィンドウか?}
    D -->|Yes| E[AlignedWindowTableFunctionOperator生成]
    D -->|No| F[TableException: 未サポート]
    E --> G[GroupWindowAssigner作成]
    G --> H[タイムゾーン設定]
    H --> I[OneInputTransformation生成]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のため）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | 未サポート機能 | 処理時間ウィンドウを指定 | イベント時間ベースのクエリに変更 |
| TableException | 未サポート機能 | セッションウィンドウ（非整列）を指定 | TUMBLE/HOP/CUMULATEを使用 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（設計エラーのため再試行不可） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

クエリ定義の見直しが必要。バッチモードでサポートされているウィンドウタイプとイベント時間を使用するようにクエリを修正する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ストリーミング変換） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力データ量に依存 |
| 目標処理時間 | レイテンシは入力並列度に依存 |
| メモリ使用量上限 | オペレーター単位で管理メモリを使用 |

## 排他制御

並列実行可能。各パーティションは独立して処理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| DEBUG | 変換生成時 | ウィンドウ戦略の詳細 |
| ERROR | エラー発生時 | 未サポート機能使用時の詳細メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理遅延 | アプリケーション定義 | Flinkメトリクス |
| エラー率 | アプリケーション定義 | Flinkメトリクス |

## 備考

- Flink 2.0以降で利用可能
- セッションウィンドウのバッチモードサポートは将来のバージョンで追加予定
- 処理時間ウィンドウはストリーミングモードでのみ有効
