# バッチ設計書 32-BatchExecMatch

## 概要

本ドキュメントは、Apache FlinkのバッチSQL処理におけるMATCH_RECOGNIZE句によるパターンマッチング実行ノードである`BatchExecMatch`の設計仕様を定義するものです。

### 本バッチの処理概要

BatchExecMatchは、SQLのMATCH_RECOGNIZE句を使用した複合イベント処理（CEP: Complex Event Processing）パターンマッチングをバッチモードで実行するためのノードです。時系列データ内の特定のパターンシーケンスを検出し、マッチした結果を出力します。

**業務上の目的・背景**：時系列データ分析において、特定のイベントパターンを検出する要件は非常に一般的です。例えば、株価の上昇・下降パターン検出、ユーザー行動シーケンスの分析、不正検知における異常パターン検出などの業務課題を解決するために、SQLベースのパターンマッチング機能が必要とされます。本バッチは、MATCH_RECOGNIZE句をバッチデータに対して適用し、履歴データからパターンを抽出する機能を提供します。

**バッチの実行タイミング**：MATCH_RECOGNIZEを含むSQLクエリの実行時に、クエリプランナーによって自動的に生成・実行されます。履歴データの分析やレポート生成時に使用されることが一般的です。

**主要な処理内容**：
1. 入力データのORDER BY句に基づくソート順序の検証（時間属性が先頭で昇順であること）
2. イベント時間使用時はタイムスタンプ挿入変換（StreamRecordTimestampInserter）を適用
3. パターン定義（PATTERN句）からCEPパターンオブジェクトを構築
4. NFAコンパイラによる非決定性有限オートマトン（NFA）ファクトリの生成
5. パーティションキーに基づくデータのグループ化
6. CepOperatorによるパターンマッチング実行
7. MEASURES句に基づくマッチ結果の出力生成

**前後の処理との関連**：前段としてBatchExecTableSourceScan、BatchExecCalc、BatchExecSort等からソート済みの入力データを受け取ります。PARTITION BY句がある場合は、BatchExecExchangeによるデータ再分散が先行します。後段としてBatchExecSink、BatchExecCalc等に結果を出力します。

**影響範囲**：MATCH_RECOGNIZE句を使用するすべてのバッチSQLクエリに影響します。時系列パターン分析、シーケンス検出、複合イベント処理全般に関係します。

## バッチ種別

パターンマッチング / 複合イベント処理（CEP）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | SQLクエリ実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ORDER BY必須 | 非空のORDER BY句が必須。最初のソートキーは時間属性で昇順 |
| パターン定義 | 空マッチを生成しないパターン（少なくとも1つの非オプション状態が必要） |
| 貪欲量化子制限 | パターン末尾に貪欲量化子は使用不可 |
| 出力モード | ALL ROWS PER MATCHは未サポート（ONE ROW PER MATCHのみ） |

### 実行可否判定

ORDER BY句の検証が行われ、先頭フィールドが時間属性（DATE/TIME/TIMESTAMP）で昇順であることが必須。条件を満たさない場合はTableExceptionがスローされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| matchSpec | MatchSpec | Yes | - | パターン定義、MEASURES、PARTITION BY、ORDER BY等の仕様 |
| inputProperty | InputProperty | Yes | - | 入力プロパティ |
| outputType | RowType | Yes | - | 出力行の型定義 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 上流ExecNode | RowData | ORDER BYでソート済みの入力レコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ExecNode | RowData | MEASURES句で定義されたカラムを含むマッチ結果 |

### 出力ファイル仕様

N/A（メモリ内データ処理のため）

## 処理フロー

### 処理シーケンス

```
1. ORDER BY検証
   └─ 先頭フィールドが時間属性かつ昇順であることを確認
2. タイムスタンプ挿入（イベント時間の場合）
   └─ StreamRecordTimestampInserterによるタイムスタンプ埋め込み
3. CEPパターン構築
   └─ PATTERN句からPattern<RowData, RowData>オブジェクトを生成
4. パターン検証
   └─ 空マッチ生成パターンの拒否
   └─ 末尾貪欲量化子の拒否
5. NFAファクトリ生成
   └─ NFACompiler.compileFactoryによるNFAファクトリ作成
6. PatternProcessFunctionRunner生成
   └─ MatchCodeGeneratorによるコード生成
7. CepOperator構築・実行
   └─ パーティションキーセレクターの設定
   └─ マッチング処理の実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{ORDER BY検証}
    B -->|失敗| C[TableException]
    B -->|成功| D{処理時間か?}
    D -->|Yes| E[入力そのまま]
    D -->|No| F[タイムスタンプ挿入変換]
    E --> G[CEPパターン構築]
    F --> G
    G --> H{パターン検証}
    H -->|空マッチ| I[TableException]
    H -->|末尾貪欲量化子| J[TableException]
    H -->|OK| K[NFAファクトリ生成]
    K --> L[CepOperator構築]
    L --> M[パターンマッチング実行]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のため）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | ORDER BY不正 | ORDER BY句が空 | 非空のORDER BYを指定 |
| TableException | ORDER BY不正 | 先頭が時間属性でない | 時間属性フィールドを先頭に |
| TableException | ORDER BY不正 | 先頭が降順 | 昇順に変更 |
| TableException | パターン不正 | 空マッチ生成可能なパターン | 非オプション状態を追加 |
| TableException | パターン不正 | 末尾が貪欲量化子 | reluctant量化子に変更 |
| TableException | 未サポート | ALL ROWS PER MATCH指定 | ONE ROW PER MATCHを使用 |
| TableException | 未サポート | PERMUTE/ALTER/EXCLUDEパターン | サポートされているパターンに変更 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（設計エラーのため） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

クエリ定義の修正が必要。ORDER BY句、パターン定義、出力モードを見直す。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ストリーミング変換） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力データ量とパターン複雑度に依存 |
| 目標処理時間 | パターンの状態数と入力量に依存 |
| メモリ使用量上限 | NFA状態管理用にマネージドメモリを使用 |

## 排他制御

PARTITION BYで指定されたキーごとに独立して処理。パーティション間は並列実行可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| DEBUG | パターン構築時 | 生成されたパターン構造 |
| DEBUG | NFA生成時 | NFA状態遷移情報 |
| ERROR | エラー発生時 | 検証エラーの詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| マッチ数 | アプリケーション定義 | Flinkメトリクス |
| 処理遅延 | アプリケーション定義 | Flinkメトリクス |

## 備考

- Flink 2.0以降で利用可能
- CEPライブラリ（flink-cep）に依存
- ブランチパターン（PATTERN_ALTER）は未サポート
- PERMUTEパターンは未サポート
- EXCLUDEパターン（{- -}）は未サポート
- reluctantオプション変数は未サポート
