# バッチ設計書 34-BatchExecInputAdapter

## 概要

本ドキュメントは、Apache Flinkのバッチ処理における複数オペレーター融合コード生成の入力アダプターである`BatchExecInputAdapter`の設計仕様を定義するものです。

### 本バッチの処理概要

BatchExecInputAdapterは、複数オペレーター融合コード生成（Operator Fusion Codegen）において、外部入力をMultipleInputオペレーター内部に適応させるためのアダプターノードです。BatchExecMultipleInputの内部で使用され、各入力ストリームを識別・管理します。

**業務上の目的・背景**：分散バッチ処理において、複数のオペレーターを単一のオペレーターに融合することで、オペレーター間のシリアライゼーション/デシリアライゼーションのオーバーヘッドを削減し、処理効率を向上させることができます。本バッチは、この融合処理において外部入力を内部処理に接続するためのブリッジとして機能し、複数入力の識別と適切なルーティングを実現します。

**バッチの実行タイミング**：BatchExecMultipleInputノードが生成される際に、オペレーター融合コード生成が有効な場合に自動的に生成されます。クエリ最適化フェーズで複数オペレーターの融合が決定された際に使用されます。

**主要な処理内容**：
1. multipleInputIdによる入力ストリームの一意識別
2. 入力変換（Transformation）のパススルー
3. 融合コード生成時のSourceOpFusionCodegenSpecGeneratorの提供
4. InputAdapterFusionCodegenSpecの生成（コード生成コンテキストと入力IDの紐付け）

**前後の処理との関連**：前段としてBatchExecExchange等からの入力を受け取ります。後段としてBatchExecMultipleInput内部の融合オペレーターに接続されます。通常のクエリプランでは直接可視化されず、MultipleInput最適化の内部実装詳細です。

**影響範囲**：オペレーター融合コード生成が有効な場合のBatchExecMultipleInputの内部処理に影響します。融合最適化のパフォーマンス向上に貢献します。

## バッチ種別

データ交換 / 入力適応

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | MultipleInput最適化 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| MultipleInput内部 | BatchExecMultipleInputの内部でのみ使用 |
| 融合コード生成有効 | TABLE_EXEC_OPERATOR_FUSION_CODEGEN_ENABLEDがtrue |
| 入力ID一意性 | multipleInputIdが一意であること |

### 実行可否判定

常に実行可能。入力変換をパススルーするため、特別な条件チェックは不要。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| multipleInputId | int | Yes | - | MultipleInput内での入力識別ID |
| inputProperty | InputProperty | Yes | - | 入力プロパティ |
| outputType | LogicalType | Yes | - | 出力型定義 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 上流ExecNode | RowData | MultipleInputへの入力ストリーム |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 融合オペレーター内部 | RowData | 入力データをそのまま渡す |

### 出力ファイル仕様

N/A（内部データ適応のため）

## 処理フロー

### 処理シーケンス

```
1. 入力変換の取得
   └─ 入力エッジから変換を取得
2. パススルー
   └─ 入力変換をそのまま返却
3. 融合コード生成（supportFusionCodegen有効時）
   └─ SourceOpFusionCodegenSpecGenerator生成
   └─ InputAdapterFusionCodegenSpec生成
   └─ multipleInputIdとの紐付け
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力変換取得]
    B --> C{融合コード生成?}
    C -->|Yes| D[SourceOpFusionCodegenSpecGenerator生成]
    C -->|No| E[入力変換をパススルー]
    D --> F[InputAdapterFusionCodegenSpec生成]
    F --> G[multipleInputIdとの紐付け]
    G --> H[バッチ終了]
    E --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のため）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | N/A | N/A | N/A |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

入力アダプターは単純なパススルー処理のため、障害発生時は上流または下流の問題を調査する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（パススルー処理） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力データ量に依存 |
| 目標処理時間 | オーバーヘッドなし（パススルー） |
| メモリ使用量上限 | 最小限（メタデータのみ） |

## 排他制御

並列実行可能。各入力ストリームは独立して処理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| DEBUG | コード生成時 | multipleInputIdとコンテキスト情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| N/A | N/A | N/A |

## 備考

- BatchExecMultipleInput内部でのみ使用される内部コンポーネント
- supportFusionCodegenがtrueを返し、融合コード生成をサポート
- @ExecNodeMetadataアノテーションが付与されていない（永続化対象外）
- プラン可視化時には通常表示されない内部ノード
- 入力変換をそのまま返すため、実行時オーバーヘッドは最小限
