# バッチ設計書 35-BatchExecExecutionOrderEnforcer

## 概要

本ドキュメントは、Apache Flinkのバッチ処理における実行順序強制を担当する実行ノードである`BatchExecExecutionOrderEnforcer`の設計仕様を定義するものです。

### 本バッチの処理概要

BatchExecExecutionOrderEnforcerは、2つの入力を持ち、一方（ソース）の実行をもう一方（依存入力）の完了後に強制的に開始させるための実行ノードです。主にダイナミックフィルタリング機能の実装に使用され、フィルタリングデータの収集完了後にソーススキャンを開始することで、不要なデータの読み込みを削減します。

**業務上の目的・背景**：大規模なバッチ処理において、結合処理の効率化は非常に重要です。ダイナミックフィルタリングは、結合のビルド側からフィルタ条件を抽出し、プローブ側のソーススキャン時に適用することで、読み込むデータ量を大幅に削減できます。本バッチは、フィルタリングデータが確実に収集された後にソーススキャンを開始するための実行順序制御を提供します。

**バッチの実行タイミング**：ダイナミックフィルタリングが有効なクエリで、BatchExecDynamicFilteringDataCollectorとBatchExecTableSourceScanの間に挿入されます。クエリプランナーが自動的に生成します。

**主要な処理内容**：
1. 2つの入力の受け取り（入力0: ダイナミックフィルタリング入力、入力1: ソース入力）
2. ダイナミックフィルタリングデータコレクターのリスナーID取得と設定
3. ソース変換へのコーディネーターリスニングID設定
4. ExecutionOrderEnforcerCodeGeneratorによるオペレーターコード生成
5. TwoInputTransformationの構築と接続
6. ソースとのチェイニング設定

**前後の処理との関連**：前段として入力0にBatchExecDynamicFilteringDataCollector（またはExchange経由）、入力1にBatchExecTableSourceScanを受け取ります。後段として結合処理（BatchExecHashJoin等）に接続されます。

**影響範囲**：ダイナミックフィルタリングが有効なすべてのバッチJOINクエリに影響します。特にファクトテーブルとディメンションテーブルの結合において、スキャン効率の向上に貢献します。

## バッチ種別

データ交換 / 実行順序制御

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | ダイナミックフィルタリング有効時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ダイナミックフィルタリング有効 | クエリでダイナミックフィルタリングが適用されていること |
| 入力0がDynamicFilteringDataCollector | 入力0がBatchExecDynamicFilteringDataCollector（またはExchange経由）であること |
| 入力1がTableSourceScan | 入力1がBatchExecTableSourceScanであること |
| ソースとのチェイン | ソースとのチェイニングが有効であること（無効の場合は正常動作しない） |

### 実行可否判定

ダイナミックフィルタリングが設定された場合に自動的に挿入される。チェイニングが明示的に無効化されている場合は正常に動作しない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| inputProperties | List<InputProperty> | Yes | - | 2つの入力プロパティ |
| outputType | LogicalType | Yes | - | 出力型定義（入力1と同一） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 入力0（依存入力） | RowData | DynamicFilteringDataCollectorからのフィルタリングデータ（通常は空） |
| 入力1（ソース入力） | RowData | TableSourceScanからのソースデータ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ExecNode | RowData | 入力1のデータをそのまま出力（入力0は通常空） |

### 出力ファイル仕様

N/A（メモリ内データ処理のため）

## 処理フロー

### 処理シーケンス

```
1. 入力変換の取得
   └─ 入力0: DynamicFilteringDataCollector変換
   └─ 入力1: TableSourceScan変換
2. DynamicFilteringDataListenerIDの設定
   └─ DynamicFilteringDataCollectorからリスナーIDを取得
   └─ SourceTransformationにコーディネーターリスニングIDを設定
   └─ DynamicFilteringDataCollectorOperatorFactoryにリスナーIDを登録
3. オペレーターコード生成
   └─ ExecutionOrderEnforcerCodeGeneratorによるコード生成
4. TwoInputTransformation構築
   └─ 2つの入力変換を接続
   └─ 並列度はソース入力に合わせる
5. 出力
   └─ 入力0の完了後に入力1のデータをフォワード
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力変換取得]
    B --> C[DynamicFilteringDataListenerID取得]
    C --> D[SourceTransformationにID設定]
    D --> E[CollectorOperatorFactoryにID登録]
    E --> F[ExecutionOrderEnforcerCodeGenerator実行]
    F --> G[TwoInputTransformation構築]
    G --> H[入力0完了待機]
    H --> I[入力1データフォワード]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のため）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | 動作異常 | チェイニングが無効化されている場合 | チェイニング設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ダイナミックフィルタリングの設定とソースとのチェイニング設定を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（順序制御） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力1のデータ量に依存 |
| 目標処理時間 | オーバーヘッド最小限（フォワード処理） |
| メモリ使用量上限 | 最小限（入力0は通常空） |

## 排他制御

並列実行可能。各パーティションは独立して処理される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| DEBUG | ID設定時 | DynamicFilteringDataListenerIDの値 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 待機時間 | アプリケーション定義 | Flinkメトリクス |

## 備考

- @ExecNodeMetadataアノテーションが付与されていない（永続化対象外）
- supportFusionCodegenがtrueを返し、融合コード生成をサポート
- TwoInputOpFusionCodegenSpecGeneratorとExecutionOrderEnforcerFusionCodegenSpecを使用
- ソースとのチェイニングが必須（ChainingStrategy.HEAD_WITH_SOURCES相当）
- 入力0（DynamicFiltering側）は通常データを送信しないが、実行完了を通知
- DynamicFilteringEventをソースコーディネーターに送信することでフィルタリングを実現
