# バッチ設計書 38-BatchExecScriptTransform

## 概要

本ドキュメントは、Apache Flinkのバッチ処理における外部スクリプトを使用したデータ変換を担当する実行ノードである`BatchExecScriptTransform`の設計仕様を定義するものです。

### 本バッチの処理概要

BatchExecScriptTransformは、外部スクリプト（シェルスクリプト等）を使用してデータを変換するバッチ実行ノードです。主にHive方言のTRANSFORM句をサポートするために実装されており、HiveScriptTransformOperatorを通じて外部プロセスとの入出力を処理します。

**業務上の目的・背景**：データ処理パイプラインにおいて、既存のシェルスクリプトやPythonスクリプト等の外部ツールを活用したデータ変換が必要になる場合があります。特にHiveからFlinkへの移行シナリオでは、Hive SQLのTRANSFORM句を使用した既存クエリとの互換性が求められます。本バッチは、このような外部スクリプトベースの変換処理をバッチモードで実行するための機能を提供します。

**バッチの実行タイミング**：Hive方言が有効なSQLクエリでTRANSFORM句が使用された場合に、クエリプランナーによって自動的に生成されます。

**主要な処理内容**：
1. 入力データの特定フィールド（inputIndexes）を選択
2. 選択したフィールドを外部スクリプトの標準入力に送信
3. 外部スクリプト（script）の実行
4. スクリプトの標準出力を読み取り、出力レコードとしてパース
5. ScriptTransformIOInfoに基づく入出力フォーマットの変換

**前後の処理との関連**：前段として任意のBatchExecNodeからのデータを受け取ります。後段としてBatchExecCalc、BatchExecSink等に接続されます。

**影響範囲**：Hive方言のTRANSFORM句を使用するすべてのバッチクエリに影響します。外部スクリプトのパフォーマンスと信頼性がクエリ全体に影響します。

## バッチ種別

変換処理 / 外部スクリプト実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | クエリ実行時（随時） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | TRANSFORM句使用時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Hive方言有効 | SQLクエリがHive方言で記述されていること |
| スクリプト存在 | 指定された外部スクリプトが実行可能な状態であること |
| HiveScriptTransformOperator存在 | flink-connectors-hive依存関係が存在すること |

### 実行可否判定

HiveScriptTransformOperatorクラスがクラスパスに存在する場合のみ実行可能。クラスが見つからない場合はTableExceptionがスローされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| inputIndexes | int[] | Yes | - | スクリプトに渡す入力フィールドのインデックス配列 |
| script | String | Yes | - | 実行する外部スクリプト（コマンド） |
| scriptTransformIOInfo | ScriptTransformIOInfo | Yes | - | 入出力フォーマット情報 |
| inputType | LogicalType | Yes | - | 入力行の型 |
| outputType | LogicalType | Yes | - | 出力行の型 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 上流ExecNode | RowData | 変換対象の入力レコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 下流ExecNode | RowData | スクリプト出力から生成されたレコード |

### 出力ファイル仕様

N/A（メモリ内データ処理のため）

## 処理フロー

### 処理シーケンス

```
1. 入力変換の取得
   └─ 入力エッジから変換を取得
2. HiveScriptTransformOperatorの生成
   └─ リフレクションによるクラスロード
   └─ コンストラクタ呼び出し（inputIndexes, script, scriptTransformIOInfo, inputType, outputType）
3. OneInputTransformationの構築
   └─ SimpleOperatorFactoryでラップ
   └─ 並列度は入力と同一
4. 外部スクリプト実行（ランタイム）
   └─ 入力レコードをシリアライズしてスクリプトに送信
   └─ スクリプト出力をパースして出力レコードを生成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[入力変換取得]
    B --> C[HiveScriptTransformOperatorクラスロード]
    C --> D{クラス存在?}
    D -->|No| E[TableException]
    D -->|Yes| F[コンストラクタ呼び出し]
    F --> G[OneInputTransformation構築]
    G --> H[入力レコード取得]
    H --> I[スクリプトに送信]
    I --> J[スクリプト実行]
    J --> K[出力パース]
    K --> L[出力レコード生成]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

N/A（インメモリ処理のため）

### テーブル別操作詳細

N/A

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TableException | クラス未発見 | HiveScriptTransformOperatorが見つからない | flink-connectors-hive依存関係を追加 |
| TableException | コンストラクタエラー | オペレーター生成に失敗 | スクリプト設定とクラスパスを確認 |
| RuntimeException | スクリプトエラー | 外部スクリプトが異常終了 | スクリプトのデバッグ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A（スクリプトエラーは再試行不可） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

外部スクリプトのパス、権限、実行環境を確認。flink-connectors-hive依存関係の存在を確認。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（外部スクリプト実行） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力データ量に依存 |
| 目標処理時間 | 外部スクリプトの処理速度に依存 |
| メモリ使用量上限 | 外部プロセスとの通信バッファに依存 |

## 排他制御

並列実行可能。各タスクは独立したスクリプトプロセスを起動。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| DEBUG | オペレーター生成時 | スクリプトパスと設定情報 |
| ERROR | スクリプトエラー時 | エラーメッセージとスタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| スクリプト実行時間 | アプリケーション定義 | Flinkメトリクス |
| スクリプト失敗率 | アプリケーション定義 | Flinkメトリクス |

## 備考

- @ExecNodeMetadataアノテーションが付与されていない（永続化対象外）
- SingleTransformationTranslatorを実装
- HiveScriptTransformOperatorのクラス名は固定:
  - `org.apache.flink.table.runtime.operators.hive.script.HiveScriptTransformOperator`
- リフレクションを使用したクラスロード（flink-connectors-hiveが必須）
- ExecNodeContextにBatchExecLimitを使用（永続化対象外のため実害なし）
- Hive方言のTRANSFORM句との互換性を提供
- スクリプトはTabSeparatedなど、ScriptTransformIOInfoで指定されたフォーマットで入出力を行う
