# バッチ設計書 4-BatchExecLegacyTableSourceScan

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecLegacyTableSourceScanバッチ実行ノードの設計仕様を記載する。このノードは、レガシーAPI（StreamTableSource）を使用したテーブルソースからデータを読み取るバッチ処理を担当する。

### 本バッチの処理概要

BatchExecLegacyTableSourceScanは、Flinkの旧API（StreamTableSource）で定義されたテーブルソースからデータを読み取る実行ノードである。新しいDynamicTableSourceへの移行が推奨されているが、レガシーコネクタとの後方互換性を維持するために存在する。

**業務上の目的・背景**：Flink 1.x系で開発されたレガシーコネクタを使用するアプリケーションとの後方互換性を維持する。新APIへの段階的移行期間中に、既存のStreamTableSourceベースのコネクタを継続利用可能にする。

**バッチの実行タイミング**：Flinkジョブのバッチ実行時に、レガシーテーブルソースからの入力ノードとして実行される。有界StreamTableSourceからのデータ読み取りを前提とする。

**主要な処理内容**：
1. CommonExecLegacyTableSourceScanの親クラスメソッドでTransformationを生成
2. 必要に応じて内部行形式（RowData）への変換を適用
3. 型精度の修正（DDL定義に合わせた精度調整）
4. レガシー変換に有界性マークを付与

**前後の処理との関連**：前提となるバッチはなく、レガシーデータソースからの入力として機能する。後続にはTable APIの各種処理ノードが接続される。

**影響範囲**：レガシーAPIの型システムと新APIの型システム間の変換が発生するため、型精度に注意が必要。

## バッチ種別

データソース（レガシーAPI入力）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ジョブ実行時（随時） |
| 実行時刻 | ジョブスケジュールに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Flinkジョブ実行時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| レガシーテーブルソース | StreamTableSourceが定義されていること |
| 有界データ | テーブルソースが有界データを提供すること |

### 実行可否判定

StreamTableSourceが利用可能であり、有界データを提供すること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| tableSource | TableSource<?> | Yes | - | レガシーテーブルソース |
| qualifiedName | List<String> | Yes | - | テーブルの完全修飾名 |
| outputType | RowType | Yes | - | 出力行の型定義 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| StreamTableSource | レガシーAPI | 旧APIで定義されたテーブルソース |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Transformation<RowData> | RowData | 変換されたレコードを後続ノードへ出力 |

### 出力ファイル仕様

ファイル出力はなく、Flink内部のTransformationチェーンへ出力。

## 処理フロー

### 処理シーケンス

```
1. translateToPlanInternal呼び出し
   └─ PlannerBaseとExecNodeConfigを受け取る
2. 親クラスメソッド呼び出し
   └─ CommonExecLegacyTableSourceScan処理
3. 有界マーク付与
   └─ makeLegacySourceTransformationsBoundedを呼び出し
4. 変換Transformation生成（必要時）
   └─ createConversionTransformationIfNeeded
5. InputFormat Transformation生成
   └─ createInputでInputFormatSourceFunctionを使用
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[StreamTableSource取得]
    B --> C[親クラス処理呼び出し]
    C --> D[有界マーク付与]
    D --> E{内部変換が必要?}
    E -->|Yes| F[convertToInternalRow呼び出し]
    E -->|No| G[元のTransformationを使用]
    F --> H[型精度修正]
    H --> I[Transformation返却]
    G --> I
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| データ読み取り | 外部テーブル | SELECT | レガシーコネクタ経由で読み取り |

### テーブル別操作詳細

コネクタ実装依存。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ClassCastException | 型変換エラー | レガシー型と新型の不一致 | 型定義確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | コネクタ実装依存 |
| リトライ間隔 | コネクタ実装依存 |
| リトライ対象エラー | 一時的な接続エラー |

### 障害時対応

ジョブ失敗時はFlinkのリスタート機構に従い再実行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | コネクタ実装依存 |
| コミットタイミング | 読み取り専用のため該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ソースデータ量依存 |
| 目標処理時間 | 並列度・データ量依存 |
| メモリ使用量上限 | TaskManager設定に従う |

## 排他制御

並列実行可能。各タスクは独立したパーティション/スプリットを処理。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | ソース名 |
| 終了ログ | 処理完了時 | 処理件数 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理レコード数/秒 | ジョブ定義依存 | Flink Metrics |

## 備考

- レガシーAPIとの後方互換性のために存在
- 新規開発ではBatchExecTableSourceScan（DynamicTableSource）の使用を推奨
- InputFormatSourceFunctionを使用してInputFormatをサポート
- 型精度はTableSourceUtil.fixPrecisionForProducedDataTypeで修正
