# バッチ設計書 7-BatchExecHashJoin

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecHashJoinバッチ実行ノードの設計仕様を記載する。このノードは、ハッシュベースの結合演算子を実装し、ビルドサイドのハッシュテーブルを構築してプローブサイドと結合する。

### 本バッチの処理概要

BatchExecHashJoinは、Flinkバッチ実行プランにおいて、2つの入力データセットをハッシュ結合するための実行ノードである。ビルドサイドからハッシュテーブルを構築し、プローブサイドのレコードでハッシュテーブルを検索して結合を実行する。

**業務上の目的・背景**：SQLのJOIN句やTable APIのjoin操作を効率的に実行する。特に一方のテーブルがメモリに収まる場合に高いパフォーマンスを発揮する。INNER JOIN、LEFT JOIN、RIGHT JOIN、SEMI JOIN、ANTI JOINをサポート。

**バッチの実行タイミング**：Flinkジョブのバッチ実行時に、結合対象の両入力が準備できた時点で実行される。ビルドサイドが先に完全に読み込まれ、その後プローブサイドの処理が開始される。

**主要な処理内容**：
1. 左右の入力Transformationを取得
2. 結合条件（等価条件・非等価条件）からGeneratedJoinConditionを生成
3. ハッシュ結合オペレータファクトリを生成
4. ビルドサイドとプローブサイドを決定してTransformationを生成
5. マネージドメモリを使用したスピル対応

**前後の処理との関連**：上流のスキャン、フィルタ、射影などのノードから入力を受け取る。後続には集約、ソート、別の結合などが接続可能。

**影響範囲**：メモリ使用量、スピル設定、並列度が結合性能に直接影響。

## バッチ種別

結合処理（Hash Join）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ジョブ実行時（随時） |
| 実行時刻 | ジョブスケジュールに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Flinkジョブ実行時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 結合キー定義 | 等価結合条件（JOIN ON）が定義されていること |
| 入力データ | 左右両方の入力Transformationが利用可能であること |

### 実行可否判定

結合条件が存在し、両入力が準備完了であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| joinSpec | JoinSpec | Yes | - | 結合仕様（結合タイプ、キー、条件） |
| isBroadcast | boolean | Yes | - | ブロードキャスト結合か |
| leftIsBuild | boolean | Yes | - | 左側がビルドサイドか |
| estimatedLeftAvgRowSize | int | Yes | - | 左入力の推定平均行サイズ |
| estimatedRightAvgRowSize | int | Yes | - | 右入力の推定平均行サイズ |
| estimatedLeftRowCount | long | Yes | - | 左入力の推定行数 |
| estimatedRightRowCount | long | Yes | - | 右入力の推定行数 |
| tryDistinctBuildRow | boolean | Yes | - | ビルド行の重複排除を試みるか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 左入力 | Transformation<RowData> | 結合の左側入力 |
| 右入力 | Transformation<RowData> | 結合の右側入力 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Transformation<RowData> | RowData | 結合結果を後続ノードへ出力 |

### 出力ファイル仕様

ファイル出力はなく、Flink内部のTransformationチェーンへ出力。

## 処理フロー

### 処理シーケンス

```
1. translateToPlanInternal呼び出し
   └─ PlannerBaseとExecNodeConfigを受け取る
2. 左右の入力Transformation取得
   └─ getInputEdges()から取得
3. 入力型取得
   └─ RowTypeを取得
4. 結合条件生成
   └─ JoinUtil.generateConditionFunction
5. ハッシュ結合オペレータ生成
   └─ HashJoinOperatorUtil.generateOperatorFactory
6. ビルド/プローブサイド決定
   └─ leftIsBuildに基づいて決定
7. TwoInputTransformation生成
   └─ ExecNodeUtil.createTwoInputTransformation
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[左右入力取得]
    B --> C[入力型取得]
    C --> D[結合条件生成]
    D --> E[ハッシュ結合オペレータ生成]
    E --> F{leftIsBuild?}
    F -->|Yes| G[左=ビルド, 右=プローブ]
    F -->|No| H[右=ビルド, 左=プローブ]
    G --> I[TwoInputTransformation生成]
    H --> I
    I --> J[Transformation返却]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。メモリ上での結合処理のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OutOfMemoryError | メモリ不足 | ハッシュテーブルがメモリを超過 | メモリ設定増加またはスピル有効化 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（Flinkリスタートに依存） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ジョブ失敗時はFlinkのリスタート機構に従い再実行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（中間処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力データ量依存 |
| 目標処理時間 | 並列度・データ量依存 |
| メモリ使用量上限 | table.exec.resource.hash-join.memory設定 |

## 排他制御

並列実行可能。各タスクは独立したパーティションを処理。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 結合開始時 | 結合タイプ、ビルドサイド |
| 終了ログ | 結合完了時 | 結合結果件数 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理レコード数/秒 | ジョブ定義依存 | Flink Metrics |
| スピル発生回数 | 0 | Flink Metrics |

## 備考

- FlinkVersion v2.0以降で使用可能
- ExecNodeMetadataのname: "batch-exec-join"
- 消費オプション: table.exec.resource.hash-join.memory, table.exec.spill-compression.enabled等
- AdaptiveJoinExecNodeインターフェースを実装し、適応型結合への変換をサポート
- Fusion Codegenをサポート（supportFusionCodegen）
- FULL JOINはハッシュ結合でサポートされない（toAdaptiveJoinNodeで除外）
- LongHashJoinGeneratorでlong型キーの最適化をサポート
