# バッチ設計書 8-BatchExecSortMergeJoin

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecSortMergeJoinバッチ実行ノードの設計仕様を記載する。このノードは、ソートマージ結合を実装し、両側をソートしてからマージ結合を実行する。

### 本バッチの処理概要

BatchExecSortMergeJoinは、Flinkバッチ実行プランにおいて、2つの入力データセットをソートマージ結合するための実行ノードである。両入力を結合キーでソートし、マージ処理によって結合を実行する。大規模データセット同士の結合に適している。

**業務上の目的・背景**：SQLのJOIN句やTable APIのjoin操作を実行する。特に両側のテーブルが大きく、メモリに収まらない場合にハッシュ結合より効率的。INNER JOIN、LEFT JOIN、RIGHT JOIN、FULL OUTER JOINをサポート。

**バッチの実行タイミング**：Flinkジョブのバッチ実行時に、結合対象の両入力が準備できた時点で実行される。両入力がソート済みであることを前提とする（前段でソート処理が挿入される）。

**主要な処理内容**：
1. 左右の入力Transformationを取得
2. 外部バッファとソート用のメモリを確保
3. 結合条件からGeneratedJoinConditionを生成
4. ソートマージ結合オペレータファクトリを生成
5. TwoInputTransformationを生成

**前後の処理との関連**：上流にはBatchExecSortやBatchExecExchangeが接続され、ソート済みデータが入力される。後続には集約、別の結合などが接続可能。

**影響範囲**：メモリ使用量（外部バッファ、ソートメモリ）が結合性能に直接影響。

## バッチ種別

結合処理（Sort Merge Join）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ジョブ実行時（随時） |
| 実行時刻 | ジョブスケジュールに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Flinkジョブ実行時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 結合キー定義 | 等価結合条件が定義されていること |
| ソート済み入力 | 両入力が結合キーでソートされていること |

### 実行可否判定

結合条件が存在し、両入力がソート済みであること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| joinType | FlinkJoinType | Yes | - | 結合タイプ（INNER/LEFT/RIGHT/FULL） |
| leftKeys | int[] | Yes | - | 左側の結合キーインデックス |
| rightKeys | int[] | Yes | - | 右側の結合キーインデックス |
| filterNulls | boolean[] | Yes | - | 各キーのNULLフィルタ設定 |
| nonEquiCondition | RexNode | No | null | 非等価結合条件 |
| estimatedLeftAvgRowSize | int | Yes | - | 左入力の推定平均行サイズ |
| estimatedRightAvgRowSize | int | Yes | - | 右入力の推定平均行サイズ |
| estimatedLeftRowCount | long | Yes | - | 左入力の推定行数 |
| estimatedRightRowCount | long | Yes | - | 右入力の推定行数 |
| leftIsSmaller | boolean | Yes | - | 左側が小さいか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 左入力 | Transformation<RowData> | 結合の左側入力（ソート済み） |
| 右入力 | Transformation<RowData> | 結合の右側入力（ソート済み） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Transformation<RowData> | RowData | 結合結果を後続ノードへ出力 |

### 出力ファイル仕様

ファイル出力はなく、Flink内部のTransformationチェーンへ出力。

## 処理フロー

### 処理シーケンス

```
1. translateToPlanInternal呼び出し
   └─ PlannerBaseとExecNodeConfigを受け取る
2. 左右の入力Transformation取得
   └─ getInputEdges()から取得
3. 入力型取得
   └─ RowTypeを取得
4. メモリ計算
   └─ 外部バッファメモリ + ソートメモリ x 2
5. 結合条件生成
   └─ JoinUtil.generateConditionFunction
6. ソートマージ結合オペレータ生成
   └─ SorMergeJoinOperatorUtil.generateOperatorFactory
7. TwoInputTransformation生成
   └─ ExecNodeUtil.createTwoInputTransformation
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[左右入力取得]
    B --> C[入力型取得]
    C --> D[メモリ計算]
    D --> E[結合条件生成]
    E --> F[ソートマージオペレータ生成]
    F --> G[TwoInputTransformation生成]
    G --> H[Transformation返却]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。メモリ上での結合処理のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OutOfMemoryError | メモリ不足 | 外部バッファ/ソートメモリ不足 | メモリ設定増加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（Flinkリスタートに依存） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ジョブ失敗時はFlinkのリスタート機構に従い再実行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（中間処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力データ量依存 |
| 目標処理時間 | 並列度・データ量依存 |
| メモリ使用量上限 | table.exec.resource.sort.memory + external-buffer-memory |

## 排他制御

並列実行可能。各タスクは独立したパーティションを処理。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 結合開始時 | 結合タイプ |
| 終了ログ | 結合完了時 | 結合結果件数 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理レコード数/秒 | ジョブ定義依存 | Flink Metrics |
| スピル発生回数 | 0 | Flink Metrics |

## 備考

- ExecNodeMetadataは定義されていない（レガシー実装の可能性）
- AdaptiveJoinExecNodeインターフェースを実装し、適応型結合への変換をサポート
- FULL JOINでは外部バッファを2つ使用
- leftIsSmallerでどちらの入力が小さいかを考慮
- withJobStrategyHintが設定されている場合はAdaptive変換非対応
