# バッチ設計書 9-BatchExecNestedLoopJoin

## 概要

本ドキュメントは、Apache Flink Table APIにおけるBatchExecNestedLoopJoinバッチ実行ノードの設計仕様を記載する。このノードは、ネステッドループ結合を実装し、外側ループと内側ループで全組み合わせを比較して結合を実行する。

### 本バッチの処理概要

BatchExecNestedLoopJoinは、Flinkバッチ実行プランにおいて、2つの入力データセットをネステッドループ結合するための実行ノードである。最も単純な結合アルゴリズムで、任意の結合条件（非等価条件を含む）に対応可能。

**業務上の目的・背景**：等価結合条件がない場合や、CROSS JOINなどの全組み合わせが必要な場合に使用される。また、一方のテーブルが非常に小さい場合（1行など）にも効率的。

**バッチの実行タイミング**：Flinkジョブのバッチ実行時に、結合対象の両入力が準備できた時点で実行される。ビルドサイドのデータをバッファリングしてからプローブサイドを処理する。

**主要な処理内容**：
1. 左右の入力Transformationを取得
2. NestedLoopJoinCodeGeneratorでオペレータを生成
3. シングル行結合最適化（singleRowJoin）の適用
4. TwoInputTransformationを生成

**前後の処理との関連**：上流のスキャン、フィルタ、射影などのノードから入力を受け取る。後続には集約、ソート、別の結合などが接続可能。

**影響範囲**：計算量がO(n*m)のため、両入力が大きい場合はパフォーマンスに大きく影響。

## バッチ種別

結合処理（Nested Loop Join）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ジョブ実行時（随時） |
| 実行時刻 | ジョブスケジュールに依存 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Flinkジョブ実行時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 結合条件 | 任意の結合条件（等価/非等価どちらでも可） |
| 入力データ | 左右両方の入力Transformationが利用可能であること |

### 実行可否判定

両入力が準備完了であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| joinType | FlinkJoinType | Yes | - | 結合タイプ |
| condition | RexNode | Yes | - | 結合条件 |
| leftIsBuild | boolean | Yes | - | 左側がビルドサイドか |
| singleRowJoin | boolean | Yes | - | シングル行結合か |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 左入力 | Transformation<RowData> | 結合の左側入力 |
| 右入力 | Transformation<RowData> | 結合の右側入力 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Transformation<RowData> | RowData | 結合結果を後続ノードへ出力 |

### 出力ファイル仕様

ファイル出力はなく、Flink内部のTransformationチェーンへ出力。

## 処理フロー

### 処理シーケンス

```
1. translateToPlanInternal呼び出し
   └─ PlannerBaseとExecNodeConfigを受け取る
2. 左右の入力Transformation取得
   └─ getInputEdges()から取得
3. 入力型取得
   └─ RowTypeを取得
4. NestedLoopJoinCodeGenerator呼び出し
   └─ オペレータファクトリを生成
5. 並列度決定
   └─ leftIsBuildに基づいてプローブ側の並列度を使用
6. マネージドメモリ計算
   └─ singleRowJoinの場合は0、それ以外は外部バッファメモリ
7. TwoInputTransformation生成
   └─ ExecNodeUtil.createTwoInputTransformation
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[左右入力取得]
    B --> C[入力型取得]
    C --> D[NestedLoopJoinCodeGenerator]
    D --> E[オペレータファクトリ生成]
    E --> F{singleRowJoin?}
    F -->|Yes| G[managedMem=0]
    F -->|No| H[managedMem=外部バッファ]
    G --> I[TwoInputTransformation生成]
    H --> I
    I --> J[Transformation返却]
    J --> K[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。メモリ上での結合処理のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| OutOfMemoryError | メモリ不足 | バッファメモリ不足 | メモリ設定増加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（Flinkリスタートに依存） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ジョブ失敗時はFlinkのリスタート機構に従い再実行。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（中間処理） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 入力データ量依存（O(n*m)） |
| 目標処理時間 | 並列度・データ量依存 |
| メモリ使用量上限 | table.exec.resource.external-buffer-memory |

## 排他制御

並列実行可能。各タスクは独立したパーティションを処理。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 結合開始時 | 結合タイプ、ビルドサイド |
| 終了ログ | 結合完了時 | 結合結果件数 |
| エラーログ | エラー発生時 | 例外情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理レコード数/秒 | ジョブ定義依存 | Flink Metrics |

## 備考

- FlinkVersion v2.0以降で使用可能
- ExecNodeMetadataのname: "batch-exec-nested-loop-join"
- 消費オプション: table.exec.resource.external-buffer-memory
- singleRowJoin=trueの場合はメモリを使用しない（1行のみバッファ）
- 非等価結合条件に対応可能（他の結合アルゴリズムでは不可能な条件）
- JOIN_TRANSFORMATION定数: "nested-loop-join"
