---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-BatchExecTableSourceScan

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **監視・アラート閾値**：具体的な閾値設定の根拠不足
  2. **リトライ仕様詳細**：コネクタ実装依存のため詳細確認要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `BatchExecTableSourceScan.java` (L52-57: ExecNodeMetadata)
- E-02: `BatchExecTableSourceScan.java` (L49-51: クラスJavadoc)
- E-03: `BatchExecTableSourceScan.java` (L124-131: translateToPlanInternal)
- E-04: `BatchExecTableSourceScan.java` (L119-121: getDynamicFilteringDataListenerID)
- E-05: `BatchExecTableSourceScan.java` (L134-150: getDynamicFilteringDataCollector)
- E-06: `BatchExecTableSourceScan.java` (L153-165: createInputFormatTransformation)
- E-07: `BatchExecTableSourceScan.java` (L167-170: legacyUidsEnabled)
- E-08: `CommonExecTableSourceScan.java` (L116-236: translateToPlanInternal)
- E-09: `CommonExecTableSourceScan.java` (L87: SOURCE_TRANSFORMATION)
- E-10: `CommonExecTableSourceScan.java` (L132-164: SourceFunctionProvider処理)
- E-11: `CommonExecTableSourceScan.java` (L165-171: InputFormatProvider処理)
- E-12: `CommonExecTableSourceScan.java` (L173-184: SourceProvider処理)
- E-13: `CommonExecTableSourceScan.java` (L185-201: DataStreamScanProvider処理)
- E-14: `バッチ一覧.csv` (L2: BatchExecTableSourceScanの説明)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExecNodeで外部ソースからデータ読み取り | E-02, E-14 | ○ |
| C-02 | ScanTableSourceで定義された有界データソース対応 | E-02 | ○ |
| C-03 | バッチモード実行ノード | E-01 | ○ |
| C-04 | FlinkVersion v2.0以降で使用可能 | E-01 (minPlanVersion) | ○ |
| C-05 | DynamicTableSourceSpec経由のテーブルソース取得 | E-08 | ○ |
| C-06 | SOURCE_TRANSFORMATION定数使用 | E-09 | ○ |
| C-07 | SourceFunctionProvider対応 | E-10 | ○ |
| C-08 | InputFormatProvider対応 | E-11 | ○ |
| C-09 | SourceProvider対応 | E-12 | ○ |
| C-10 | DataStreamScanProvider対応 | E-13 | ○ |
| C-11 | 動的フィルタリング対応（dynamicFilteringDataListenerID） | E-04 | ○ |
| C-12 | BatchExecDynamicFilteringDataCollectorとの連携 | E-05 | ○ |
| C-13 | レガシー変換の有界化（makeLegacySourceTransformationsBounded） | E-03 | ○ |
| C-14 | legacyUidsEnabled=false | E-07 | ○ |
| C-15 | createInputFormatTransformationでInputFormatSourceFunction使用 | E-06 | ○ |
| C-16 | リネージ情報の設定 | E-08 (L207-221) | ○ |
| C-17 | 並列度設定の検証 | E-08 (L243-257) | ○ |
| C-18 | copyAndRemoveInputsメソッドの存在 | E-03 (L172-181) | ○ |
| C-19 | RowData形式での出力 | E-02 | ○ |
| C-20 | 入力プロパティは空リストまたは単一要素 | E-03 (L67-82, L84-98) | ○ |
| C-21 | TransformationScanProvider対応 | E-08 (L194-201) | ○ |
| C-22 | UnsupportedOperationExceptionの発生条件 | E-08 (L202-205) | ○ |
| C-23 | TableExceptionの並列度検証 | E-08 (L246-255) | ○ |
| C-24 | 監視項目の具体的閾値 | **根拠なし** | △ |
| C-25 | リトライ仕様の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 監視・アラートの具体的な閾値設定
  - 候補：Flink設定ドキュメント / 運用マニュアル / メトリクス仕様書
- リトライ仕様の詳細
  - 候補：各コネクタ実装 / コネクタドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード直接参照による主張は信頼性高い
- 1: 中リスク - 運用関連情報（監視閾値・リトライ）は実装依存
- 0: 低リスク - API仕様はExecNodeMetadataから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] 動的フィルタリング連携の説明が実装と一致しているか確認
- [ ] 各プロバイダタイプの処理フローが正確か確認
- [ ] 監視・アラート項目を運用要件に合わせて具体化
