---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：10-BatchExecLookupJoin

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **非同期ルックアップの詳細動作**：AsyncOptions関連の詳細確認要

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecLookupJoin.java` (L53: クラスJavadoc)
- E-02: `BatchExecLookupJoin.java` (L54-64: ExecNodeMetadata)
- E-03: `BatchExecLookupJoin.java` (L65-66: クラス宣言)
- E-04: `BatchExecLookupJoin.java` (L68-101: コンストラクタ)
- E-05: `BatchExecLookupJoin.java` (L103-145: JSONコンストラクタ)
- E-06: `BatchExecLookupJoin.java` (L147-154: translateToPlanInternal)
- E-07: `BatchExecLookupJoin.java` (L156-172: createSyncLookupJoinWithState)
- E-08: `BatchExecLookupJoin.java` (L174-190: createKeyOrderedAsyncLookupJoin)
- E-09: `CommonExecLookupJoin.java` (L114-148: クラスJavadoc)
- E-10: `CommonExecLookupJoin.java` (L254-376: createJoinTransformation)
- E-11: `CommonExecLookupJoin.java` (L677-698: validate)
- E-12: `バッチ一覧.csv` (L11: BatchExecLookupJoinの説明)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テンポラルテーブルとのルックアップ結合 | E-01, E-12 | ○ |
| C-02 | リアルタイムルックアップを実行 | E-12 | ○ |
| C-03 | ExecNodeMetadataのname="batch-exec-lookup-join" | E-02 | ○ |
| C-04 | version=1 | E-02 | ○ |
| C-05 | FlinkVersion v2.0以降で使用可能 | E-02 (minPlanVersion) | ○ |
| C-06 | 消費オプション（async-lookup系） | E-02 (consumedOptions) | ○ |
| C-07 | CommonExecLookupJoinを継承 | E-03 | ○ |
| C-08 | BatchExecNodeインターフェース実装 | E-03 | ○ |
| C-09 | SingleTransformationTranslator実装 | E-03 | ○ |
| C-10 | リトライヒント非対応（retryOptions=null） | E-04 (L95) | ○ |
| C-11 | ChangelogMode.insertOnly() | E-04 (L96) | ○ |
| C-12 | translateToPlanInternalでcreateJoinTransformation呼び出し | E-06 | ○ |
| C-13 | lookupKeyContainsPrimaryKey=false | E-06 (L153) | ○ |
| C-14 | createSyncLookupJoinWithStateは入力をそのまま返す | E-07 (L171) | ○ |
| C-15 | createKeyOrderedAsyncLookupJoinはIllegalStateException | E-08 | ○ |
| C-16 | バッチモードでキー順序付き非同期は非対応 | E-08 (L188-189) | ○ |
| C-17 | ルックアップキー不足時はTableException | E-11 (L683-688) | ○ |
| C-18 | INNER/LEFT以外はTableException | E-11 (L691-696) | ○ |
| C-19 | LookupTableSource実装が必要 | E-11 (L719-726) | ○ |
| C-20 | 入力プロパティは単一要素 | E-09 (L236) | ○ |
| C-21 | lookupKeysパラメータ | E-09, E-04 | ○ |
| C-22 | temporalTableSourceSpecパラメータ | E-04 | ○ |
| C-23 | asyncLookupOptionsパラメータ | E-04 | ○ |
| C-24 | projectionOnTemporalTableパラメータ | E-04 | ○ |
| C-25 | filterOnTemporalTableパラメータ | E-04 | ○ |
| C-26 | 非同期ルックアップの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 非同期ルックアップの詳細動作
  - 候補：AsyncLookupJoinRunner実装 / AsyncTableFunction仕様

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接抽出した情報が多い
- 1: 中リスク - 外部システム連携のため実行時エラー注意

## 6) レビュアーチェックリスト（最小）
- [ ] ルックアップキーの定義方法が明確か確認
- [ ] バッチモードでの制約（リトライ非対応等）が明確か確認
- [ ] INNER/LEFT JOIN限定の説明が十分か確認
- [ ] 非同期オプション（timeout, buffer-capacity）の説明が十分か確認
