---
generated_at: 2026-02-02 17:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：11-BatchExecAdaptiveJoin

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **実行タイミングの詳細**：Plannerの判断ロジックは外部依存
  2. **パフォーマンス要件の具体値**：実行環境依存のため根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `BatchExecAdaptiveJoin.java` L49-166
- E-02: `JoinSpec` クラス（結合仕様定義）
- E-03: `AdaptiveJoinOperatorGenerator` クラス（L116-132）
- E-04: `JoinUtil.getManagedMemory()` メソッド（L107）
- E-05: `ExecNodeUtil.createTwoInputTransformation()` メソッド（L134-145）
- E-06: `バッチ一覧.csv` No.11行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 適応型結合は実行時にデータサイズに応じて最適な戦略を選択する | E-01, E-03 | ○ |
| C-02 | 左右2つの入力ストリームを受け取る | E-01 (L97-103) | ○ |
| C-03 | JoinSpecにより結合条件が定義される | E-01 (L52), E-02 | ○ |
| C-04 | leftIsBuildでビルドサイドを決定 | E-01 (L53, L131) | ○ |
| C-05 | 見積もり行サイズと行数のパラメータを持つ | E-01 (L54-57) | ○ |
| C-06 | tryDistinctBuildRowで重複除去を制御 | E-01 (L58, L129) | ○ |
| C-07 | originalJoinで元の結合タイプを保持 | E-01 (L60, L132) | ○ |
| C-08 | GeneratedJoinConditionで結合条件関数を生成 | E-01 (L108-114) | ○ |
| C-09 | JoinUtil.getManagedMemoryでメモリサイズを計算 | E-04 | ○ |
| C-10 | AdaptiveJoinOperatorFactoryを使用 | E-01 (L152) | ○ |
| C-11 | シリアライズ失敗時にTableExceptionをスロー | E-01 (L154) | ○ |
| C-12 | 並列度は左右入力の大きい方を採用 | E-01 (L143) | ○ |
| C-13 | getDescriptionでAdaptiveJoin情報を出力 | E-01 (L159-165) | ○ |
| C-14 | Plannerが適応型結合の使用を判断 | **根拠なし** | △ |
| C-15 | パフォーマンス要件の具体的数値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Plannerが適応型結合を選択するロジックは、BatchExecAdaptiveJoin.java外のPlannerルールに依存
  - 候補：`FlinkBatchRuleSets.java` / `FlinkStreamRuleSets.java` / Planner関連ルール
- パフォーマンス要件の具体値は実行環境・データサイズに依存するため、ソースコードからは特定不可
  - 候補：ベンチマーク結果 / 運用ドキュメント / 設定ガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア処理ロジックはソースコードから十分に読み取れる
- 1: 中リスク - Planner選択ロジックの詳細は外部ファイル参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] JoinSpecの各フィールド（leftKeys, rightKeys, joinType, filterNulls）が正しく説明されているか
- [ ] AdaptiveJoinOperatorGeneratorの動作原理が実装と一致するか
- [ ] シリアライズ処理のエラーハンドリングが網羅されているか
- [ ] 並列度決定ロジックが実際の動作と一致するか
