---
generated_at: 2026-02-02 17:32:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-BatchExecHashAggregate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Plannerの選択ロジック詳細**：外部Plannerルールに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `BatchExecHashAggregate.java` L61-287
- E-02: `@ExecNodeMetadata` アノテーション（L61-72）
- E-03: `AggregateInfoList` / `AggregateUtil.transformToBatchAggregateInfoList()` (L175-181)
- E-04: `AggWithoutKeysCodeGenerator.genWithoutKeys()` (L188-196)
- E-05: `HashAggCodeGenerator.genWithKeys()` (L202-219)
- E-06: `ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY` (L199)
- E-07: `HashAggFusionCodegenSpec` (L261)
- E-08: `バッチ一覧.csv` No.12行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ハッシュテーブルを使用してグループ化と集約を実行 | E-01, E-05 | ○ |
| C-02 | groupingパラメータでグルーピングキーを指定 | E-01 (L86-87) | ○ |
| C-03 | auxGroupingパラメータで補助グルーピングを指定 | E-01 (L89-90) | ○ |
| C-04 | aggCallsで集約関数を定義 | E-01 (L92-93) | ○ |
| C-05 | isMerge/isFinalで2段階集約を制御 | E-01 (L98-102) | ○ |
| C-06 | supportAdaptiveLocalHashAggで適応型集約をサポート | E-01 (L104-105) | ○ |
| C-07 | グルーピングキーがない場合、AggWithoutKeysCodeGeneratorを使用 | E-04 | ○ |
| C-08 | グルーピングキーがある場合、HashAggCodeGeneratorを使用 | E-05 | ○ |
| C-09 | グルーピングキーなしの場合、管理メモリは0L | E-01 (L186) | ○ |
| C-10 | TABLE_EXEC_RESOURCE_HASH_AGG_MEMORYで管理メモリを設定 | E-06 | ○ |
| C-11 | スピル圧縮設定を使用 | E-02 (L68-69) | ○ |
| C-12 | batch-exec-hash-aggregate version 1として登録 | E-02 (L62-63) | ○ |
| C-13 | Flink v2_0以降で使用可能 | E-02 (L71-72) | ○ |
| C-14 | supportFusionCodegen()がtrueを返す | E-01 (L233-234) | ○ |
| C-15 | HashAggFusionCodegenSpecを使用してFusion対応 | E-07 | ○ |
| C-16 | AggregateUtil.transformToBatchAggregateInfoListで集約情報変換 | E-03 | ○ |
| C-17 | CodeGenOperatorFactoryで生成オペレーターをラップ | E-01 (L225) | ○ |
| C-18 | Plannerがハッシュ集約を選択するロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Plannerがハッシュ集約とソート集約を選択するロジックはBatchExecHashAggregate.java外に存在
  - 候補：`FlinkBatchRuleSets.java` / `AggregateRule.java` / コストモデル関連

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード生成ロジックとパラメータはソースコードから十分に読み取れる

## 6) レビュアーチェックリスト（最小）
- [ ] grouping/auxGroupingの使い分けが正しく説明されているか
- [ ] isMerge/isFinalの組み合わせパターンが網羅されているか
- [ ] スピル設定（max-num-file-handles、compression）の動作が実装と一致するか
- [ ] Fusion Codegen対応の範囲が正確か
