---
generated_at: 2026-02-02 17:36:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：14-BatchExecOverAggregate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Plannerの選択ロジック詳細**：Java/Python UDF選択ロジックは外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `BatchExecOverAggregate.java` L84-487
- E-02: `@ExecNodeMetadata` アノテーション（L84-90）
- E-03: `BatchExecOverAggregateBase` 基底クラス
- E-04: `NonBufferOverWindowOperator` (L189-190)
- E-05: `BufferDataOverWindowOperator` (L202-207)
- E-06: `OverWindowFrame` 各種実装クラス（L58-67）
- E-07: `OffsetOverFrame` (L301)
- E-08: `needBufferData()` メソッド（L465-486）
- E-09: `TABLE_EXEC_RESOURCE_EXTERNAL_BUFFER_MEMORY` (L209)
- E-10: `バッチ一覧.csv` No.14行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OVER句によるウィンドウ集約を実行 | E-01, E-03 | ○ |
| C-02 | ROW型およびRANGE型ウィンドウをサポート | E-01 (L332-421) | ○ |
| C-03 | LEAD/LAG関数をOffsetOverFrameで処理 | E-07 | ○ |
| C-04 | パーティションコンパレータを生成 | E-01 (L134-140) | ○ |
| C-05 | needBufferData()でバッファリング要否を判定 | E-08 | ○ |
| C-06 | バッファリング不要時はNonBufferOverWindowOperatorを使用 | E-04 | ○ |
| C-07 | バッファリング要時はBufferDataOverWindowOperatorを使用 | E-05 | ○ |
| C-08 | 複数のOverWindowFrame実装をサポート | E-06 | ○ |
| C-09 | OverSpecでウィンドウ定義を受け取る | E-01 (L93) | ○ |
| C-10 | batch-exec-over-aggregate version 1として登録 | E-02 (L85-86) | ○ |
| C-11 | external-buffer-memory設定を使用 | E-02 (L88), E-09 | ○ |
| C-12 | INSENSITIVE/ROW/RANGE/OFFSETモードをサポート | E-01 (L232-233, L392-427) | ○ |
| C-13 | AggsHandlerCodeGeneratorで集約ハンドラを生成 | E-01 (L169-181) | ○ |
| C-14 | LEAD/LAGのオフセットはLONG/INT/SHORTをサポート | E-01 (L277-289) | ○ |
| C-15 | RangeBoundComparatorCodeGeneratorで境界比較器を生成 | E-01 (L446-456) | ○ |
| C-16 | SizeBasedWindowFunctionをサポート | E-01 (L319-321) | ○ |
| C-17 | createBoundComparator()で境界比較器を生成 | E-01 (L434-463) | ○ |
| C-18 | ソート順（ASC/DESC）を考慮 | E-01 (L454) | ○ |
| C-19 | BatchExecOverAggregateBaseを継承 | E-01 (L91), E-03 | ○ |
| C-20 | Plannerの選択ロジック（Java vs Python） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PlannerがBatchExecOverAggregateとBatchExecPythonOverAggregateを選択するロジックは外部に存在
  - 候補：`FlinkBatchRuleSets.java` / Planner関連ルール

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 各ウィンドウフレーム実装の動作はソースコードから十分に読み取れる

## 6) レビュアーチェックリスト（最小）
- [ ] 各OverWindowFrameタイプの使い分け条件が正確か
- [ ] needBufferData()の判定ロジックが網羅されているか
- [ ] LEAD/LAGのオフセット処理（定数/変数）が正しく説明されているか
- [ ] 境界比較器（RangeBound/MultiFieldRangeBound）の使い分けが明確か
