---
generated_at: 2026-02-02 17:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-BatchExecHashWindowAggregate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Plannerのハッシュ/ソートウィンドウ集約選択ロジック**：外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `BatchExecHashWindowAggregate.java` L55-162
- E-02: `HashWindowCodeGenerator` (L122-137)
- E-03: `WindowCodeGenerator.getWindowDef()` (L140)
- E-04: `AggregateUtil.transformToBatchAggregateInfoList()` (L114-120)
- E-05: `ExecutionConfigOptions.TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMIT` (L138-139)
- E-06: `ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY` (L150-151)
- E-07: `NamedWindowProperty` (L64)
- E-08: `バッチ一覧.csv` No.15行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ハッシュテーブルを使用してウィンドウ集約を実行 | E-01, E-02 | ○ |
| C-02 | groupingパラメータでグルーピングキーを指定 | E-01 (L58) | ○ |
| C-03 | window(LogicalWindow)でウィンドウを定義 | E-01 (L61) | ○ |
| C-04 | inputTimeFieldIndexで時間フィールドを指定 | E-01 (L62) | ○ |
| C-05 | inputTimeIsDateでDATE型かどうかを指定 | E-01 (L63) | ○ |
| C-06 | namedWindowPropertiesでウィンドウプロパティを出力 | E-01 (L64), E-07 | ○ |
| C-07 | enableAssignPaneでペイン割り当てを制御 | E-01 (L66) | ○ |
| C-08 | isMerge/isFinalで2段階集約を制御 | E-01 (L67-68) | ○ |
| C-09 | HashWindowCodeGeneratorでオペレーターコードを生成 | E-02 | ○ |
| C-10 | WindowCodeGenerator.getWindowDef()でウィンドウサイズを取得 | E-03 | ○ |
| C-11 | TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMITでバッファサイズを制御 | E-05 | ○ |
| C-12 | TABLE_EXEC_RESOURCE_HASH_AGG_MEMORYで管理メモリを設定 | E-06 | ○ |
| C-13 | AggregateUtil.transformToBatchAggregateInfoListで集約情報変換 | E-04 | ○ |
| C-14 | CodeGenOperatorFactoryで生成オペレーターをラップ | E-01 (L156) | ○ |
| C-15 | 入力の並列度を維持 | E-01 (L158) | ○ |
| C-16 | Plannerのハッシュ/ソートウィンドウ集約選択ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Plannerがハッシュウィンドウとソートウィンドウのどちらを選択するかのロジックは外部に存在
  - 候補：`FlinkBatchRuleSets.java` / `WindowAggregateRule.java` / コストモデル関連

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード生成ロジックとパラメータはソースコードから十分に読み取れる

## 6) レビュアーチェックリスト（最小）
- [ ] LogicalWindowの各タイプ（Tumbling、Hopping、Session）が正しくサポートされているか
- [ ] NamedWindowPropertyの各プロパティ（WindowStart、WindowEnd、RowtimeAttribute）が正確か
- [ ] enableAssignPaneの動作が2段階集約と正しく連携しているか
- [ ] 管理メモリとバッファサイズの関係が明確か
