---
generated_at: 2026-02-02 17:44:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：18-BatchExecPythonGroupWindowAggregate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **Python UDAF + ウィンドウ集約のパフォーマンス特性**：外部測定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `BatchExecPythonGroupWindowAggregate.java` L64-275
- E-02: `ARROW_PYTHON_GROUP_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME` (L67-69)
- E-03: `WindowCodeGenerator.getWindowDef()` (L115)
- E-04: `CommonPythonUtil.extractPythonConfiguration()` (L116-118)
- E-05: `WindowStart/WindowEnd/RowtimeAttribute` (L155-165)
- E-06: `CommonPythonUtil.extractPythonAggregateFunctionInfosFromAggregateCall()` (L167-168)
- E-07: `ExecutionConfigOptions.TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMIT` (L119-120)
- E-08: `ManagedMemoryUseCase.PYTHON` (L135)
- E-09: `ProjectionCodeGenerator.generateProjection()` (L248-265)
- E-10: `バッチ一覧.csv` No.18行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Python UDAFを使用してウィンドウ集約を実行 | E-01, E-02 | ○ |
| C-02 | groupingパラメータでグルーピングキーを指定 | E-01 (L71) | ○ |
| C-03 | window(LogicalWindow)でウィンドウを定義 | E-01 (L74) | ○ |
| C-04 | inputTimeFieldIndexで時間フィールドを指定 | E-01 (L75) | ○ |
| C-05 | namedWindowPropertiesでウィンドウプロパティを出力 | E-01 (L76) | ○ |
| C-06 | WindowCodeGenerator.getWindowDef()でウィンドウサイズを取得 | E-03 | ○ |
| C-07 | CommonPythonUtil.extractPythonConfiguration()でPython設定を抽出 | E-04 | ○ |
| C-08 | ウィンドウプロパティタイプを数値に変換（0,1,2） | E-05 | ○ |
| C-09 | extractPythonAggregateFunctionInfosFromAggregateCall()で関数情報を抽出 | E-06 | ○ |
| C-10 | TABLE_EXEC_WINDOW_AGG_BUFFER_SIZE_LIMITでバッファサイズを制御 | E-07 | ○ |
| C-11 | isPythonWorkerUsingManagedMemory()で管理メモリ使用を判定 | E-01 (L133-134) | ○ |
| C-12 | ManagedMemoryUseCase.PYTHONを宣言 | E-08 | ○ |
| C-13 | BatchArrowPythonGroupWindowAggregateFunctionOperatorをリフレクションでロード | E-02, E-01 (L207-209) | ○ |
| C-14 | 3種類の投影を生成（UdafInput, GroupKey, GroupSet） | E-09 | ○ |
| C-15 | TableExceptionで未サポートウィンドウプロパティエラーを出力 | E-01 (L164) | ○ |
| C-16 | TableExceptionでオペレーター構築失敗をラップ | E-01 (L270-273) | ○ |
| C-17 | 入力の並列度を維持 | E-01 (L190) | ○ |
| C-18 | Python UDAF + ウィンドウ集約のパフォーマンス特性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Python UDAF + ウィンドウ集約のパフォーマンス特性（Java UDFとの比較等）は外部測定が必要
  - 候補：ベンチマーク結果 / PyFlink公式ドキュメント / チューニングガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア処理ロジックはソースコードから十分に読み取れる
- 1: 中リスク - Python環境依存のためデバッグが複雑になる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ウィンドウプロパティタイプの数値変換（0,1,2）が正確か
- [ ] リフレクションによるオペレーターロードが正しく説明されているか
- [ ] 3種類の投影（UdafInput, GroupKey, GroupSet）の用途が明確か
- [ ] 管理メモリ使用の判定条件が正確か
