---
generated_at: 2026-02-02 17:46:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：19-BatchExecPythonOverAggregate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Python UDAF + OVER集約のパフォーマンス特性**：外部測定が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `BatchExecPythonOverAggregate.java` L61-293
- E-02: `BatchExecOverAggregateBase` 基底クラス
- E-03: `ARROW_PYTHON_OVER_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME` (L63-65)
- E-04: `lowerBoundary/upperBoundary` リスト（L67-68）
- E-05: `aggWindowIndex` リスト（L70）
- E-06: `inferGroupMode()` メソッド（E-02より継承）
- E-07: `isUnboundedWindow/isUnboundedPrecedingWindow/etc.` メソッド（E-02より継承）
- E-08: `OverAggregateUtil.getLongBoundary()` (L118-128)
- E-09: `CommonPythonUtil.extractPythonConfiguration()` (L155-157)
- E-10: `ManagedMemoryUseCase.PYTHON` (L169)
- E-11: `ProjectionCodeGenerator.generateProjection()` (L262-283)
- E-12: `バッチ一覧.csv` No.19行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Python UDAFを使用してOVER集約を実行 | E-01, E-03 | ○ |
| C-02 | ROW型およびRANGE型ウィンドウをサポート | E-01 (L111-153) | ○ |
| C-03 | BatchExecOverAggregateBaseを継承 | E-01 (L61), E-02 | ○ |
| C-04 | OverSpecでウィンドウ定義を受け取る | E-01 (L74) | ○ |
| C-05 | lowerBoundary/upperBoundaryリストで境界値を管理 | E-04 | ○ |
| C-06 | aggWindowIndexで集約関数とウィンドウグループの対応を管理 | E-05 | ○ |
| C-07 | inferGroupMode()でウィンドウモードを判定 | E-06 | ○ |
| C-08 | isUnboundedWindow等でウィンドウタイプを判定 | E-07 | ○ |
| C-09 | OverAggregateUtil.getLongBoundary()で境界値を取得 | E-08 | ○ |
| C-10 | Long.MIN_VALUEでUNBOUNDED PRECEDING、Long.MAX_VALUEでUNBOUNDED FOLLOWINGを表現 | E-01 (L114-115, L134-135) | ○ |
| C-11 | CommonPythonUtil.extractPythonConfiguration()でPython設定を抽出 | E-09 | ○ |
| C-12 | isPythonWorkerUsingManagedMemory()で管理メモリ使用を判定 | E-01 (L167-168) | ○ |
| C-13 | ManagedMemoryUseCase.PYTHONを宣言 | E-10 | ○ |
| C-14 | BatchArrowPythonOverWindowAggregateFunctionOperatorをリフレクションでロード | E-03, E-01 (L217-219) | ○ |
| C-15 | 3種類の投影を生成（UdafInput, GroupKey, GroupSet） | E-11 | ○ |
| C-16 | isRangeWindows配列でウィンドウモードを管理 | E-01 (L102) | ○ |
| C-17 | sortSpec.getAscendingOrders()[0]でソート順を取得 | E-01 (L261) | ○ |
| C-18 | TableExceptionで未サポートウィンドウエラーを出力 | E-01 (L130, L152) | ○ |
| C-19 | 入力の並列度を維持 | E-01 (L203) | ○ |
| C-20 | Python UDAF + OVER集約のパフォーマンス特性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Python UDAF + OVER集約のパフォーマンス特性（Java UDFとの比較、バッファサイズの影響等）は外部測定が必要
  - 候補：ベンチマーク結果 / PyFlink公式ドキュメント / チューニングガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア処理ロジックはソースコードから十分に読み取れる
- 1: 中リスク - Python環境依存のためデバッグが複雑になる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ROW/RANGEウィンドウモードの判定ロジックが正確か
- [ ] 境界値（UNBOUNDED PRECEDING/FOLLOWING、CURRENT ROW）の処理が網羅されているか
- [ ] aggWindowIndexの用途が明確に説明されているか
- [ ] BatchExecOverAggregateBaseとの継承関係が正しく説明されているか
