---
generated_at: 2026-02-02 17:40:00
metrics:
  claims_total: 10
  claims_with_evidence: 8
  claims_without_evidence: 2
confidence_derived: 0.80
---

# 根拠レポート：26-BatchExecPythonAsyncCalc

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：8 / 10、根拠なし：2
- 優先レビュー（高）
  1. **非同期処理の詳細動作**：CommonExecPythonAsyncCalcの実装詳細を確認必要
  2. **順序保証の設定方法**：Async I/O設定の詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/nodes/exec/batch/BatchExecPythonAsyncCalc.java`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Python Async ScalarFunctionsのバッチ実行ノード | E-01 L37, E-02 | ○ |
| C-02 | CommonExecPythonAsyncCalcを継承 | E-01 L38-39 | ○ |
| C-03 | projectionの入力パラメータ | E-01 L57-62 | ○ |
| C-04 | JSON直列化サポート（@JsonCreator, @JsonProperty） | E-01 L57-66 | ○ |
| C-05 | RowType形式の入出力型 | E-01 L64 | ○ |
| C-06 | 単一の入力プロパティ | E-01 L52 | ○ |
| C-07 | ExecNodeContextの使用 | E-01 L48-50 | ○ |
| C-08 | 非同期I/Oによる高スループット | **根拠なし** | △ |
| C-09 | 入力順序と出力順序の違い | **根拠なし** | △ |
| C-10 | BatchExecNodeインターフェース実装 | E-01 L39 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-08, C-09: 非同期処理の詳細はCommonExecPythonAsyncCalcに実装されているが、そのソースが未確認
  - 候補：CommonExecPythonAsyncCalc.javaの確認 / Flink Async I/Oドキュメント

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 非同期処理の詳細動作が一部推測に基づく
- 1: 中リスク - Python環境依存のため実行環境の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CommonExecPythonAsyncCalcの実装を確認
- [ ] 非同期処理の順序保証設定を確認
- [ ] Python環境が正しく構成されているか確認
- [ ] Async I/Oの設定（キャパシティ、タイムアウト）を確認
