---
generated_at: 2026-02-02 17:44:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-BatchExecUnion

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/nodes/exec/batch/BatchExecUnion.java`
- E-02: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/nodes/exec/common/CommonExecUnion.java`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複数の入力レコードを1つのノードに統合 | E-01 L36-39, E-03 | ○ |
| C-02 | 物理的な処理ではなく論理的な統合 | E-01 L37-38, E-02 L39-41 | ○ |
| C-03 | CommonExecUnionを継承 | E-01 L45 | ○ |
| C-04 | UnionTransformationを使用 | E-02 L63 | ○ |
| C-05 | 複数の入力プロパティ（inputProperties） | E-01 L47-49 | ○ |
| C-06 | 各入力エッジのTransformationを取得 | E-02 L59-62 | ○ |
| C-07 | ExecNodeMetadataでproducedTransformations未指定 | E-01 L40-44 | ○ |
| C-08 | SingleTransformationTranslatorの実装 | E-02 L43 | ○ |
| C-09 | JSON直列化サポート | E-01 L62-69 | ○ |
| C-10 | RowType形式の出力型 | E-01 L66 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな論理統合処理で全てソースコードで確認済み
- 0: 低リスク - 物理的なオペレータを生成しないため低複雑度

## 6) レビュアーチェックリスト（最小）
- [ ] 全入力ストリームのスキーマが互換性を持つか確認
- [ ] UNION ALLの動作（重複除外なし）が期待と一致するか確認
- [ ] 出力レコード数が全入力の合計であることを理解しているか確認
