---
generated_at: 2026-02-02 17:46:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-BatchExecCorrelate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/nodes/exec/batch/BatchExecCorrelate.java`
- E-02: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/nodes/exec/common/CommonExecCorrelate.java`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Java/Scalaユーザー定義テーブル関数との結合実行 | E-01 L43, E-03 | ○ |
| C-02 | CommonExecCorrelateを継承 | E-01 L50 | ○ |
| C-03 | joinType、invocation、conditionパラメータ | E-02 L61-68 | ○ |
| C-04 | FlinkJoinTypeでINNER/LEFT指定 | E-01 L54, E-02 L61-62 | ○ |
| C-05 | conditionはNullable（オプション） | E-01 L56, E-02 L67-68 | ○ |
| C-06 | retainHeader=false | E-01 L68 | ○ |
| C-07 | TableStreamOperatorを基底クラス | E-01 L67 | ○ |
| C-08 | CorrelateCodeGeneratorの使用 | E-02 L104 | ○ |
| C-09 | CORRELATE_TRANSFORMATIONの使用 | E-02 L55, L116 | ○ |
| C-10 | 単一の入力プロパティ | E-02 L86 | ○ |
| C-11 | RexCall形式のinvocation | E-01 L90-91, E-02 L65 | ○ |
| C-12 | ExecNodeMetadataアノテーション | E-01 L44-49 | ○ |
| C-13 | JSON直列化サポート | E-01 L74-97 | ○ |
| C-14 | 入力の並列度を維持 | E-02 L113 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはソースコードで確認済み
- 0: 低リスク - コード生成メカニズムは共通基盤で確立済み

## 6) レビュアーチェックリスト（最小）
- [ ] UDTFが正しく登録されているか確認
- [ ] joinTypeの設定が期待する結合セマンティクスと一致するか確認
- [ ] conditionの設定が適切か確認
- [ ] 出力スキーマが後続処理の期待と一致するか確認
