---
generated_at: 2026-02-02 17:48:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-BatchExecPythonCorrelate

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/nodes/exec/batch/BatchExecPythonCorrelate.java`
- E-02: `flink-table/flink-table-planner/src/main/java/org/apache/flink/table/planner/plan/nodes/exec/common/CommonExecPythonCorrelate.java`
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pythonユーザー定義テーブル関数との結合実行 | E-01 L33, E-03 | ○ |
| C-02 | CommonExecPythonCorrelateを継承 | E-01 L34-35 | ○ |
| C-03 | joinTypeとinvocationパラメータ | E-02 L76-80 | ○ |
| C-04 | FlinkJoinTypeでINNER/LEFT指定 | E-01 L39, E-02 L76-77 | ○ |
| C-05 | RexCall形式のinvocation | E-01 L40, E-02 L79-80 | ○ |
| C-06 | 2種類のPython Operator（InProcess/Embedded） | E-02 L70-74, L188-237 | ○ |
| C-07 | ManagedMemoryUseCase.PYTHONの宣言 | E-02 L115-118 | ○ |
| C-08 | ProjectionCodeGeneratorの使用 | E-02 L209-214 | ○ |
| C-09 | PYTHON_CORRELATE_TRANSFORMATIONの使用 | E-02 L65, L146 | ○ |
| C-10 | 単一の入力プロパティ | E-02 L92 | ○ |
| C-11 | PythonFunctionInfoの抽出 | E-02 L153-164 | ○ |
| C-12 | conditionパラメータなし（BatchExecCorrelateとの差異） | E-01, E-02（conditionフィールドなし） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはソースコードで確認済み
- 1: 中リスク - Python環境依存のため実行環境の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Python環境が正しく構成されているか確認
- [ ] Python UDTFが正しく登録されているか確認
- [ ] joinTypeの設定が期待する結合セマンティクスと一致するか確認
- [ ] Managed Memoryの設定が適切か確認
- [ ] conditionが不要であることを確認（必要な場合はJava/Scala UDTFの使用を検討）
