---
generated_at: 2026-02-02 17:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：31-BatchExecWindowTableFunction

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **処理時間ウィンドウの将来サポート**：公式ロードマップ未確認
  2. **セッションウィンドウの将来サポート計画**：公式ロードマップ未確認
  3. **パフォーマンス要件の具体値**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `BatchExecWindowTableFunction.java` (lines 42-105)
- E-02: `CommonExecWindowTableFunction.java` (lines 53-122)
- E-03: `@ExecNodeMetadata` アノテーション (lines 43-48)
- E-04: `translateToPlanInternal` メソッド (lines 88-94)
- E-05: `translateWithUnalignedWindow` メソッド (lines 97-104)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ウィンドウテーブル値関数のバッチ実行ノードである | E-01, E-03 | ○ |
| C-02 | TUMBLE、HOP、CUMULATEウィンドウをサポート | E-02 | ○ |
| C-03 | 処理時間ウィンドウは未サポート | E-04 (line 90-92) | ○ |
| C-04 | セッションウィンドウ（非整列）は未サポート | E-05 (line 102-103) | ○ |
| C-05 | イベント時間ベースのウィンドウ処理を実行 | E-04 | ○ |
| C-06 | AlignedWindowTableFunctionOperatorを使用 | E-02 (line 113) | ○ |
| C-07 | TimeAttributeWindowingStrategyを入力として受け取る | E-01 (lines 52-66), E-02 (line 62) | ○ |
| C-08 | Flink 2.0以降で利用可能 | E-03 (minPlanVersion = FlinkVersion.v2_0) | ○ |
| C-09 | タイムゾーンを考慮したウィンドウ境界計算 | E-02 (lines 109-112) | ○ |
| C-10 | GroupWindowAssignerを使用 | E-02 (line 108) | ○ |
| C-11 | OneInputTransformationを生成 | E-02 (lines 97-103) | ○ |
| C-12 | TableExceptionをスロー（処理時間使用時） | E-04 (line 91) | ○ |
| C-13 | TableExceptionをスロー（非整列ウィンドウ使用時） | E-05 (line 102-103) | ○ |
| C-14 | 処理時間ウィンドウは将来サポート予定 | **根拠なし** | △ |
| C-15 | セッションウィンドウは将来サポート予定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 処理時間ウィンドウ/セッションウィンドウの将来サポート計画はソースコードのコメントやTODOに明示的な記載なし
  - 候補：Flink JIRA / Flink Improvement Proposals (FLIP) / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コア機能の記述は正確
- 1: 中リスク - 将来サポートに関する記述は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] 処理時間ウィンドウ未サポートの記述が現行バージョンで正確か確認
- [ ] セッションウィンドウ未サポートの記述が現行バージョンで正確か確認
- [ ] Flink 2.0バージョン要件が正しいか確認
- [ ] 将来サポート計画の記述を削除または公式情報に基づいて修正
