---
generated_at: 2026-02-02 17:32:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-BatchExecMatch

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：実測データなし
  2. **CEPライブラリバージョン依存関係**：要確認
  3. **NFA状態管理のメモリ使用量**：詳細な仕様確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecMatch.java` (lines 51-150)
- E-02: `CommonExecMatch.java` (lines 86-453)
- E-03: `@ExecNodeMetadata` アノテーション (lines 52-60)
- E-04: `checkOrderKeys` メソッド (lines 93-111)
- E-05: `translateOrder` メソッド (lines 114-149)
- E-06: `translatePattern` メソッド (E-02, lines 233-251)
- E-07: PatternVisitor内部クラス (E-02, lines 271-451)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MATCH_RECOGNIZE句のバッチ実行ノードである | E-01 (line 51), E-03 | ○ |
| C-02 | ORDER BY句が必須で非空であること | E-04 (lines 95-96) | ○ |
| C-03 | 先頭ソートキーは時間属性であること | E-04 (lines 99-104) | ○ |
| C-04 | 先頭ソートキーは昇順であること | E-04 (lines 107-109) | ○ |
| C-05 | イベント時間使用時はタイムスタンプ挿入を行う | E-05 (lines 126-148) | ○ |
| C-06 | 処理時間使用時は入力をそのまま返す | E-05 (lines 120-123) | ○ |
| C-07 | 空マッチ生成パターンは拒否 | E-02 (lines 138-141) | ○ |
| C-08 | 末尾の貪欲量化子は拒否 | E-02 (lines 143-148) | ○ |
| C-09 | ALL ROWS PER MATCHは未サポート | E-02 (lines 150-152) | ○ |
| C-10 | NFACompilerでNFAファクトリを生成 | E-02 (lines 160-161) | ○ |
| C-11 | CepOperatorを使用 | E-02 (lines 178-186) | ○ |
| C-12 | パーティションキーによるグループ化 | E-02 (lines 195-199) | ○ |
| C-13 | Flink 2.0以降で利用可能 | E-03 (minPlanVersion = FlinkVersion.v2_0) | ○ |
| C-14 | ブランチパターン（PATTERN_ALTER）は未サポート | E-07 (lines 350-354) | ○ |
| C-15 | PERMUTEパターンは未サポート | E-07 (lines 355-359) | ○ |
| C-16 | EXCLUDEパターンは未サポート | E-07 (lines 360-364) | ○ |
| C-17 | reluctantオプション変数は未サポート | E-07 (lines 446-447) | ○ |
| C-18 | メモリ使用量はNFA状態管理に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メモリ使用量の具体的な計算方法や上限設定に関する詳細仕様
  - 候補：CepOperator実装 / Flink CEPドキュメント / メモリ管理設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能制限と検証ロジックの記述は正確
- 1: 中リスク - パフォーマンス関連の記述は概要レベル

## 6) レビュアーチェックリスト（最小）
- [ ] ORDER BY検証ロジックの記述が正確か確認
- [ ] 未サポート機能の一覧が網羅的か確認
- [ ] CEPライブラリとの連携部分の整合性確認
- [ ] エラーメッセージとエラー条件の対応確認
