---
generated_at: 2026-02-02 17:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-BatchExecMultipleInput

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり
  2. 融合コード生成の有効化条件確認推奨
  3. メモリ管理の動作確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecMultipleInput.java` (lines 64-290)
- E-02: クラスJavadocコメント (lines 64-90)
- E-03: コンストラクタ (lines 98-116)
- E-04: `translateToPlanInternal` メソッド (lines 119-259)
- E-05: `allSupportFusionCodegen` メソッド (lines 274-278)
- E-06: `getInputMaxParallelism` メソッド (lines 280-289)
- E-07: アクセサメソッド (lines 261-272)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 複数ExecNodeのサブグラフを統合管理 | E-02 (lines 64-90) | ○ |
| C-02 | rootNodeがサブグラフのルート | E-02 (line 87), E-03 (line 112) | ○ |
| C-03 | memberExecNodesがメンバーノード | E-03 (line 113), E-07 (lines 265-267) | ○ |
| C-04 | inputPropertiesとoriginalEdgesサイズ一致チェック | E-03 (line 114) | ○ |
| C-05 | TABLE_EXEC_OPERATOR_FUSION_CODEGEN_ENABLEDで制御 | E-04 (line 139) | ○ |
| C-06 | allSupportFusionCodegenで融合サポート確認 | E-04 (line 141), E-05 | ○ |
| C-07 | BatchExecInputAdapterを挿入 | E-04 (lines 147-153) | ○ |
| C-08 | InputSelectionSpecを生成 | E-04 (lines 142, 167) | ○ |
| C-09 | SourceOpFusionCodegenSpecGeneratorを生成 | E-04 (lines 176-178) | ○ |
| C-10 | OutputFusionCodegenSpecでラップ | E-04 (lines 180-189) | ○ |
| C-11 | OperatorFusionCodegenFactoryを生成 | E-04 (lines 193-196) | ○ |
| C-12 | TableOperatorWrapperGeneratorを使用（非融合時） | E-04 (lines 203-205) | ○ |
| C-13 | BatchMultipleInputStreamOperatorFactoryを生成（非融合時） | E-04 (lines 209-215) | ○ |
| C-14 | MultipleInputTransformationを構築 | E-04 (lines 231-237) | ○ |
| C-15 | ChainingStrategy.HEAD_WITH_SOURCESを設定 | E-04 (line 256) | ○ |
| C-16 | マネージドメモリを設定 | E-04 (line 253) | ○ |
| C-17 | メモリ計算はmemoryWeight << 20 | E-04 (line 220) | ○ |
| C-18 | @ExecNodeMetadataアノテーションがない | E-01（アノテーション未定義） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] 融合コード生成有効時と無効時の動作差異確認
- [ ] InputSelectionSpecによる読み取り順序制御の動作確認
- [ ] マネージドメモリ設定の妥当性確認
- [ ] BatchExecInputAdapterとの連携動作確認
- [ ] rootNodeとmemberExecNodesの整合性確認
