---
generated_at: 2026-02-02 17:44:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-BatchExecScriptTransform

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり
  2. HiveScriptTransformOperatorの動作確認推奨
  3. flink-connectors-hive依存関係の確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecScriptTransform.java` (lines 42-120)
- E-02: クラスJavadocコメント (line 42)
- E-03: `HIVE_SCRIPT_TRANSFORM_OPERATOR_NAME` 定数 (lines 48-49)
- E-04: フィールド定義 (lines 51-54)
- E-05: コンストラクタ (lines 56-76)
- E-06: `translateToPlanInternal` メソッド (lines 80-92)
- E-07: `getScriptTransformOperator` メソッド (lines 95-119)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 外部スクリプトを使用したデータ変換を行う | E-02 | ○ |
| C-02 | Hive方言のTRANSFORM句をサポート | E-03 comment "only Hive dialect supports ScriptTransform" | ○ |
| C-03 | HiveScriptTransformOperatorクラス名は固定 | E-03 (lines 48-49) | ○ |
| C-04 | inputIndexesでスクリプトに渡すフィールドを指定 | E-04 (line 51), E-07 (line 109) | ○ |
| C-05 | scriptで実行コマンドを指定 | E-04 (line 52), E-07 (line 110) | ○ |
| C-06 | scriptTransformIOInfoで入出力フォーマットを指定 | E-04 (line 53), E-07 (line 111) | ○ |
| C-07 | inputTypeとoutputTypeで型を指定 | E-04 (line 54), E-07 (lines 112-113) | ○ |
| C-08 | リフレクションでクラスロード | E-07 (lines 97-101) | ○ |
| C-09 | コンストラクタをリフレクションで呼び出し | E-07 (lines 102-108) | ○ |
| C-10 | TableExceptionをスロー（エラー時） | E-07 (lines 116-118) | ○ |
| C-11 | OneInputTransformationを構築 | E-06 (lines 85-91) | ○ |
| C-12 | 並列度は入力と同一 | E-06 (line 90) inputTransform.getParallelism() | ○ |
| C-13 | @ExecNodeMetadataアノテーションがない | E-01（アノテーション未定義） | ○ |
| C-14 | ExecNodeContextにBatchExecLimitを使用 | E-05 (lines 67-68) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] HiveScriptTransformOperatorのクラスパス存在確認
- [ ] flink-connectors-hive依存関係の確認
- [ ] スクリプト実行時のセキュリティ考慮事項確認
- [ ] ScriptTransformIOInfoの入出力フォーマット仕様確認
- [ ] リフレクションによるクラスロードのエラーハンドリング確認
