---
generated_at: 2026-02-02 17:46:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-BatchExecMLPredictTableFunction

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり
  2. 非同期設定オプションの動作確認推奨
  3. モデルプロバイダーの実装要件確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecMLPredictTableFunction.java` (lines 42-101)
- E-02: `CommonExecMLPredictTableFunction.java` (lines 68-246)
- E-03: `@ExecNodeMetadata` アノテーション (E-01, lines 43-53)
- E-04: コンストラクタ (E-01, lines 57-100)
- E-05: `translateToPlanInternal` メソッド (E-02, lines 103-142)
- E-06: `createModelPredict` メソッド (E-02, lines 144-181)
- E-07: `createAsyncModelPredict` メソッド (E-02, lines 184-223)
- E-08: `findModelFunction` メソッド (E-02, lines 225-245)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ML_PREDICT関数のバッチ実行ノード | E-01 (line 42 comment), E-03 | ○ |
| C-02 | Flink 2.3以降で利用可能 | E-03 (minPlanVersion = FlinkVersion.v2_3) | ○ |
| C-03 | 消費する設定オプション3つ | E-03 (consumedOptions) | ○ |
| C-04 | asyncOptionsがnullで同期モード | E-05 (line 109) | ○ |
| C-05 | ModelProvider.getModelProviderでプロバイダー取得 | E-05 (line 108) | ○ |
| C-06 | PredictRuntimeProvider.createPredictFunction（同期） | E-08 (lines 235-236) | ○ |
| C-07 | AsyncPredictRuntimeProvider.createAsyncPredictFunction（非同期） | E-08 (lines 231-233) | ○ |
| C-08 | TableExceptionをスロー（プロバイダー不整合時） | E-08 (lines 240-244) | ○ |
| C-09 | MLPredictCodeGenerator.generateSyncPredictFunction | E-06 (lines 153-164) | ○ |
| C-10 | MLPredictCodeGenerator.generateAsyncPredictFunction | E-07 (lines 195-207) | ○ |
| C-11 | MLPredictCodeGenerator.generateCollector | E-06 (lines 165-170) | ○ |
| C-12 | ProcessOperator(MLPredictRunner)（同期） | E-06 (lines 171-173) | ○ |
| C-13 | AsyncWaitOperatorFactory(AsyncMLPredictRunner)（非同期） | E-07 (lines 215-219) | ○ |
| C-14 | 並列度は入力と同一 | E-06 (line 179), E-07 (line 221) | ○ |
| C-15 | CommonExecMLPredictTableFunctionを継承 | E-01 (line 54) | ○ |
| C-16 | SingleTransformationTranslatorを実装 | E-01 (line 55) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Flink 2.3バージョン要件の確認
- [ ] 非同期設定オプションのデフォルト値確認
- [ ] PredictRuntimeProvider/AsyncPredictRuntimeProviderの実装要件確認
- [ ] モデルプロバイダーのエラーハンドリング確認
- [ ] PipelineOptions.OBJECT_REUSE設定との連携確認
