---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：4-BatchExecLegacyTableSourceScan

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **リトライ仕様詳細**：コネクタ実装依存のため要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecLegacyTableSourceScan.java` (L51-54: クラスJavadoc)
- E-02: `BatchExecLegacyTableSourceScan.java` (L55-56: クラス宣言)
- E-03: `BatchExecLegacyTableSourceScan.java` (L58-73: コンストラクタ)
- E-04: `BatchExecLegacyTableSourceScan.java` (L75-84: translateToPlanInternal)
- E-05: `BatchExecLegacyTableSourceScan.java` (L86-119: createConversionTransformationIfNeeded)
- E-06: `BatchExecLegacyTableSourceScan.java` (L121-133: createInput)
- E-07: `バッチ一覧.csv` (L5: BatchExecLegacyTableSourceScanの説明)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レガシーAPIを使用したテーブルソーススキャン | E-01, E-07 | ○ |
| C-02 | StreamTableSourceからデータ読み取り | E-01 | ○ |
| C-03 | CommonExecLegacyTableSourceScanを継承 | E-02 | ○ |
| C-04 | BatchExecNodeインターフェース実装 | E-02 | ○ |
| C-05 | tableSourceパラメータ | E-03 | ○ |
| C-06 | qualifiedNameパラメータ | E-03 | ○ |
| C-07 | translateToPlanInternalで親クラスメソッド呼び出し | E-04 | ○ |
| C-08 | makeLegacySourceTransformationsBoundedの呼び出し | E-04 (L82) | ○ |
| C-09 | createConversionTransformationIfNeededの存在 | E-05 | ○ |
| C-10 | 型精度修正（fixPrecisionForProducedDataType） | E-05 (L99-101) | ○ |
| C-11 | needInternalConversionで変換必要性判定 | E-05 (L95) | ○ |
| C-12 | ScanUtil.convertToInternalRowで変換実行 | E-05 (L102-114) | ○ |
| C-13 | createInputでInputFormatSourceFunction使用 | E-06 | ○ |
| C-14 | tableSource.explainSourceでオペレータ名取得 | E-06 (L132) | ○ |
| C-15 | 有界性マークの付与 | E-04 (L80-82) | ○ |
| C-16 | リトライ仕様の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リトライ仕様の詳細
  - 候補：各コネクタ実装 / コネクタドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接抽出した情報が多い
- 1: 中リスク - レガシーAPIのため将来的な廃止可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] レガシーAPIの非推奨警告が適切に記載されているか確認
- [ ] 型精度修正の処理が正確に説明されているか確認
- [ ] 新APIへの移行ガイダンスが十分か確認
