---
generated_at: 2026-02-02 17:48:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-BatchExecVectorSearchTableFunction

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 全ての主張に根拠あり
  2. 非同期設定オプションの動作確認推奨
  3. ベクトル検索プロバイダーの実装要件確認推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecVectorSearchTableFunction.java` (lines 42-101)
- E-02: `CommonExecVectorSearchTableFunction.java` (lines 79-301)
- E-03: `@ExecNodeMetadata` アノテーション (E-01, lines 43-53)
- E-04: コンストラクタ (E-01, lines 57-100)
- E-05: `translateToPlanInternal` メソッド (E-02, lines 114-168)
- E-06: `findVectorSearchFunction` メソッド (E-02, lines 172-190)
- E-07: `createSyncVectorSearchOperator` メソッド (E-02, lines 192-212)
- E-08: `createAsyncVectorSearchOperator` メソッド (E-02, lines 256-300)
- E-09: `createSyncVectorSearchFunction` メソッド (E-02, lines 214-254)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VECTOR_SEARCH関数のバッチ実行ノード | E-01 (line 42 comment), E-03 | ○ |
| C-02 | Flink 2.2以降で利用可能 | E-03 (minPlanVersion = FlinkVersion.v2_2) | ○ |
| C-03 | 消費する設定オプション3つ | E-03 (consumedOptions) | ○ |
| C-04 | tableSourceSpec.getSearchTableでテーブル取得 | E-05 (lines 121-122) | ○ |
| C-05 | VectorSearchUtil.createVectorSearchRuntimeProvider | E-05 (lines 126-131) | ○ |
| C-06 | asyncOptionsがnullで同期モード | E-05 (line 123) | ○ |
| C-07 | VectorSearchFunctionProvider.createVectorSearchFunction（同期） | E-06 (lines 180-182) | ○ |
| C-08 | AsyncVectorSearchFunctionProvider.createAsyncVectorSearchFunction（非同期） | E-06 (lines 175-178) | ○ |
| C-09 | TableExceptionをスロー（プロバイダー不整合時） | E-06 (lines 184-189) | ○ |
| C-10 | VectorSearchCodeGenerator.generateSyncVectorSearchFunction | E-09 (lines 227-241) | ○ |
| C-11 | VectorSearchCodeGenerator.generateAsyncVectorSearchFunction | E-08 (lines 271-285) | ○ |
| C-12 | VectorSearchCodeGenerator.generateCollector | E-09 (lines 242-247) | ○ |
| C-13 | ProcessOperator(VectorSearchRunner)（同期） | E-07 (lines 201-211) | ○ |
| C-14 | AsyncWaitOperatorFactory(AsyncVectorSearchRunner)（非同期） | E-08 (lines 291-299) | ○ |
| C-15 | vectorSearchSpec.getJoinTypeでINNER/LEFT選択 | E-09 (line 248), E-08 (line 287) | ○ |
| C-16 | 並列度は入力と同一 | E-05 (line 166) | ○ |
| C-17 | CommonExecVectorSearchTableFunctionを継承 | E-01 (line 54) | ○ |
| C-18 | SingleTransformationTranslatorを実装 | E-01 (line 55) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主要な主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] Flink 2.2バージョン要件の確認
- [ ] 非同期設定オプションのデフォルト値確認
- [ ] VectorSearchFunctionProvider/AsyncVectorSearchFunctionProviderの実装要件確認
- [ ] INNER/LEFT JOIN動作の確認
- [ ] TopKパラメータの範囲チェック確認
- [ ] searchColumnsの型検証確認
