---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：5-BatchExecSink

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **トランザクション仕様詳細**：コネクタ実装依存のため確認要
  2. **リトライ仕様詳細**：コネクタ実装依存のため確認要

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecSink.java` (L51-53: クラスJavadoc)
- E-02: `BatchExecSink.java` (L54-67: ExecNodeMetadata)
- E-03: `BatchExecSink.java` (L68: クラス宣言)
- E-04: `BatchExecSink.java` (L69-85: コンストラクタ)
- E-05: `BatchExecSink.java` (L108-124: translateToPlanInternal)
- E-06: `BatchExecSink.java` (L126-149: getPersistedRowType)
- E-07: `BatchExecSink.java` (L151-161: applyUpsertMaterialize)
- E-08: `BatchExecSink.java` (L163-187: getPrimaryKeyIndices)
- E-09: `CommonExecSink.java` (L141-250: createSinkTransformation)
- E-10: `CommonExecSink.java` (L255-291: applyConstraintValidations)
- E-11: `CommonExecSink.java` (L328-367: applyKeyBy)
- E-12: `バッチ一覧.csv` (L6: BatchExecSinkの説明)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DynamicTableSinkにデータを書き込む | E-01, E-12 | ○ |
| C-02 | ExecNodeMetadataのname="batch-exec-sink" | E-02 | ○ |
| C-03 | version=1 | E-02 | ○ |
| C-04 | FlinkVersion v2.0以降で使用可能 | E-02 (minPlanVersion) | ○ |
| C-05 | CommonExecSinkを継承 | E-03 | ○ |
| C-06 | BatchExecNodeインターフェース実装 | E-03 | ○ |
| C-07 | isBounded=trueで有界データ | E-04 (L81) | ○ |
| C-08 | ChangelogMode.insertOnly() | E-04 (L80) | ○ |
| C-09 | translateToPlanInternalで入力Transformation取得 | E-05 | ○ |
| C-10 | createSinkTransformationの呼び出し | E-05 | ○ |
| C-11 | 消費オプション（not-null-enforcer, type-length-enforcer） | E-02 (consumedOptions) | ○ |
| C-12 | 制約検証（applyConstraintValidations） | E-10 | ○ |
| C-13 | パーティショニング（applyKeyBy） | E-11 | ○ |
| C-14 | 行レベル更新（RowLevelUpdateSpec） | E-06 (L133-138) | ○ |
| C-15 | 行レベル削除（RowLevelDeleteSpec） | E-06 (L139-145) | ○ |
| C-16 | getPersistedRowTypeでの型取得 | E-06 | ○ |
| C-17 | applyUpsertMaterializeは入力をそのまま返す | E-07 | ○ |
| C-18 | getPrimaryKeyIndicesで主キー取得 | E-08 | ○ |
| C-19 | 主キー不完全時は空配列を返す | E-08 (L178-180) | ○ |
| C-20 | legacyPhysicalTypeEnabled=false | BatchExecSink.java (L201-203) | ○ |
| C-21 | CONSTRAINT_VALIDATOR_TRANSFORMATION定数 | E-09 | ○ |
| C-22 | SINK_TRANSFORMATION定数 | E-02 (producedTransformations) | ○ |
| C-23 | トランザクション仕様詳細 | **根拠なし** | △ |
| C-24 | リトライ仕様詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- トランザクション仕様の詳細
  - 候補：各シンクコネクタ実装 / コネクタドキュメント
- リトライ仕様の詳細
  - 候補：各シンクコネクタ実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接抽出した情報が多い
- 1: 中リスク - 運用関連情報（トランザクション・リトライ）は実装依存
- 1: 中リスク - 行レベル更新/削除は高度な機能のため追加確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 行レベル更新/削除の動作説明が正確か確認
- [ ] 制約検証（NOT NULL、型長さ）の説明が十分か確認
- [ ] 主キーパーティショニングのユースケースが明確か確認
