---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-BatchExecLegacySink

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **トランザクション/リトライ仕様**：コネクタ実装依存のため確認要

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecLegacySink.java` (L37-41: クラスJavadoc)
- E-02: `BatchExecLegacySink.java` (L42: クラス宣言)
- E-03: `BatchExecLegacySink.java` (L44-61: コンストラクタ)
- E-04: `BatchExecLegacySink.java` (L64-69: checkAndConvertInputTypeIfNeeded)
- E-05: `BatchExecLegacySink.java` (L77-92: validateType)
- E-06: `バッチ一覧.csv` (L7: BatchExecLegacySinkの説明)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レガシーAPIを使用したシンク | E-01, E-06 | ○ |
| C-02 | TableSinkにデータを書き込む | E-01 | ○ |
| C-03 | CommonExecLegacySinkを継承 | E-02 | ○ |
| C-04 | BatchExecNodeインターフェース実装 | E-02 | ○ |
| C-05 | tableSinkパラメータ | E-03 | ○ |
| C-06 | upsertKeysパラメータ（nullable） | E-03 (L47) | ○ |
| C-07 | needRetraction=false | E-03 (L57) | ○ |
| C-08 | isStreaming=false | E-03 (L58) | ○ |
| C-09 | checkAndConvertInputTypeIfNeededの存在 | E-04 | ○ |
| C-10 | getConsumedDataTypeで出力型取得 | E-04 (L66) | ○ |
| C-11 | validateTypeメソッドの存在 | E-05 | ○ |
| C-12 | isMemberClass && !static はエラー | E-05 (L84) | ○ |
| C-13 | !isPublic はエラー | E-05 (L85) | ○ |
| C-14 | canonicalName==null はエラー | E-05 (L86) | ○ |
| C-15 | TableException発生（型制約違反時） | E-05 (L87-91) | ○ |
| C-16 | ClassLogicalTypeConverterの使用 | E-05 (L80-82) | ○ |
| C-17 | 入力行型をそのまま返す | E-04 (L68) | ○ |
| C-18 | トランザクション/リトライ仕様詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- トランザクション/リトライ仕様の詳細
  - 候補：各シンクコネクタ実装 / CommonExecLegacySink実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接抽出した情報が多い
- 1: 中リスク - レガシーAPIのため将来的な廃止可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] レガシーAPIの非推奨警告が適切に記載されているか確認
- [ ] 型制約（静的・公開・グローバルアクセス）の説明が十分か確認
- [ ] 新APIへの移行ガイダンスが十分か確認
