---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：7-BatchExecHashJoin

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **スピル発生時の詳細動作**：スピル機構の詳細確認要

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecHashJoin.java` (L63: クラスJavadoc)
- E-02: `BatchExecHashJoin.java` (L64-76: ExecNodeMetadata)
- E-03: `BatchExecHashJoin.java` (L77-80: クラス宣言)
- E-04: `BatchExecHashJoin.java` (L82-91: フィールド定義)
- E-05: `BatchExecHashJoin.java` (L93-118: フィールド定義続き)
- E-06: `BatchExecHashJoin.java` (L120-151: コンストラクタ)
- E-07: `BatchExecHashJoin.java` (L185-245: translateToPlanInternal)
- E-08: `BatchExecHashJoin.java` (L247-265: supportFusionCodegen)
- E-09: `BatchExecHashJoin.java` (L267-304: translateToFusionCodegenSpecInternal)
- E-10: `BatchExecHashJoin.java` (L306-309: canBeTransformedToAdaptiveJoin)
- E-11: `BatchExecHashJoin.java` (L311-326: toAdaptiveJoinNode)
- E-12: `バッチ一覧.csv` (L8: BatchExecHashJoinの説明)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ハッシュベースの結合演算子 | E-01, E-12 | ○ |
| C-02 | ビルドサイドのハッシュテーブル構築 | E-12 | ○ |
| C-03 | ExecNodeMetadataのname="batch-exec-join" | E-02 | ○ |
| C-04 | version=1 | E-02 | ○ |
| C-05 | FlinkVersion v2.0以降で使用可能 | E-02 (minPlanVersion) | ○ |
| C-06 | 消費オプション（hash-join.memory等） | E-02 (consumedOptions) | ○ |
| C-07 | SingleTransformationTranslator実装 | E-03 | ○ |
| C-08 | AdaptiveJoinExecNode実装 | E-03 | ○ |
| C-09 | joinSpecフィールド | E-04 | ○ |
| C-10 | isBroadcastフィールド | E-04 | ○ |
| C-11 | leftIsBuildフィールド | E-04 | ○ |
| C-12 | estimatedLeftAvgRowSizeフィールド | E-05 | ○ |
| C-13 | estimatedRightAvgRowSizeフィールド | E-05 | ○ |
| C-14 | estimatedLeftRowCountフィールド | E-05 | ○ |
| C-15 | estimatedRightRowCountフィールド | E-05 | ○ |
| C-16 | tryDistinctBuildRowフィールド | E-05 | ○ |
| C-17 | withJobStrategyHintフィールド | E-05 | ○ |
| C-18 | translateToPlanInternalで入力Transformation取得 | E-07 | ○ |
| C-19 | JoinUtil.generateConditionFunction呼び出し | E-07 (L199-205) | ○ |
| C-20 | HashJoinOperatorUtil.generateOperatorFactory呼び出し | E-07 (L207-224) | ○ |
| C-21 | leftIsBuildでビルド/プローブ決定 | E-07 (L226-234) | ○ |
| C-22 | ExecNodeUtil.createTwoInputTransformation呼び出し | E-07 (L236-244) | ○ |
| C-23 | supportFusionCodegenメソッドの存在 | E-08 | ○ |
| C-24 | LongHashJoinGenerator.supportで最適化判定 | E-08 (L264) | ○ |
| C-25 | canBeTransformedToAdaptiveJoinメソッド | E-10 | ○ |
| C-26 | FULL JOINはAdaptive変換非対応 | E-10 (L308) | ○ |
| C-27 | toAdaptiveJoinNodeでBatchExecAdaptiveJoin生成 | E-11 | ○ |
| C-28 | スピル機構の詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- スピル機構の詳細動作
  - 候補：HashJoinOperator実装 / Flink Runtime実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接抽出した情報が多い
- 0: 低リスク - ExecNodeMetadataからの情報は正確

## 6) レビュアーチェックリスト（最小）
- [ ] ビルドサイド/プローブサイドの決定ロジックが正確か確認
- [ ] 対応する結合タイプの一覧が正確か確認
- [ ] Fusion Codegenサポートの説明が十分か確認
- [ ] 適応型結合への変換条件が明確か確認
