---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：8-BatchExecSortMergeJoin

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **ソート入力の前提条件**：前段のソート処理挿入に関する詳細確認要

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecSortMergeJoin.java` (L53: クラスJavadoc)
- E-02: `BatchExecSortMergeJoin.java` (L54-57: クラス宣言)
- E-03: `BatchExecSortMergeJoin.java` (L59-69: フィールド定義)
- E-04: `BatchExecSortMergeJoin.java` (L71-109: コンストラクタ)
- E-05: `BatchExecSortMergeJoin.java` (L111-170: translateToPlanInternal)
- E-06: `BatchExecSortMergeJoin.java` (L172-175: canBeTransformedToAdaptiveJoin)
- E-07: `BatchExecSortMergeJoin.java` (L177-192: toAdaptiveJoinNode)
- E-08: `バッチ一覧.csv` (L9: BatchExecSortMergeJoinの説明)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ソートマージ結合のバッチ実行ノード | E-01, E-08 | ○ |
| C-02 | 両側をソートしてマージ結合 | E-08 | ○ |
| C-03 | ExecNodeBaseを継承 | E-02 | ○ |
| C-04 | BatchExecNodeインターフェース実装 | E-02 | ○ |
| C-05 | SingleTransformationTranslator実装 | E-02 | ○ |
| C-06 | AdaptiveJoinExecNode実装 | E-02 | ○ |
| C-07 | joinTypeフィールド | E-03 | ○ |
| C-08 | leftKeys/rightKeysフィールド | E-03 | ○ |
| C-09 | filterNullsフィールド | E-03 | ○ |
| C-10 | nonEquiConditionフィールド | E-03 | ○ |
| C-11 | estimatedサイズ/カウントフィールド | E-03 | ○ |
| C-12 | leftIsSmallerフィールド | E-03 | ○ |
| C-13 | withJobStrategyHintフィールド | E-03 | ○ |
| C-14 | 外部バッファメモリ取得 | E-05 (L122-124) | ○ |
| C-15 | ソートメモリ取得 | E-05 (L125-126) | ○ |
| C-16 | FULL JOINで外部バッファ2つ使用 | E-05 (L127-130) | ○ |
| C-17 | managedMemory = externalBuffer x N + sort x 2 | E-05 (L132) | ○ |
| C-18 | JoinUtil.generateConditionFunction呼び出し | E-05 (L134-140) | ○ |
| C-19 | SorMergeJoinOperatorUtil.generateOperatorFactory呼び出し | E-05 (L142-154) | ○ |
| C-20 | canBeTransformedToAdaptiveJoinの条件 | E-06 | ○ |
| C-21 | FULL JOINはAdaptive変換非対応 | E-06 (L174) | ○ |
| C-22 | 前段ソート処理の挿入詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 前段ソート処理の挿入に関する詳細
  - 候補：プランナー最適化ルール / BatchExecSort連携

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接抽出した情報が多い
- 1: 中リスク - 前段処理との連携は推測含む

## 6) レビュアーチェックリスト（最小）
- [ ] 外部バッファとソートメモリの計算が正確か確認
- [ ] FULL JOINでの2バッファ使用の説明が十分か確認
- [ ] 適応型結合への変換条件が明確か確認
