---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-BatchExecNestedLoopJoin

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `BatchExecNestedLoopJoin.java` (L53: クラスJavadoc)
- E-02: `BatchExecNestedLoopJoin.java` (L54-60: ExecNodeMetadata)
- E-03: `BatchExecNestedLoopJoin.java` (L61-62: クラス宣言)
- E-04: `BatchExecNestedLoopJoin.java` (L64-68: フィールド定義)
- E-05: `BatchExecNestedLoopJoin.java` (L70-80: フィールド定義続き)
- E-06: `BatchExecNestedLoopJoin.java` (L82-103: コンストラクタ)
- E-07: `BatchExecNestedLoopJoin.java` (L105-123: JSONコンストラクタ)
- E-08: `BatchExecNestedLoopJoin.java` (L125-174: translateToPlanInternal)
- E-09: `バッチ一覧.csv` (L10: BatchExecNestedLoopJoinの説明)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ネステッドループ結合のバッチ実行ノード | E-01, E-09 | ○ |
| C-02 | 外側ループと内側ループで全組み合わせを比較 | E-09 | ○ |
| C-03 | ExecNodeMetadataのname="batch-exec-nested-loop-join" | E-02 | ○ |
| C-04 | version=1 | E-02 | ○ |
| C-05 | FlinkVersion v2.0以降で使用可能 | E-02 (minPlanVersion) | ○ |
| C-06 | 消費オプション（external-buffer-memory） | E-02 (consumedOptions) | ○ |
| C-07 | ExecNodeBaseを継承 | E-03 | ○ |
| C-08 | BatchExecNodeインターフェース実装 | E-03 | ○ |
| C-09 | SingleTransformationTranslator実装 | E-03 | ○ |
| C-10 | joinTypeフィールド | E-04 | ○ |
| C-11 | conditionフィールド | E-04 | ○ |
| C-12 | leftIsBuildフィールド | E-05 | ○ |
| C-13 | singleRowJoinフィールド | E-05 | ○ |
| C-14 | NestedLoopJoinCodeGeneratorの呼び出し | E-08 (L141-152) | ○ |
| C-15 | 並列度はプローブ側を使用 | E-08 (L154-157) | ○ |
| C-16 | singleRowJoin時はmanagedMem=0 | E-08 (L158-163) | ○ |
| C-17 | 非singleRowJoin時は外部バッファメモリ使用 | E-08 (L160-162) | ○ |
| C-18 | ExecNodeUtil.createTwoInputTransformation呼び出し | E-08 (L165-173) | ○ |
| C-19 | JOIN_TRANSFORMATION="nested-loop-join" | E-02 (producedTransformations), E-03 (L64) | ○ |
| C-20 | JSONシリアライズ対応（@JsonCreator） | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルな実装で全主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] singleRowJoin最適化の説明が十分か確認
- [ ] 非等価結合条件対応の説明が十分か確認
- [ ] O(n*m)のパフォーマンス特性の警告が明確か確認
