---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：flink-connectors_flink-connector-base 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **C-116, C-117**: AsyncDynamicTableSinkの抽象クラスの具象実装に依存
  2. **テスト優先度「高」の項目**: ビジネスロジック・チェックポイント関連の検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/reader/SourceReaderBase.java`
- E-02: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/sink/writer/AsyncSinkWriter.java`
- E-03: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/hybrid/HybridSource.java`
- E-04: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/hybrid/HybridSourceSplitEnumerator.java`
- E-05: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/hybrid/HybridSourceReader.java`
- E-06: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/reader/fetcher/SplitFetcherManager.java`
- E-07: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/reader/fetcher/SplitFetcher.java`
- E-08: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/reader/synchronization/FutureCompletingBlockingQueue.java`
- E-09: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/sink/writer/strategy/AIMDScalingStrategy.java`
- E-10: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/sink/writer/strategy/CongestionControlRateLimitingStrategy.java`
- E-11: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/sink/writer/BufferedRequestState.java`
- E-12: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/sink/writer/AsyncSinkWriterStateSerializer.java`
- E-13: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/reader/RecordsBySplits.java`
- E-14: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/sink/writer/DequeRequestBuffer.java`
- E-15: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/hybrid/HybridSourceSplit.java`
- E-16: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/source/reader/fetcher/FetchTask.java`
- E-17: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/sink/AsyncSinkBase.java`
- E-18: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/table/sink/AsyncDynamicTableSink.java`
- E-19: `flink-connectors/flink-connector-base/src/main/java/org/apache/flink/connector/base/DeliveryGuarantee.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### SourceReaderBase関連 (C-01 - C-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pollNextが正常にレコード取得 | E-01 (line 177-190) | ○ |
| C-02 | Rate Limiting有効時の動作 | E-01 (line 219-260) | ○ |
| C-03 | キュー空時の処理 | E-01 (line 267-280) | ○ |
| C-04 | addSplitsの正常系 | E-01 (line 365-374) | ○ |
| C-05 | 空スプリットリスト | E-01 (line 365-374) | ○ |
| C-06 | snapshotState | E-01 (line 348-352) | ○ |
| C-07 | notifyNoMoreSplits | E-01 (line 377-381) | ○ |
| C-08 | close | E-01 (line 395-398) | ○ |
| C-09 | getNumberOfCurrentlyAssignedSplits | E-01 (line 407-409) | ○ |
| C-10 | isAvailable | E-01 (line 341-345) | ○ |
| C-11 | pauseOrResumeSplits | E-01 (line 389-392) | ○ |

### AsyncSinkWriter関連 (C-12 - C-25)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | write正常系 | E-02 (line 312-320) | ○ |
| C-13 | バッファフル時のflush | E-02 (line 313-315) | ○ |
| C-14 | レコードサイズ超過 | E-02 (line 415-420) | ○ |
| C-15 | flush正常系 | E-02 (line 353-376) | ○ |
| C-16 | 空バッファのflush | E-02 (line 366-368) | ○ |
| C-17 | snapshotState | E-02 (line 456-458) | ○ |
| C-18 | maxBatchSize=0バリデーション | E-02 (line 253) | ○ |
| C-19 | maxBufferedRequests検証 | E-02 (line 258-261) | ○ |
| C-20 | elementConverter nullチェック | E-02 (line 252) | ○ |
| C-21 | ResultHandler.complete | E-02 (line 499-507) | ○ |
| C-22 | ResultHandler.completeExceptionally | E-02 (line 510-518) | ○ |
| C-23 | ResultHandler.retryForEntries | E-02 (line 521-529) | ○ |
| C-24 | timeoutリトライ | E-02 (line 531-549) | ○ |
| C-25 | timeout例外 | E-02 (line 535-541) | ○ |

### HybridSource関連 (C-26 - C-33)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | getBoundedness | E-03 (line 110-112) | ○ |
| C-27 | createReader | E-03 (line 116-119) | ○ |
| C-28 | createEnumerator | E-03 (line 123-126) | ○ |
| C-29 | restoreEnumerator | E-03 (line 130-136) | ○ |
| C-30 | Builder.addSource | E-03 (line 243-246) | ○ |
| C-31 | UNBOUNDED検証 | E-03 (line 253-257) | ○ |
| C-32 | build | E-03 (line 265-267) | ○ |
| C-33 | 空リスト検証 | E-03 (line 98) | ○ |

### SplitFetcherManager関連 (C-34 - C-41)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | createSplitFetcher | E-06 (line 201-230) | ○ |
| C-35 | クローズ後の生成禁止 | E-06 (line 202-204) | ○ |
| C-36 | アイドルFetcherシャットダウン | E-06 (line 237-249) | ○ |
| C-37 | 全Fetcher完了チェック | E-06 (line 248) | ○ |
| C-38 | close | E-06 (line 266-301) | ○ |
| C-39 | タイムアウト処理 | E-06 (line 295-300) | ○ |
| C-40 | checkErrors | E-06 (line 303-309) | ○ |
| C-41 | pauseOrResumeSplits | E-06 (line 166-176) | ○ |

### SplitFetcher関連 (C-42 - C-50)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | run | E-07 (line 127-164) | ○ |
| C-43 | runOnce | E-07 (line 167-211) | ○ |
| C-44 | クローズ後の動作 | E-07 (line 173-175) | ○ |
| C-45 | addSplits | E-07 (line 263-271) | ○ |
| C-46 | removeSplits | E-07 (line 278-288) | ○ |
| C-47 | shutdown | E-07 (line 353-368) | ○ |
| C-48 | isIdle | E-07 (line 384-391) | ○ |
| C-49 | pause | E-07 (line 433-440) | ○ |
| C-50 | resume | E-07 (line 442-450) | ○ |

### FutureCompletingBlockingQueue関連 (C-51 - C-59)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | put正常系 | E-08 (line 193-210) | ○ |
| C-52 | put nullチェック | E-08 (line 194-196) | ○ |
| C-53 | put満杯時 | E-08 (line 199-204) | ○ |
| C-54 | poll正常系 | E-08 (line 250-261) | ○ |
| C-55 | poll空キュー | E-08 (line 253-255) | ○ |
| C-56 | getAvailabilityFuture | E-08 (line 142-144) | ○ |
| C-57 | notifyAvailable | E-08 (line 154-161) | ○ |
| C-58 | wakeUpPuttingThread | E-08 (line 320-332) | ○ |
| C-59 | capacity検証 | E-08 (line 114) | ○ |

### HybridSourceSplitEnumerator関連 (C-60 - C-67)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | start | E-04 (line 102-104) | ○ |
| C-61 | handleSplitRequest | E-04 (line 107-115) | ○ |
| C-62 | addSplitsBack | E-04 (line 118-142) | ○ |
| C-63 | addReader | E-04 (line 145-148) | ○ |
| C-64 | snapshotState | E-04 (line 178-185) | ○ |
| C-65 | handleSourceEvent | E-04 (line 198-249) | ○ |
| C-66 | ソース切り替え | E-04 (line 236-244) | ○ |
| C-67 | close | E-04 (line 252-257) | ○ |

### スケーリング戦略関連 (C-68 - C-79)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | scaleUp正常系 | E-09 (line 45-47) | ○ |
| C-69 | scaleUp上限 | E-09 (line 46) | ○ |
| C-70 | scaleDown正常系 | E-09 (line 50-52) | ○ |
| C-71 | scaleDown下限 | E-09 (line 51) | ○ |
| C-72 | increaseRate検証 | E-09 (line 34) | ○ |
| C-73 | decreaseFactor検証 | E-09 (line 35-37) | ○ |
| C-74 | registerInFlightRequest | E-10 (line 61-64) | ○ |
| C-75 | 成功時スケールアップ | E-10 (line 67-74) | ○ |
| C-76 | 失敗時スケールダウン | E-10 (line 70-71) | ○ |
| C-77 | shouldBlock true | E-10 (line 78-81) | ○ |
| C-78 | shouldBlock false | E-10 (line 78-81) | ○ |
| C-79 | getMaxBatchSize | E-10 (line 84-86) | ○ |

### その他 (C-80 - C-120)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | BufferedRequestState.getBufferedRequestEntries | E-11 (line 58-60) | ○ |
| C-81 | BufferedRequestState.getStateSize | E-11 (line 62-64) | ○ |
| C-82 | BufferedRequestState.emptyState | E-11 (line 75-77) | ○ |
| C-83 | AsyncSinkWriterStateSerializer.serialize | E-12 (line 49-66) | ○ |
| C-84 | AsyncSinkWriterStateSerializer.deserialize | E-12 (line 69-87) | ○ |
| C-85 | deserialize識別子検証 | E-12 (line 95-98) | ○ |
| C-86 | RecordsBySplits.nextSplit | E-13 (line 56-64) | ○ |
| C-87 | nextSplit終端 | E-13 (line 61-63) | ○ |
| C-88 | nextRecordFromSplit | E-13 (line 68-74) | ○ |
| C-89 | nextRecordFromSplit状態チェック | E-13 (line 69-71) | ○ |
| C-90 | finishedSplits | E-13 (line 77-79) | ○ |
| C-91 | Builder.add | E-13 (line 98-100) | ○ |
| C-92 | Builder.addFinishedSplit | E-13 (line 146-148) | ○ |
| C-93 | DequeRequestBuffer.add末尾 | E-14 (line 52-59) | ○ |
| C-94 | DequeRequestBuffer.add先頭 | E-14 (line 53-55) | ○ |
| C-95 | DequeRequestBuffer.poll | E-14 (line 87-93) | ○ |
| C-96 | DequeRequestBuffer.poll空 | E-14 (line 88-92) | ○ |
| C-97 | DequeRequestBuffer.totalSizeInBytes | E-14 (line 97-99) | ○ |
| C-98 | HybridSourceReader.start | E-05 (line 70-78) | ○ |
| C-99 | HybridSourceReader.pollNext | E-05 (line 81-106) | ○ |
| C-100 | pollNext END_OF_INPUT | E-05 (line 87-104) | ○ |
| C-101 | pollNext リーダー未設定 | E-05 (line 82-84) | ○ |
| C-102 | addSplits | E-05 (line 141-163) | ○ |
| C-103 | addSplitsインデックス検証 | E-05 (line 154-158) | ○ |
| C-104 | handleSourceEvents | E-05 (line 178-192) | ○ |
| C-105 | snapshotState | E-05 (line 109-115) | ○ |
| C-106 | close | E-05 (line 195-204) | ○ |
| C-107 | HybridSourceSplit.wrapSplit | E-15 (line 95-106) | ○ |
| C-108 | HybridSourceSplit.unwrapSplit | E-15 (line 117-126) | ○ |
| C-109 | equals同一 | E-15 (line 64-79) | ○ |
| C-110 | equals異なる | E-15 (line 72-74) | ○ |
| C-111 | FetchTask.run | E-16 (line 55-86) | ○ |
| C-112 | FetchTask完了コールバック | E-16 (line 65-68) | ○ |
| C-113 | FetchTask.wakeUp | E-16 (line 89-103) | ○ |
| C-114 | AsyncSinkBase.getElementConverter | E-17 (line 108-110) | ○ |
| C-115 | AsyncSinkBase nullチェック | E-17 (line 95-97) | ○ |
| C-116 | AsyncDynamicTableSink.equals | E-18 (line 62-79) | △ |
| C-117 | AsyncDynamicTableSink.hashCode | E-18 (line 82-89) | △ |
| C-118 | addAsyncOptionsToSinkBuilder | E-18 (line 91-99) | ○ |
| C-119 | DeliveryGuarantee.toString | E-19 (line 72-74) | ○ |
| C-120 | DeliveryGuarantee.getDescription | E-19 (line 67-69) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-116, C-117**: AsyncDynamicTableSinkは抽象クラスであり、具象実装のテストには個別のサブクラスが必要
  - 候補：具象実装クラスの特定 / テストダブルの作成 / 統合テストでの検証

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 0（低リスク）**: 大部分のテストケースはソースコードから直接導出可能
- **リスクレベル 1（中リスク）**: 抽象クラス関連（C-116, C-117）は実装依存の部分あり

## 6) レビュアーチェックリスト（最小）
- [ ] SourceReaderBase関連のテストケース（C-01 - C-11）が主要なメソッドをカバーしているか
- [ ] AsyncSinkWriter関連のテストケース（C-12 - C-25）がバッチ処理・リトライ・タイムアウトを網羅しているか
- [ ] HybridSource関連のテストケース（C-26 - C-67）がソース切り替えロジックをカバーしているか
- [ ] スケーリング戦略（C-68 - C-79）の境界値テストが適切か
- [ ] 抽象クラスAsyncDynamicTableSink（C-116, C-117）のテスト方針が妥当か
- [ ] チェックポイント関連のテストケース（C-06, C-17, C-64, C-105）が障害復旧シナリオを考慮しているか
