---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 75
  claims_with_evidence: 75
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-connectors_flink-connector-datagen 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：75 / 75、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコード根拠あり
  2. **統合テストとの整合性確認推奨**：E2Eテストとの重複確認
  3. **外部依存の確認**：RateLimiter、NumberSequenceSourceとの連携テスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-connectors/flink-connector-datagen/src/main/java/org/apache/flink/connector/datagen/source/DataGeneratorSource.java`
- E-02: `flink-connectors/flink-connector-datagen/src/main/java/org/apache/flink/connector/datagen/source/GeneratingIteratorSourceReader.java`
- E-03: `flink-connectors/flink-connector-datagen/src/main/java/org/apache/flink/connector/datagen/source/GeneratorSourceReaderFactory.java`
- E-04: `flink-connectors/flink-connector-datagen/src/main/java/org/apache/flink/connector/datagen/source/GeneratorFunction.java`
- E-05: `flink-connectors/flink-connector-datagen/src/main/java/org/apache/flink/connector/datagen/source/DoubleEmittingSourceReaderWithCheckpointsInBetween.java`
- E-06: `flink-connectors/flink-connector-datagen/src/main/java/org/apache/flink/connector/datagen/functions/IndexLookupGeneratorFunction.java`
- E-07: `flink-connectors/flink-connector-datagen/src/main/java/org/apache/flink/connector/datagen/functions/FromElementsGeneratorFunction.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### DataGeneratorSource (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3引数コンストラクタで正常にインスタンス生成 | E-01 L116-121 | ○ |
| C-02 | generatorFunctionがnullで例外スロー | E-01 L151 checkNotNull | ○ |
| C-03 | typeInfoがnullで例外スロー | E-01 L152 checkNotNull | ○ |
| C-04 | 4引数コンストラクタ（RateLimiter付き）で正常生成 | E-01 L131-143 | ○ |
| C-05 | rateLimiterStrategyがnullで例外スロー | E-01 L137 GeneratorSourceReaderFactory経由 | ○ |
| C-06 | count=0でnoop source生成 | E-01 L153 コメント参照 | ○ |
| C-07 | count=1でto=0のnumberSource生成 | E-01 L153 | ○ |
| C-08 | count=Long.MAX_VALUEで動作 | E-01 L153 | ○ |
| C-09 | getBoundednessがBOUNDED返却 | E-01 L186-188 | ○ |
| C-10 | getProducedTypeがtypeInfo返却 | E-01 L181-183 | ○ |
| C-11 | setOutputTypeでtypeInfo更新 | E-01 L163-169 | ○ |
| C-12 | generatorFunctionがOutputTypeConfigurableなら伝播 | E-01 L165-168 | ○ |
| C-13 | createReaderでSourceReader生成 | E-01 L191-194 | ○ |
| C-14 | createEnumeratorでSplitEnumerator生成 | E-01 L204-207 | ○ |
| C-15 | restoreEnumeratorでチェックポイント復元 | E-01 L197-201 | ○ |
| C-16 | getSplitSerializerがシリアライザ返却 | E-01 L210-212 | ○ |
| C-17 | getEnumeratorCheckpointSerializerが返却 | E-01 L215-218 | ○ |
| C-18 | getGeneratorFunctionが返却 | E-01 L172-174 | ○ |

### GeneratingIteratorSourceReader (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | コンストラクタで正常生成 | E-02 L43-47 | ○ |
| C-20 | generatorFunctionがnullで例外 | E-02 L46 checkNotNull | ○ |
| C-21 | convertで値変換 | E-02 L52-62 | ○ |
| C-22 | convertで例外時FlinkRuntimeExceptionラップ | E-02 L55-61 | ○ |
| C-23 | startでgeneratorFunction.open呼出 | E-02 L65-71 | ○ |
| C-24 | open例外時FlinkRuntimeExceptionラップ | E-02 L68-70 | ○ |
| C-25 | closeでgeneratorFunction.closeとsuper.close呼出 | E-02 L74-77 | ○ |

### GeneratorSourceReaderFactory (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | コンストラクタで正常生成 | E-03 L51-56 | ○ |
| C-27 | generatorFunctionがnullで例外 | E-03 L54 checkNotNull | ○ |
| C-28 | rateLimiterStrategyがnullで例外 | E-03 L55 checkNotNull | ○ |
| C-29 | createReaderでRateLimitedSourceReader返却 | E-03 L59-66 | ○ |
| C-30 | currentParallelism使用してRateLimiter作成 | E-03 L61-62 | ○ |

### GeneratorFunction (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | openのデフォルト実装で例外なし | E-04 L49 | ○ |
| C-32 | closeのデフォルト実装で例外なし | E-04 L52 | ○ |
| C-33 | mapで値変換（抽象メソッド） | E-04 L54 | ○ |

### DoubleEmittingSourceReaderWithCheckpointsInBetween (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | 3引数コンストラクタで正常生成 | E-05 L61-68 | ○ |
| C-35 | 2引数コンストラクタで正常生成 | E-05 L70-74 | ○ |
| C-36 | generatorFunctionがnullで例外 | E-05 L66, L73 checkNotNull | ○ |
| C-37 | startでgeneratorFunction.open呼出 | E-05 L79-85 | ○ |
| C-38 | open例外時FlinkRuntimeExceptionラップ | E-05 L82-84 | ○ |
| C-39 | pollNextで要素出力とNOTHING_AVAILABLE返却 | E-05 L88-118 | ○ |
| C-40 | done=true, allowedToExit=nullでEND_OF_INPUT | E-05 L90-97 | ○ |
| C-41 | done=true, allowedToExit=trueでEND_OF_INPUT | E-05 L91-93 | ○ |
| C-42 | done=true, allowedToExit=falseでNOTHING_AVAILABLE | E-05 L93-94 | ○ |
| C-43 | currentSplit=nullでtryMoveToNextSplit | E-05 L100-110 | ○ |
| C-44 | 2回目出力後にdone=true | E-05 L111-114 | ○ |
| C-45 | notifyCheckpointCompleteでsnapshotsCompletedインクリメント | E-05 L133-134 | ○ |
| C-46 | snapshotsToWaitFor以上でavailability完了 | E-05 L135-137 | ○ |
| C-47 | allowedToExit=trueでavailability完了 | E-05 L139-143 | ○ |
| C-48 | convertで値変換 | E-05 L147-157 | ○ |
| C-49 | convert例外時FlinkRuntimeExceptionラップ | E-05 L150-156 | ○ |

### IndexLookupGeneratorFunction (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | 2引数コンストラクタで正常生成 | E-06 L74-76 | ○ |
| C-51 | 3引数コンストラクタで正常生成 | E-06 L78-84 | ○ |
| C-52 | elementsにnullでIllegalArgumentException | E-06 L115-117 checkIterable | ○ |
| C-53 | 型不一致でIllegalArgumentException | E-06 L119-124 checkIterable | ○ |
| C-54 | 空コレクションでインスタンス生成 | E-06 L112-125 | ○ |
| C-55 | openでlookupMap構築 | E-06 L93-98 | ○ |
| C-56 | mapでインデックスルックアップ | E-06 L101-103 | ○ |
| C-57 | 複数要素で各インデックス正しく返却 | E-06 L101-103, L163-167 | ○ |
| C-58 | 存在しないインデックスでnull返却 | E-06 L102 HashMap.get動作 | ○ |
| C-59 | 負のインデックスでnull返却 | E-06 L102 HashMap.get動作 | ○ |
| C-60 | getSerializerでシリアライザ返却 | E-06 L87-89 | ○ |

### FromElementsGeneratorFunction (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | 可変長引数コンストラクタで正常生成 | E-07 L77-79 | ○ |
| C-62 | Iterableコンストラクタで正常生成 | E-07 L81-88 | ○ |
| C-63 | elementsにnullでIllegalArgumentException | E-07 L189-191 checkIterable | ○ |
| C-64 | 型不一致でIllegalArgumentException | E-07 L193-198 checkIterable | ○ |
| C-65 | openでDataInputView初期化 | E-07 L113-116 | ○ |
| C-66 | mapで順番に要素返却 | E-07 L119-127 | ○ |
| C-67 | リカバリ時にスキップして正しい位置から読取 | E-07 L121-124 | ○ |
| C-68 | 要素数超過でNoSuchElementException | E-07 L133-136 | ○ |
| C-69 | setOutputTypeで再シリアライズ | E-07 L150-166 | ○ |
| C-70 | 同じシリアライザなら何もしない | E-07 L157-159 | ○ |
| C-71 | elements=nullでIllegalStateException | E-07 L151-153 | ○ |
| C-72 | checkIterableで全要素有効なら正常完了 | E-07 L188-200 | ○ |
| C-73 | checkIterableでnull要素で例外 | E-07 L189-191 | ○ |
| C-74 | checkIterableで型不一致で例外 | E-07 L193-198 | ○ |
| C-75 | getSerializerでシリアライザ返却 | E-07 L91-94 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目なし
- 追加で確認推奨の情報：
  - 既存の単体テスト（TestDataGenerators.java）との整合性確認
  - flink-connector-baseモジュールとの依存関係確認
  - RateLimiterStrategyの各実装（perSecond, noOp等）との組み合わせテスト

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードから直接導出されている
- 注意点：
  - チェックポイント関連のテスト（C-15, C-45, C-46）は結合テストで補完推奨
  - シリアライズ/デシリアライズのエッジケース（大量データ、特殊文字等）は追加検討

## 6) レビュアーチェックリスト（最小）
- [ ] DataGeneratorSourceのコンストラクタパラメータ検証が十分か
- [ ] GeneratorFunctionインターフェースのライフサイクル（open/map/close）が網羅されているか
- [ ] DoubleEmittingSourceReaderのチェックポイント連携テストが妥当か
- [ ] IndexLookupGeneratorFunctionとFromElementsGeneratorFunctionの境界値テストが適切か
- [ ] 例外ハンドリングのテストケースが十分か（FlinkRuntimeException、IllegalArgumentException等）
- [ ] シリアライズ関連のエラーケース（EOFException、デシリアライズ失敗）が考慮されているか
