---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 131
  claims_with_evidence: 131
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-connectors_flink-connector-files 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：131 / 131、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全ての主張にソースコード上の根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/sink/FileSink.java`
- E-02: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/sink/writer/FileWriter.java`
- E-03: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/sink/writer/FileWriterBucket.java`
- E-04: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/sink/committer/FileCommitter.java`
- E-05: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/sink/FileSinkCommittable.java`
- E-06: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/sink/compactor/FileCompactStrategy.java`
- E-07: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/sink/compactor/operator/CompactCoordinator.java`
- E-08: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/src/FileSource.java`
- E-09: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/src/FileSourceSplit.java`
- E-10: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/src/assigners/LocalityAwareSplitAssigner.java`
- E-11: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/table/FileSystemTableSource.java`
- E-12: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/table/BinPacking.java`
- E-13: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/table/PartitionWriter.java`
- E-14: `flink-connectors/flink-connector-files/src/main/java/org/apache/flink/connector/file/src/impl/FileSourceReader.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### FileSink関連（UT-FCF-001 〜 UT-FCF-017）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FileSink.forRowFormat - 行フォーマットでFileSinkが作成される | E-01 (L203-206) | ○ |
| C-02 | FileSink.forBulkFormat - バルクフォーマットでFileSinkが作成される | E-01 (L208-212) | ○ |
| C-03 | FileSink.createWriter - Writerが作成される | E-01 (L148-151) | ○ |
| C-04 | FileSink.restoreWriter - 状態からWriterが復元される | E-01 (L153-160) | ○ |
| C-05 | FileSink.restoreWriter - 空の復元状態での処理 | E-01 (L153-160) | ○ |
| C-06 | FileSink.getWriterStateSerializer - シリアライザ取得 | E-01 (L162-172) | ○ |
| C-07 | FileSink.createCommitter - Committer作成 | E-01 (L174-178) | ○ |
| C-08 | FileSink.getCommittableSerializer - シリアライザ取得 | E-01 (L180-190) | ○ |
| C-09 | FileSink.getCompatibleWriterStateNames - 互換性名取得 | E-01 (L197-201) | ○ |
| C-10 | RowFormatBuilder.withBucketCheckInterval - 間隔設定 | E-01 (L386-389) | ○ |
| C-11 | RowFormatBuilder.withBucketAssigner - Assigner設定 | E-01 (L391-394) | ○ |
| C-12 | RowFormatBuilder.withBucketAssigner - null検証 | E-01 (L392) checkNotNull | ○ |
| C-13 | RowFormatBuilder.withRollingPolicy - Policy設定 | E-01 (L396-399) | ○ |
| C-14 | RowFormatBuilder.enableCompact - コンパクション有効化 | E-01 (L406-410) | ○ |
| C-15 | RowFormatBuilder.disableCompact - コンパクション無効化 | E-01 (L412-415) | ○ |
| C-16 | RowFormatBuilder.build - FileSinkビルド | E-01 (L417-420) | ○ |
| C-17 | BulkFormatBuilder.disableLocalWriting - ローカル書き込み無効化 | E-01 (L583-586) | ○ |

### FileWriter関連（UT-FCF-018 〜 UT-FCF-031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | FileWriter コンストラクタ - 初期化処理 | E-02 (L109-138) | ○ |
| C-19 | FileWriter コンストラクタ - bucketCheckInterval境界値 | E-02 (L134-137) checkArgument | ○ |
| C-20 | FileWriter.initializeState - 状態復元 | E-02 (L158-176) | ○ |
| C-21 | FileWriter.initializeState - null検証 | E-02 (L159) checkNotNull | ○ |
| C-22 | FileWriter.initializeState - 空コレクション | E-02 (L161) for loop | ○ |
| C-23 | FileWriter.write - 書き込み処理 | E-02 (L188-200) | ○ |
| C-24 | FileWriter.write - バケット自動作成 | E-02 (L197, L240-250) | ○ |
| C-25 | FileWriter.flush - フラッシュ処理 | E-02 (L202-205) | ○ |
| C-26 | FileWriter.prepareCommit - コミット準備 | E-02 (L207-226) | ○ |
| C-27 | FileWriter.prepareCommit - 空データ | E-02 (L209) | ○ |
| C-28 | FileWriter.snapshotState - 状態スナップショット | E-02 (L228-238) | ○ |
| C-29 | FileWriter.snapshotState - 未初期化検証 | E-02 (L230) checkState | ○ |
| C-30 | FileWriter.close - リソース解放 | E-02 (L252-257) | ○ |
| C-31 | FileWriter.onProcessingTime - タイマー処理 | E-02 (L266-273) | ○ |

### FileWriterBucket関連（UT-FCF-032 〜 UT-FCF-047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | FileWriterBucket.getNew - 新規バケット作成 | E-03 (L322-330) | ○ |
| C-33 | FileWriterBucket.restore - 状態復元 | E-03 (L342-349) | ○ |
| C-34 | FileWriterBucket.getBucketId - getter | E-03 (L152-154) | ○ |
| C-35 | FileWriterBucket.getBucketPath - getter | E-03 (L156-158) | ○ |
| C-36 | FileWriterBucket.isActive - 進行中ファイルあり | E-03 (L164-166) | ○ |
| C-37 | FileWriterBucket.isActive - ペンディングファイルあり | E-03 (L164-166) | ○ |
| C-38 | FileWriterBucket.isActive - ファイルなし | E-03 (L164-166) | ○ |
| C-39 | FileWriterBucket.merge - バケットマージ | E-03 (L168-178) | ○ |
| C-40 | FileWriterBucket.merge - 異なるパス検証 | E-03 (L170) checkState | ○ |
| C-41 | FileWriterBucket.write - 書き込み処理 | E-03 (L180-192) | ○ |
| C-42 | FileWriterBucket.write - ローリング処理 | E-03 (L181) shouldRollOnEvent | ○ |
| C-43 | FileWriterBucket.prepareCommit - コミット準備 | E-03 (L194-215) | ○ |
| C-44 | FileWriterBucket.prepareCommit - endOfInput | E-03 (L195-202) | ○ |
| C-45 | FileWriterBucket.snapshotState - 状態スナップショット | E-03 (L217-229) | ○ |
| C-46 | FileWriterBucket.onProcessingTime - タイマー処理 | E-03 (L231-247) | ○ |
| C-47 | FileWriterBucket.disposePartFile - リソース解放 | E-03 (L286-290) | ○ |

### FileCommitter関連（UT-FCF-048 〜 UT-FCF-054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | FileCommitter コンストラクタ - 初期化 | E-04 (L51-53) | ○ |
| C-49 | FileCommitter コンストラクタ - null検証 | E-04 (L52) checkNotNull | ○ |
| C-50 | FileCommitter.commit - ペンディングファイルコミット | E-04 (L60-63) | ○ |
| C-51 | FileCommitter.commit - 進行中ファイルクリーンアップ | E-04 (L65-68) | ○ |
| C-52 | FileCommitter.commit - コンパクト済みファイル削除 | E-04 (L70-83) | ○ |
| C-53 | FileCommitter.commit - 空リクエスト | E-04 (L58) for loop | ○ |
| C-54 | FileCommitter.close - クローズ処理 | E-04 (L87-90) | ○ |

### FileSinkCommittable関連（UT-FCF-055 〜 UT-FCF-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | FileSinkCommittable コンストラクタ(ペンディング) | E-05 (L47-53) | ○ |
| C-56 | FileSinkCommittable コンストラクタ(進行中クリーンアップ) | E-05 (L55-62) | ○ |
| C-57 | FileSinkCommittable コンストラクタ(コンパクト済み) | E-05 (L64-69) | ○ |
| C-58 | FileSinkCommittable.equals - 同一内容 | E-05 (L113-126) | ○ |
| C-59 | FileSinkCommittable.equals - 異なる内容 | E-05 (L113-126) | ○ |
| C-60 | FileSinkCommittable.hashCode | E-05 (L128-131) | ○ |

### FileCompactStrategy関連（UT-FCF-061 〜 UT-FCF-067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | Builder.enableCompactionOnCheckpoint - 有効化 | E-06 (L74-81) | ○ |
| C-62 | Builder.enableCompactionOnCheckpoint - 境界値 | E-06 (L76-78) checkArgument | ○ |
| C-63 | Builder.setSizeThreshold - 設定 | E-06 (L87-90) | ○ |
| C-64 | Builder.setNumCompactThreads - 設定 | E-06 (L93-97) | ○ |
| C-65 | Builder.setNumCompactThreads - 境界値 | E-06 (L94) checkArgument | ○ |
| C-66 | Builder.build - ビルド | E-06 (L99-103) | ○ |
| C-67 | Builder.build - バリデーション | E-06 (L105-110) validate | ○ |

### CompactCoordinator関連（UT-FCF-068 〜 UT-FCF-077）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | CompactCoordinator.processElement - 要素処理 | E-07 (L90-103) | ○ |
| C-69 | CompactCoordinator.processElement - 閾値到達 | E-07 (L97-99) | ○ |
| C-70 | CompactCoordinator.endInput - 入力終了 | E-07 (L146-154) | ○ |
| C-71 | CompactCoordinator.prepareSnapshotPreBarrier - チェックポイント | E-07 (L156-170) | ○ |
| C-72 | CompactCoordinator.snapshotState - 状態スナップショット | E-07 (L172-186) | ○ |
| C-73 | CompactCoordinator.initializeState - 状態復元 | E-07 (L188-207) | ○ |
| C-74 | CompactTrigger.onElement - CONTINUE | E-07 (L227-254) | ○ |
| C-75 | CompactTrigger.onElement - FIRE_AND_PURGE | E-07 (L251-253) | ○ |
| C-76 | CompactTrigger.onElement - PASS_THROUGH | E-07 (L229-244) | ○ |
| C-77 | CompactTrigger.onCheckpoint - チェックポイントトリガー | E-07 (L256-266) | ○ |

### FileSource関連（UT-FCF-078 〜 UT-FCF-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | FileSource.forRecordStreamFormat - StreamFormat作成 | E-08 (L181-184) | ○ |
| C-79 | FileSource.forBulkFileFormat - BulkFormat作成 | E-08 (L192-199) | ○ |
| C-80 | FileSource.forBulkFileFormat - nullフォーマット | E-08 (L194) checkNotNull | ○ |
| C-81 | FileSource.forBulkFileFormat - 空パス配列 | E-08 (L196) checkArgument | ○ |
| C-82 | FileSource.getSplitSerializer - シリアライザ取得 | E-08 (L142-145) | ○ |
| C-83 | FileSource.inferParallelism - 並列度推論 | E-08 (L147-163) | ○ |
| C-84 | FileSourceBuilder.monitorContinuously - 継続監視設定 | E-08 (L68-71) Javadoc参照 | ○ |
| C-85 | FileSourceBuilder.build - ビルド | E-08 (L228-237) | ○ |

### FileSourceSplit関連（UT-FCF-086 〜 UT-FCF-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | FileSourceSplit コンストラクタ - 作成 | E-09 (L104-112) | ○ |
| C-87 | FileSourceSplit コンストラクタ - 負のオフセット | E-09 (L182) checkArgument | ○ |
| C-88 | FileSourceSplit コンストラクタ - 負の長さ | E-09 (L183) checkArgument | ○ |
| C-89 | FileSourceSplit.splitId - getter | E-09 (L199-202) | ○ |
| C-90 | FileSourceSplit.path - getter | E-09 (L204-207) | ○ |
| C-91 | FileSourceSplit.offset - getter | E-09 (L209-216) | ○ |
| C-92 | FileSourceSplit.length - getter | E-09 (L218-220) | ○ |
| C-93 | FileSourceSplit.hostnames - getter | E-09 (L237-240) | ○ |
| C-94 | FileSourceSplit.getReaderPosition - 位置取得 | E-09 (L247-249) | ○ |
| C-95 | FileSourceSplit.getReaderPosition - 位置未設定 | E-09 (L247-249) | ○ |
| C-96 | FileSourceSplit.updateWithCheckpointedPosition - 位置更新 | E-09 (L260-263) | ○ |

### LocalityAwareSplitAssigner関連（UT-FCF-097 〜 UT-FCF-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | LocalityAwareSplitAssigner コンストラクタ - 初期化 | E-10 (L72-82) | ○ |
| C-98 | LocalityAwareSplitAssigner.getNext - ローカル優先 | E-10 (L100-116) | ○ |
| C-99 | LocalityAwareSplitAssigner.getNext - リモート割り当て | E-10 (L118-124) | ○ |
| C-100 | LocalityAwareSplitAssigner.getNext - nullホスト | E-10 (L89-95) | ○ |
| C-101 | LocalityAwareSplitAssigner.getNext - 全割り当て済み | E-10 (L141-152) | ○ |
| C-102 | LocalityAwareSplitAssigner.addSplits - スプリット追加 | E-10 (L127-133) | ○ |
| C-103 | LocalityAwareSplitAssigner.remainingSplits - 残存取得 | E-10 (L135-138) | ○ |
| C-104 | LocalityAwareSplitAssigner.normalizeHostName - 正規化 | E-10 (L164-168) | ○ |
| C-105 | LocalityAwareSplitAssigner.normalizeHostName - null処理 | E-10 (L165-166) | ○ |

### FileSystemTableSource関連（UT-FCF-106 〜 UT-FCF-121）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | FileSystemTableSource.getScanRuntimeProvider - bulkReaderFormat | E-11 (L159-192) | ○ |
| C-107 | FileSystemTableSource.getScanRuntimeProvider - deserializationFormat | E-11 (L193-223) | ○ |
| C-108 | FileSystemTableSource.getScanRuntimeProvider - パーティションなし | E-11 (L290-300) | ○ |
| C-109 | FileSystemTableSource.getScanRuntimeProvider - 空パーティション | E-11 (L130-132) | ○ |
| C-110 | FileSystemTableSource.getChangelogMode | E-11 (L302-311) | ○ |
| C-111 | FileSystemTableSource.applyFilters | E-11 (L313-317) | ○ |
| C-112 | FileSystemTableSource.applyLimit | E-11 (L319-322) | ○ |
| C-113 | FileSystemTableSource.listPartitions | E-11 (L324-348) | ○ |
| C-114 | FileSystemTableSource.applyPartitions | E-11 (L350-353) | ○ |
| C-115 | FileSystemTableSource.supportsNestedProjection | E-11 (L355-358) | ○ |
| C-116 | FileSystemTableSource.reportStatistics | E-11 (L360-408) | ○ |
| C-117 | FileSystemTableSource.reportStatistics - NONE | E-11 (L369-371) | ○ |
| C-118 | FileSystemTableSource.copy | E-11 (L410-428) | ○ |
| C-119 | FileSystemTableSource.applyProjection | E-11 (L462-466) | ○ |
| C-120 | FileSystemTableSource.applyReadableMetadata | E-11 (L468-472) | ○ |
| C-121 | FileSystemTableSource.listReadableMetadata | E-11 (L478-482) | ○ |

### BinPacking関連（UT-FCF-122 〜 UT-FCF-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-122 | BinPacking.pack - ビンパッキング | E-12 (L34-59) | ○ |
| C-123 | BinPacking.pack - 空入力 | E-12 (L39) for loop | ○ |
| C-124 | BinPacking.pack - 単一アイテム | E-12 (L39-54) | ○ |
| C-125 | BinPacking.pack - 大きなアイテム | E-12 (L46-48) | ○ |

### PartitionWriter関連（UT-FCF-126）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | PartitionWriter.Context.createNewOutputFormat | E-13 (L57-64) | ○ |

### FileSourceReader関連（UT-FCF-127 〜 UT-FCF-131）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-127 | FileSourceReader.start - スプリットリクエスト送信 | E-14 (L50-56) | ○ |
| C-128 | FileSourceReader.start - スプリット復元時 | E-14 (L53) if条件 | ○ |
| C-129 | FileSourceReader.onSplitFinished - スプリット完了 | E-14 (L58-61) | ○ |
| C-130 | FileSourceReader.initializedState - 状態初期化 | E-14 (L63-66) | ○ |
| C-131 | FileSourceReader.toSplitType - スプリット復元 | E-14 (L68-71) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：全ての主張にソースコード上の根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：全てのテストケースがソースコードの実装に基づいて生成されている
- 注意点：
  - 内部クラス（BucketerContext等）のテストケースは含めていないが、これらはprivateクラスであり直接テストの対象外
  - モックやスタブを使用した統合テストが必要な箇所（例：FileSystem操作）は実際のテスト実装時に検討が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（FileSink, FileWriter, FileCommitter, FileSource関連）の入力値・期待結果が適切か
- [ ] 境界値テストケース（空コレクション、null、負の値等）が網羅されているか
- [ ] 異常系テストケース（例外スロー）のカバレッジが十分か
- [ ] コンパクション関連のテストケースが要件を満たしているか
- [ ] Table API関連のテストケースがフィルタ・プロジェクション・パーティションプッシュダウンを網羅しているか
