---
generated_at: 2026-02-02 18:30:00
metrics:
  claims_total: 129
  claims_with_evidence: 129
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-connectors_flink-file-sink-common.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：129 / 129、根拠なし：0
- 優先レビュー（高）
  1. なし：全てのテストケースにソースコードからの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/OutputFileConfig.java`
- E-02: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/WriterProperties.java`
- E-03: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/AbstractPartFileWriter.java`
- E-04: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/bucketassigners/BasePathBucketAssigner.java`
- E-05: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/bucketassigners/DateTimeBucketAssigner.java`
- E-06: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/bucketassigners/SimpleVersionedStringSerializer.java`
- E-07: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/rollingpolicies/DefaultRollingPolicy.java`
- E-08: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/rollingpolicies/CheckpointRollingPolicy.java`
- E-09: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/rollingpolicies/OnCheckpointRollingPolicy.java`
- E-10: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/RowWisePartWriter.java`
- E-11: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/BulkPartWriter.java`
- E-12: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/RowWiseBucketWriter.java`
- E-13: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/BulkBucketWriter.java`
- E-14: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/OutputStreamBasedPartFileWriter.java`
- E-15: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/BucketAssigner.java`（インターフェース）
- E-16: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/RollingPolicy.java`（インターフェース）
- E-17: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/BucketWriter.java`（インターフェース）
- E-18: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/InProgressFileWriter.java`（インターフェース）
- E-19: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/PartFileInfo.java`（インターフェース）
- E-20: `flink-connectors/flink-file-sink-common/src/main/java/org/apache/flink/streaming/api/functions/sink/filesystem/CompactingFileWriter.java`（インターフェース）

## 3) Claims と根拠の対応（レビューの主戦場）

### OutputFileConfig関連（C-01〜C-10）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OutputFileConfigコンストラクタで有効なprefix/suffixでインスタンス作成 | E-01 (41-44行目) | ○ |
| C-02 | partPrefixがnullの場合にNullPointerException | E-01 (42行目: Preconditions.checkNotNull) | ○ |
| C-03 | partSuffixがnullの場合にNullPointerException | E-01 (43行目: Preconditions.checkNotNull) | ○ |
| C-04 | getPartPrefixで設定されたprefixが取得可能 | E-01 (47-49行目) | ○ |
| C-05 | getPartSuffixで設定されたsuffixが取得可能 | E-01 (52-54行目) | ○ |
| C-06 | builderでOutputFileConfigBuilderが取得可能 | E-01 (56-58行目) | ○ |
| C-07 | buildでデフォルト値のOutputFileConfig作成 | E-01 (64-66行目: DEFAULT_PART_PREFIX/SUFFIX) | ○ |
| C-08 | withPartPrefixでカスタムprefix設定可能 | E-01 (77-80行目) | ○ |
| C-09 | withPartSuffixでカスタムsuffix設定可能 | E-01 (82-85行目) | ○ |
| C-10 | 空文字のprefix/suffixでビルド可能 | E-01 (コンストラクタでnullチェックのみ) | ○ |

### WriterProperties関連（C-11〜C-17）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | 有効なシリアライザでインスタンス作成 | E-02 (38-48行目) | ○ |
| C-12 | inProgressFileRecoverableSerializerがnullでNPE | E-02 (44-45行目: checkNotNull) | ○ |
| C-13 | pendingFileRecoverableSerializerがnullでNPE | E-02 (46行目: checkNotNull) | ○ |
| C-14 | supportsResume=trueでtrue返却 | E-02 (54-56行目) | ○ |
| C-15 | supportsResume=falseでfalse返却 | E-02 (54-56行目) | ○ |
| C-16 | getPendingFileRecoverableSerializerでシリアライザ取得 | E-02 (61-63行目) | ○ |
| C-17 | getInProgressFileRecoverableSerializerでシリアライザ取得 | E-02 (69-72行目) | ○ |

### AbstractPartFileWriter関連（C-18〜C-22）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | 有効なbucketIDと作成時刻でインスタンス作成 | E-03 (36-40行目) | ○ |
| C-19 | getBucketIdで設定されたbucketID取得 | E-03 (43-45行目) | ○ |
| C-20 | getCreationTimeで作成時刻取得 | E-03 (48-50行目) | ○ |
| C-21 | 初期状態でlastUpdateTime=creationTime | E-03 (39行目: lastUpdateTime = createTime) | ○ |
| C-22 | markWriteでlastUpdateTime更新 | E-03 (57-59行目) | ○ |

### BasePathBucketAssigner関連（C-23〜C-26）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | getBucketIdで空文字返却 | E-04 (35-37行目: return "") | ○ |
| C-24 | null要素でも空文字返却 | E-04 (35-37行目: elementは使用されない) | ○ |
| C-25 | getSerializerでSimpleVersionedStringSerializer返却 | E-04 (40-43行目) | ○ |
| C-26 | toStringで"BasePathBucketAssigner"返却 | E-04 (46-48行目) | ○ |

### DateTimeBucketAssigner関連（C-27〜C-37）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 | デフォルトコンストラクタで"yyyy-MM-dd--HH"フォーマット | E-05 (55, 63-66行目) | ○ |
| C-28 | カスタムフォーマットでインスタンス作成 | E-05 (74-76行目) | ○ |
| C-29 | カスタムタイムゾーンでインスタンス作成 | E-05 (84-86行目) | ○ |
| C-30 | フォーマット+タイムゾーンでインスタンス作成 | E-05 (96-99行目) | ○ |
| C-31 | formatString=nullでNPE | E-05 (97行目: Preconditions.checkNotNull) | ○ |
| C-32 | zoneId=nullでNPE | E-05 (98行目: Preconditions.checkNotNull) | ○ |
| C-33 | 処理時刻に基づくバケットID返却 | E-05 (102-107行目) | ○ |
| C-34 | タイムゾーン変換の正確性 | E-05 (104行目: withZone(zoneId)) | ○ |
| C-35 | 日付境界での正しい動作 | E-05 (DateTimeFormatterの標準動作) | ○ |
| C-36 | getSerializerでSimpleVersionedStringSerializer返却 | E-05 (110-112行目) | ○ |
| C-37 | toStringでフォーマットとタイムゾーン含む文字列 | E-05 (115-123行目) | ○ |

### SimpleVersionedStringSerializer関連（C-38〜C-44）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | getVersionでバージョン1返却 | E-06 (40-42行目) | ○ |
| C-39 | serializeで文字列を正しくシリアライズ | E-06 (45-53行目) | ○ |
| C-40 | 空文字を正しくシリアライズ | E-06 (46行目: getBytes) | ○ |
| C-41 | マルチバイト文字を正しくシリアライズ | E-06 (46行目: StandardCharsets.UTF_8) | ○ |
| C-42 | deserializeでデシリアライズ成功 | E-06 (56-63, 65-69行目) | ○ |
| C-43 | 不正バージョンでIOException | E-06 (61行目) | ○ |
| C-44 | シリアライズ・デシリアライズのラウンドトリップ | E-06 (serialize/deserialize実装) | ○ |

### DefaultRollingPolicy関連（C-45〜C-64）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | builderでPolicyBuilder取得 | E-07 (120-123行目) | ○ |
| C-46 | デフォルト値でポリシー作成 | E-07 (48-52行目: デフォルト定数) | ○ |
| C-47 | withMaxPartSizeでカスタムサイズ設定 | E-07 (156-159行目) | ○ |
| C-48 | MemorySize=nullでNPE | E-07 (157行目: checkNotNull) | ○ |
| C-49 | withRolloverIntervalでカスタム間隔設定 | E-07 (225-228行目) | ○ |
| C-50 | Duration=nullでNPE | E-07 (226行目: checkNotNull) | ○ |
| C-51 | withInactivityIntervalでカスタム間隔設定 | E-07 (196-200行目) | ○ |
| C-52 | inactivity Duration=nullでNPE | E-07 (197-198行目: checkNotNull) | ○ |
| C-53 | shouldRollOnCheckpoint:サイズ以下でfalse | E-07 (72-74行目: > partSize) | ○ |
| C-54 | shouldRollOnCheckpoint:サイズ超過でtrue | E-07 (72-74行目) | ○ |
| C-55 | shouldRollOnCheckpoint:境界値でfalse | E-07 (73行目: > partSize) | ○ |
| C-56 | shouldRollOnEvent:サイズ以下でfalse | E-07 (77-80行目) | ○ |
| C-57 | shouldRollOnEvent:サイズ超過でtrue | E-07 (77-80行目) | ○ |
| C-58 | shouldRollOnProcessingTime:条件内でfalse | E-07 (83-87行目) | ○ |
| C-59 | shouldRollOnProcessingTime:ロールオーバー超過でtrue | E-07 (85行目) | ○ |
| C-60 | shouldRollOnProcessingTime:非アクティブ超過でtrue | E-07 (86行目) | ○ |
| C-61 | shouldRollOnProcessingTime:境界値でfalse | E-07 (85行目: >= rolloverInterval) | ○ |
| C-62 | getMaxPartSizeでpartSize取得 | E-07 (94-96行目) | ○ |
| C-63 | getRolloverIntervalでrolloverInterval取得 | E-07 (103-105行目) | ○ |
| C-64 | getInactivityIntervalでinactivityInterval取得 | E-07 (112-114行目) | ○ |

### CheckpointRollingPolicy/OnCheckpointRollingPolicy関連（C-65〜C-68）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | CheckpointRollingPolicy.shouldRollOnCheckpointで常にtrue | E-08 (30-32行目) | ○ |
| C-66 | OnCheckpointRollingPolicy.buildでインスタンス作成 | E-09 (45-47行目) | ○ |
| C-67 | shouldRollOnEventで常にfalse | E-09 (35-37行目) | ○ |
| C-68 | shouldRollOnProcessingTimeで常にfalse | E-09 (40-43行目) | ○ |

### RowWisePartWriter関連（C-69〜C-73）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | 有効パラメータでインスタンス作成 | E-10 (39-47行目) | ○ |
| C-70 | encoder=nullでNPE | E-10 (46行目: Preconditions.checkNotNull) | ○ |
| C-71 | writeで要素がエンコードされて書き込み | E-10 (50-54行目) | ○ |
| C-72 | writeでlastUpdateTime更新 | E-10 (53行目: markWrite) | ○ |
| C-73 | タイプ不一致でIllegalStateException | E-10 (51行目: ensureWriteType) | ○ |

### BulkPartWriter関連（C-74〜C-78）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | 有効パラメータでインスタンス作成 | E-11 (38-46行目) | ○ |
| C-75 | writer=nullでNPE | E-11 (45行目: Preconditions.checkNotNull) | ○ |
| C-76 | writeで要素がBulkWriterに追加 | E-11 (49-53行目) | ○ |
| C-77 | persistでUnsupportedOperationException | E-11 (56-59行目) | ○ |
| C-78 | closeForCommitでflush/finish呼び出し | E-11 (62-66行目) | ○ |

### RowWiseBucketWriter関連（C-79〜C-85）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | 有効パラメータでインスタンス作成 | E-12 (40-44行目) | ○ |
| C-80 | openNewでRowWisePartWriter作成 | E-12 (61-71行目) | ○ |
| C-81 | openNewでstream=nullでNPE | E-12 (67行目: Preconditions.checkNotNull) | ○ |
| C-82 | openNewでpath=nullでNPE | E-12 (68行目: Preconditions.checkNotNull) | ○ |
| C-83 | resumeFromでWriter再開 | E-12 (47-58行目) | ○ |
| C-84 | resumeFromでstream=nullでNPE | E-12 (54行目: Preconditions.checkNotNull) | ○ |
| C-85 | resumeFromでresumable=nullでNPE | E-12 (55行目: Preconditions.checkNotNull) | ○ |

### BulkBucketWriter関連（C-86〜C-89）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | 有効パラメータでインスタンス作成 | E-13 (42-47行目) | ○ |
| C-87 | openNewでBulkPartWriter作成 | E-13 (66-78行目) | ○ |
| C-88 | openNewでstream=nullでNPE | E-13 (73行目: Preconditions.checkNotNull) | ○ |
| C-89 | resumeFromでWriter再開 | E-13 (50-63行目) | ○ |

### OutputStreamBasedPartFileWriter関連（C-90〜C-129）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | persistでInProgressFileRecoverable返却 | E-14 (66-69行目) | ○ |
| C-91 | closeForCommitでPendingFileRecoverable返却 | E-14 (72-76行目) | ○ |
| C-92 | disposeでストリームクローズ | E-14 (79-83行目) | ○ |
| C-93 | getSizeでストリーム位置返却 | E-14 (86-88行目) | ○ |
| C-94 | asOutputStreamでストリーム返却 | E-14 (91-94行目) | ○ |
| C-95 | ensureWriteTypeで初回タイプ設定 | E-14 (96-109行目) | ○ |
| C-96 | ensureWriteTypeで同一タイプ許容 | E-14 (97-99行目) | ○ |
| C-97 | ensureWriteTypeでタイプ変更禁止 | E-14 (100-107行目) | ○ |
| C-98 | OutputStreamBasedPendingFileRecoverable作成 | E-14 (228-235行目) | ○ |
| C-99 | getPathでtargetPath返却 | E-14 (241-244行目) | ○ |
| C-100 | getSizeでfileSize返却 | E-14 (246-249行目) | ○ |
| C-101 | equals:同内容でtrue | E-14 (251-266行目) | ○ |
| C-102 | equals:異内容でfalse | E-14 (251-266行目) | ○ |
| C-103 | hashCode一貫性 | E-14 (269-271行目) | ○ |
| C-104 | OutputStreamBasedInProgressFileRecoverable作成 | E-14 (291-296行目) | ○ |
| C-105 | getPathでtargetPath返却 | E-14 (303-305行目) | ○ |
| C-106 | getSizeで常に-1返却 | E-14 (308-311行目) | ○ |
| C-107 | commitでcommitter.commit呼び出し | E-14 (344-346行目) | ○ |
| C-108 | commitAfterRecoveryで呼び出し | E-14 (349-351行目) | ○ |
| C-109 | InProgressFileRecoverableSerializer.getVersionで2 | E-14 (369-371行目) | ○ |
| C-110 | serialize成功 | E-14 (374-382行目) | ○ |
| C-111 | deserializeでV1成功 | E-14 (385-399, 423-428行目) | ○ |
| C-112 | deserializeでV2成功 | E-14 (385-399, 430-440行目) | ○ |
| C-113 | 不正バージョンでIOException | E-14 (397行目) | ○ |
| C-114 | 不正マジックナンバーでIOException | E-14 (442-449行目) | ○ |
| C-115 | PendingFileRecoverableSerializer.getVersionで2 | E-14 (468-470行目) | ○ |
| C-116 | serialize成功 | E-14 (473-480行目) | ○ |
| C-117 | deserializeでV1成功 | E-14 (483-497, 522-526行目) | ○ |
| C-118 | deserializeでV2成功 | E-14 (483-497, 528-541行目) | ○ |
| C-119 | 不正バージョンでIOException | E-14 (495行目) | ○ |
| C-120 | 不正マジックナンバーでIOException | E-14 (543-550行目) | ○ |
| C-121 | openNewInProgressFileで新規Writer作成 | E-14 (121-125行目) | ○ |
| C-122 | openNewCompactingFileでRECORD_WISE対応 | E-14 (128-133行目) | ○ |
| C-123 | openNewCompactingFileでOUTPUT_STREAM対応 | E-14 (128-133行目) | ○ |
| C-124 | resumeInProgressFileFromでWriter再開 | E-14 (136-151行目) | ○ |
| C-125 | recoverPendingFileでPending復元 | E-14 (154-173行目) | ○ |
| C-126 | recoverPendingFileでInProgress復元 | E-14 (162-167行目) | ○ |
| C-127 | 不正Recoverable型でIllegalArgumentException | E-14 (168-169行目) | ○ |
| C-128 | cleanupInProgressFileRecoverableでクリーンアップ | E-14 (176-182行目) | ○ |
| C-129 | getPropertiesでWriterProperties返却 | E-14 (185-192行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースはソースコードからの直接的な根拠を持つ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードから導出されており、根拠が明確

### 補足
- インターフェース（BucketAssigner, RollingPolicy, BucketWriter, InProgressFileWriter, PartFileInfo, CompactingFileWriter）は実装クラスを通じてテスト
- シリアライザのバージョン互換性テスト（V1/V2）は状態マイグレーションに重要

## 6) レビュアーチェックリスト（最小）
- [ ] 境界値テスト（C-10, C-35, C-40, C-55, C-61）が適切か確認
- [ ] 例外ケース（NPE, IllegalStateException, UnsupportedOperationException）の網羅性確認
- [ ] シリアライザのラウンドトリップテスト（C-44, C-110-120）の十分性確認
- [ ] ロールオーバーポリシーの時間計算（C-58-61）の境界条件確認
- [ ] タイムゾーン変換（C-34）の実装テストの十分性確認
