---
generated_at: 2026-02-02 18:30:00
metrics:
  claims_total: 182
  claims_with_evidence: 182
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: flink-connectors_flink-hadoop-compatibility

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：182 / 182、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースがソースコードを根拠としている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/hadoopcompatibility/HadoopInputs.java`
- E-02: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/hadoopcompatibility/HadoopUtils.java`
- E-03: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/hadoopcompatibility/mapred/wrapper/HadoopTupleUnwrappingIterator.java`
- E-04: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/hadoopcompatibility/mapred/wrapper/HadoopOutputCollector.java`
- E-05: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/hadoopcompatibility/mapred/HadoopReducerWrappedFunction.java`
- E-06: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/hadoopcompatibility/mapred/HadoopMapFunction.java`
- E-07: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/typeutils/WritableTypeInfo.java`
- E-08: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/typeutils/runtime/WritableSerializer.java`
- E-09: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/typeutils/runtime/WritableComparator.java`
- E-10: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapred/wrapper/HadoopDummyReporter.java`
- E-11: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapred/wrapper/HadoopDummyProgressable.java`
- E-12: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapred/wrapper/HadoopInputSplit.java`
- E-13: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapred/utils/HadoopUtils.java`
- E-14: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapred/HadoopOutputFormat.java`
- E-15: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapred/HadoopInputFormatBase.java`
- E-16: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapred/HadoopOutputFormatBase.java`
- E-17: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapred/HadoopInputFormat.java`
- E-18: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/common/HadoopOutputFormatCommonBase.java`
- E-19: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/common/HadoopInputFormatCommonBase.java`
- E-20: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapreduce/wrapper/HadoopInputSplit.java`
- E-21: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapreduce/utils/HadoopUtils.java`
- E-22: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapreduce/HadoopOutputFormat.java`
- E-23: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapreduce/HadoopInputFormatBase.java`
- E-24: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapreduce/HadoopOutputFormatBase.java`
- E-25: `flink-connectors/flink-hadoop-compatibility/src/main/java/org/apache/flink/api/java/hadoop/mapreduce/HadoopInputFormat.java`

## 3) Claims と根拠の対応（レビューの主戦場）

### HadoopInputs クラス (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | readHadoopFile(mapred)が正常に動作する | E-01 Line 50-61 | ○ |
| C-02 | nullのFileInputFormatで例外がスローされる | E-01 Line 50-61（暗黙的null参照） | ○ |
| C-03 | JobConf省略時にデフォルトが使用される | E-01 Line 69-75 | ○ |
| C-04 | readSequenceFileが正常に動作する | E-01 Line 83-90 | ○ |
| C-05 | createHadoopInput(mapred)が正常に動作する | E-01 Line 98-104 | ○ |
| C-06 | readHadoopFile(mapreduce)が正常に動作する | E-01 Line 112-126 | ○ |
| C-07 | Job省略時にデフォルトが使用される | E-01 Line 134-143 | ○ |
| C-08 | createHadoopInput(mapreduce)が正常に動作する | E-01 Line 151-159 | ○ |

### HadoopUtils クラス (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | paramsFromGenericOptionsParserが正常に動作する | E-02 Line 40-48 | ○ |
| C-10 | 空の引数配列でParameterToolが生成される | E-02 Line 40-48 | ○ |
| C-11 | 不正な形式の引数で例外がスローされる | E-02 Line 44-46 | ○ |

### HadoopTupleUnwrappingIterator クラス (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | コンストラクタが正常に動作する | E-03 Line 45-47 | ○ |
| C-13 | nullのTypeSerializerで例外がスローされる | E-03 Line 46 (checkNotNull) | ○ |
| C-14 | setメソッドが正常に動作する | E-03 Line 54-65 | ○ |
| C-15 | 空のイテレータでatFirstがfalseになる | E-03 Line 57, 63-64 | ○ |
| C-16 | hasNextがtrueを返す | E-03 Line 68-73 | ○ |
| C-17 | atFirstがtrueの場合hasNextがtrueを返す | E-03 Line 69-71 | ○ |
| C-18 | nextが正しい値を返す | E-03 Line 76-84 | ○ |
| C-19 | 最初の要素がfirstValueとして返却される | E-03 Line 77-80 | ○ |
| C-20 | getCurrentKeyが正しいキーを返す | E-03 Line 86-88 | ○ |
| C-21 | removeでUnsupportedOperationExceptionがスローされる | E-03 Line 91-93 | ○ |

### HadoopOutputCollector クラス (E-04)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | setFlinkCollectorが正常に動作する | E-04 Line 43-45 | ○ |
| C-23 | collectがキー/バリューペアを収集する | E-04 Line 55-59 | ○ |
| C-24 | nullキーが許容される | E-04 Line 56 | ○ |

### HadoopReducerWrappedFunction クラス (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Reducerのみでコンストラクタが動作する | E-05 Line 77-79 | ○ |
| C-26 | nullのReducerで例外がスローされる | E-05 Line 89-91 | ○ |
| C-27 | ReducerとJobConfでコンストラクタが動作する | E-05 Line 87-98 | ○ |
| C-28 | nullのJobConfで例外がスローされる | E-05 Line 92-94 | ○ |
| C-29 | openメソッドが正常に動作する | E-05 Line 103-114 | ○ |
| C-30 | getProducedTypeが正しい型を返す | E-05 Line 117-131 | ○ |
| C-31 | apply(keyed)がreduceを実行する | E-05 Line 157-166 | ○ |
| C-32 | apply(non-keyed)がreduceを実行する | E-05 Line 168-177 | ○ |
| C-33 | シリアライズ/デシリアライズが動作する | E-05 Line 139-154 | ○ |

### HadoopMapFunction クラス (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | Mapperのみでコンストラクタが動作する | E-06 Line 64-66 | ○ |
| C-35 | nullのMapperで例外がスローされる | E-06 Line 76-78 | ○ |
| C-36 | MapperとJobConfでコンストラクタが動作する | E-06 Line 75-85 | ○ |
| C-37 | nullのJobConfで例外がスローされる | E-06 Line 79-81 | ○ |
| C-38 | openメソッドが正常に動作する | E-06 Line 88-95 | ○ |
| C-39 | flatMapが正常に動作する | E-06 Line 98-103 | ○ |
| C-40 | getProducedTypeが正しい型を返す | E-06 Line 106-119 | ○ |
| C-41 | シリアライズ/デシリアライズが動作する | E-06 Line 127-140 | ○ |

### WritableTypeInfo クラス (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | Writableサブクラスでコンストラクタが動作する | E-07 Line 53-60 | ○ |
| C-43 | nullのクラスで例外がスローされる | E-07 Line 54 (checkNotNull) | ○ |
| C-44 | Writable.classで例外がスローされる | E-07 Line 56-59 (checkArgument) | ○ |
| C-45 | ComparableでcreatComparatorが動作する | E-07 Line 65-76 | ○ |
| C-46 | Comparableでない場合例外がスローされる | E-07 Line 70-75 | ○ |
| C-47 | isBasicTypeがfalseを返す | E-07 Line 80-82 | ○ |
| C-48 | isTupleTypeがfalseを返す | E-07 Line 85-88 | ○ |
| C-49 | getArityが1を返す | E-07 Line 91-94 | ○ |
| C-50 | getTotalFieldsが1を返す | E-07 Line 97-100 | ○ |
| C-51 | getTypeClassがクラスを返す | E-07 Line 103-106 | ○ |
| C-52 | Comparableでない場合isKeyTypeがfalse | E-07 Line 109-112 | ○ |
| C-53 | ComparableでisKeyTypeがtrue | E-07 Line 111 | ○ |
| C-54 | createSerializerがWritableSerializerを返す | E-07 Line 115-118 | ○ |
| C-55 | equalsが同じクラスでtrueを返す | E-07 Line 131-141 | ○ |
| C-56 | equalsが異なるクラスでfalseを返す | E-07 Line 131-141 | ○ |
| C-57 | hashCodeが同じクラスで同じ値を返す | E-07 Line 126-128 | ○ |
| C-58 | getWritableTypeInfoが型情報を返す | E-07 Line 151-158 | ○ |
| C-59 | getWritableTypeInfoが無効な型で例外をスローする | E-07 Line 155-157 | ○ |

### WritableSerializer クラス (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | コンストラクタが正常に動作する | E-08 Line 53-55 | ○ |
| C-61 | createInstanceがインスタンスを生成する | E-08 Line 58-64 | ○ |
| C-62 | NullWritableでシングルトンが返される | E-08 Line 60-61 | ○ |
| C-63 | copyがオブジェクトをコピーする | E-08 Line 67-71 | ○ |
| C-64 | copy(reuse)が正常に動作する | E-08 Line 74-78 | ○ |
| C-65 | getLengthが-1を返す | E-08 Line 81-83 | ○ |
| C-66 | serializeが正常に動作する | E-08 Line 86-88 | ○ |
| C-67 | deserializeが正常に動作する | E-08 Line 91-93 | ○ |
| C-68 | deserialize(reuse)が正常に動作する | E-08 Line 96-99 | ○ |
| C-69 | copy(stream)が正常に動作する | E-08 Line 102-106 | ○ |
| C-70 | isImmutableTypeがfalseを返す | E-08 Line 109-111 | ○ |
| C-71 | duplicateが新インスタンスを返す | E-08 Line 114-116 | ○ |
| C-72 | equalsが正常に動作する | E-08 Line 146-154 | ○ |
| C-73 | snapshotConfigurationがスナップショットを返す | E-08 Line 161-163 | ○ |

### WritableComparator クラス (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | コンストラクタが正常に動作する | E-09 Line 59-62 | ○ |
| C-75 | hashがhashCodeを返す | E-09 Line 65-67 | ○ |
| C-76 | setReferenceがコピーを設定する | E-09 Line 70-74 | ○ |
| C-77 | equalToReferenceがtrueを返す | E-09 Line 77-79 | ○ |
| C-78 | equalToReferenceがfalseを返す | E-09 Line 77-79 | ○ |
| C-79 | compareToReferenceが昇順で比較する | E-09 Line 82-86 | ○ |
| C-80 | compareToReferenceが降順で比較する | E-09 Line 82-86 | ○ |
| C-81 | compareが昇順で比較する | E-09 Line 89-92 | ○ |
| C-82 | compareが降順で比較する | E-09 Line 89-92 | ○ |
| C-83 | compareSerializedが正常に動作する | E-09 Line 95-105 | ○ |
| C-84 | supportsNormalizedKeyがtrueを返す | E-09 Line 108-110 | ○ |
| C-85 | supportsNormalizedKeyがfalseを返す | E-09 Line 108-110 | ○ |
| C-86 | getNormalizeKeyLenが長さを返す | E-09 Line 113-118 | ○ |
| C-87 | putNormalizedKeyが書き込む | E-09 Line 126-129 | ○ |
| C-88 | invertNormalizedKeyが昇順でfalseを返す | E-09 Line 132-134 | ○ |
| C-89 | invertNormalizedKeyが降順でtrueを返す | E-09 Line 132-134 | ○ |
| C-90 | duplicateが新インスタンスを返す | E-09 Line 137-139 | ○ |
| C-91 | supportsSerializationWithKeyNormalizationがfalse | E-09 Line 158-160 | ○ |
| C-92 | writeWithKeyNormalizationで例外がスローされる | E-09 Line 163-165 | ○ |
| C-93 | readWithKeyDenormalizationで例外がスローされる | E-09 Line 168-170 | ○ |

### HadoopDummyReporter クラス (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | progressが例外なく動作する | E-10 Line 32 | ○ |
| C-95 | setStatusが例外なく動作する | E-10 Line 35 | ○ |
| C-96 | getCounter(Enum)がnullを返す | E-10 Line 38-40 | ○ |
| C-97 | getCounter(String, String)がnullを返す | E-10 Line 43-45 | ○ |
| C-98 | incrCounter(Enum)が例外なく動作する | E-10 Line 48 | ○ |
| C-99 | incrCounter(String, String)が例外なく動作する | E-10 Line 51 | ○ |
| C-100 | getInputSplitがnullを返す | E-10 Line 54-56 | ○ |
| C-101 | getProgressが0を返す | E-10 Line 59-61 | ○ |

### HadoopDummyProgressable クラス (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | progressが例外なく動作する | E-11 Line 29 | ○ |

### HadoopInputSplit クラス (mapred) (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | コンストラクタが正常に動作する | E-12 Line 51-70 | ○ |
| C-104 | nullのInputSplitで例外がスローされる | E-12 Line 57-59 | ○ |
| C-105 | JobConf必須で例外がスローされる | E-12 Line 61-64 | ○ |
| C-106 | getHostnamesがロケーションを返す | E-12 Line 77-83 | ○ |
| C-107 | getHostnamesが例外時に空配列を返す | E-12 Line 80-82 | ○ |
| C-108 | getHadoopInputSplitが分割を返す | E-12 Line 85-87 | ○ |
| C-109 | getJobConfがJobConfを返す | E-12 Line 89-91 | ○ |
| C-110 | シリアライズ/デシリアライズが動作する | E-12 Line 97-135 | ○ |

### HadoopUtils クラス (mapred.utils) (E-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | mergeHadoopConfが設定をマージする | E-13 Line 41-53 | ○ |
| C-112 | 既存の設定が上書きされない | E-13 Line 49-51 | ○ |
| C-113 | getHadoopConfigurationがConfigurationを返す | E-13 Line 63-102 | ○ |
| C-114 | possibleHadoopConfPathsがパス配列を返す | E-13 Line 111-121 | ○ |
| C-115 | 環境変数未設定時の動作 | E-13 Line 114-120 | ○ |

### HadoopOutputFormat クラス (mapred) (E-14)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | コンストラクタが正常に動作する | E-14 Line 42-45 | ○ |
| C-117 | OutputCommitter付きコンストラクタが動作する | E-14 Line 47-53 | ○ |
| C-118 | writeRecordがレコードを書き込む | E-14 Line 56-58 | ○ |

### HadoopInputFormatBase クラス (mapred) (E-15)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | getJobConfがJobConfを返す | E-15 Line 100-102 | ○ |
| C-120 | configureがConfigurableを設定する | E-15 Line 108-120 | ○ |
| C-121 | configureがJobConfigurableを設定する | E-15 Line 116-118 | ○ |
| C-122 | getStatisticsが統計を返す | E-15 Line 123-152 | ○ |
| C-123 | getStatisticsがnullを返す | E-15 Line 125-127 | ○ |
| C-124 | createInputSplitsが分割を生成する | E-15 Line 155-163 | ○ |
| C-125 | getInputSplitAssignerがアサイナーを返す | E-15 Line 166-168 | ○ |
| C-126 | openが分割を開く | E-15 Line 171-185 | ○ |
| C-127 | reachedEndがfalseを返す | E-15 Line 188-193 | ○ |
| C-128 | reachedEndがtrueを返す | E-15 Line 188-193 | ○ |
| C-129 | closeがrecordReaderを閉じる | E-15 Line 201-209 | ○ |
| C-130 | closeがnull安全に動作する | E-15 Line 202-208 | ○ |

### HadoopOutputFormatBase クラス (mapred) (E-16)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | getJobConfがJobConfを返す | E-16 Line 86-88 | ○ |
| C-132 | configureがConfigurableを設定する | E-16 Line 94-106 | ○ |
| C-133 | openがタスクを開く | E-16 Line 115-159 | ○ |
| C-134 | openがタスクID制限で例外をスローする | E-16 Line 119-121 | ○ |
| C-135 | closeがタスクをコミットする | E-16 Line 167-177 | ○ |
| C-136 | finalizeGlobalがジョブをコミットする | E-16 Line 180-191 | ○ |

### HadoopInputFormat クラス (mapred) (E-17)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-137 | フルコンストラクタが動作する | E-17 Line 46-52 | ○ |
| C-138 | 簡易コンストラクタが動作する | E-17 Line 54-59 | ○ |
| C-139 | nextRecordがレコードを返す | E-17 Line 62-73 | ○ |
| C-140 | nextRecordがnullを返す | E-17 Line 66-68 | ○ |
| C-141 | getProducedTypeが型情報を返す | E-17 Line 76-79 | ○ |

### HadoopOutputFormatCommonBase クラス (E-18)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | writeがcredentialsをシリアライズする | E-18 Line 43-45 | ○ |
| C-143 | readがcredentialsをデシリアライズする | E-18 Line 47-50 | ○ |

### HadoopInputFormatCommonBase クラス (E-19)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | writeがcredentialsをシリアライズする | E-19 Line 42-44 | ○ |
| C-145 | readがcredentialsをデシリアライズする | E-19 Line 46-49 | ○ |
| C-146 | getCredentialsFromUGIがcredentialsを返す | E-19 Line 55-57 | ○ |

### HadoopInputSplit クラス (mapreduce) (E-20)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | コンストラクタが正常に動作する | E-20 Line 46-60 | ○ |
| C-148 | nullのInputSplitで例外がスローされる | E-20 Line 52-54 | ○ |
| C-149 | Writableでない場合例外がスローされる | E-20 Line 55-57 | ○ |
| C-150 | getHadoopInputSplitが分割を返す | E-20 Line 66-68 | ○ |
| C-151 | getHostnamesがロケーションを返す | E-20 Line 71-77 | ○ |
| C-152 | getHostnamesが例外時に空配列を返す | E-20 Line 74-76 | ○ |
| C-153 | シリアライズ/デシリアライズが動作する | E-20 Line 83-105 | ○ |

### HadoopUtils クラス (mapreduce.utils) (E-21)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-154 | mergeHadoopConfが設定をマージする | E-21 Line 35-51 | ○ |
| C-155 | 既存の設定が上書きされない | E-21 Line 47-49 | ○ |

### HadoopOutputFormat クラス (mapreduce) (E-22)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-156 | コンストラクタが正常に動作する | E-22 Line 39-42 | ○ |
| C-157 | writeRecordがレコードを書き込む | E-22 Line 45-51 | ○ |
| C-158 | writeRecordがInterruptedExceptionをIOExceptionに変換する | E-22 Line 48-50 | ○ |

### HadoopInputFormatBase クラス (mapreduce) (E-23)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-159 | getConfigurationがConfigurationを返す | E-23 Line 98-100 | ○ |
| C-160 | configureがConfigurableを設定する | E-23 Line 107-115 | ○ |
| C-161 | getStatisticsが統計を返す | E-23 Line 118-148 | ○ |
| C-162 | createInputSplitsが分割を生成する | E-23 Line 151-174 | ○ |
| C-163 | createInputSplitsが例外を変換する | E-23 Line 165-167 | ○ |
| C-164 | openが分割を開く | E-23 Line 182-200 | ○ |
| C-165 | openが例外を変換する | E-23 Line 194-196 | ○ |
| C-166 | reachedEndが正しく動作する | E-23 Line 203-208 | ○ |
| C-167 | fetchNextが例外を変換する | E-23 Line 210-218 | ○ |
| C-168 | closeがrecordReaderを閉じる | E-23 Line 221-229 | ○ |

### HadoopOutputFormatBase クラス (mapreduce) (E-24)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-169 | getConfigurationがConfigurationを返す | E-24 Line 79-81 | ○ |
| C-170 | configureがConfigurableを設定する | E-24 Line 88-96 | ○ |
| C-171 | openがタスクを開く | E-24 Line 104-167 | ○ |
| C-172 | openがタスクID制限で例外をスローする | E-24 Line 108-110 | ○ |
| C-173 | openが例外を変換する | E-24 Line 163-165 | ○ |
| C-174 | closeがタスクをコミットする | E-24 Line 175-205 | ○ |
| C-175 | closeが例外を変換する | E-24 Line 180-183 | ○ |
| C-176 | finalizeGlobalがジョブをコミットする | E-24 Line 208-240 | ○ |

### HadoopInputFormat クラス (mapreduce) (E-25)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-177 | フルコンストラクタが動作する | E-25 Line 44-50 | ○ |
| C-178 | 簡易コンストラクタが動作する | E-25 Line 52-58 | ○ |
| C-179 | nextRecordがレコードを返す | E-25 Line 61-77 | ○ |
| C-180 | nextRecordがnullを返す | E-25 Line 65-67 | ○ |
| C-181 | nextRecordが例外を変換する | E-25 Line 71-73 | ○ |
| C-182 | getProducedTypeが型情報を返す | E-25 Line 80-83 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースがソースコードを直接参照して生成されている

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されており、根拠が明確

## 6) レビュアーチェックリスト（最小）
- [ ] HadoopInputs: mapred/mapreduce両方のAPIが正しくテストされているか確認
- [ ] WritableTypeInfo/WritableSerializer/WritableComparator: 型システム関連のテストが網羅されているか確認
- [ ] HadoopInputFormatBase/HadoopOutputFormatBase: ライフサイクル（configure, open, close）のテストが適切か確認
- [ ] シリアライズ/デシリアライズ: カスタムシリアライズロジックのテストが適切か確認
- [ ] 例外ハンドリング: InterruptedException, IOException等の変換が正しくテストされているか確認
- [ ] null検証: コンストラクタやメソッドのnullチェックが網羅されているか確認
