---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 133
  claims_with_evidence: 133
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：flink-core-api 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：133 / 133、根拠なし：0
- 優先レビュー（高）
  1. 全てのテストケースがソースコードに基づいて生成されている
  2. テスト観点（正常系/異常系/境界値）が網羅されている
  3. 追加のテストケースが必要な場合は、実際のソースコードを再確認すること

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-core-api/src/main/java/org/apache/flink/configuration/MemorySize.java`
- E-02: `flink-core-api/src/main/java/org/apache/flink/api/java/tuple/Tuple.java`
- E-03: `flink-core-api/src/main/java/org/apache/flink/api/java/tuple/Tuple2.java`
- E-04: `flink-core-api/src/main/java/org/apache/flink/api/common/SlotSharingGroup.java`
- E-05: `flink-core-api/src/main/java/org/apache/flink/util/TaggedUnion.java`
- E-06: `flink-core-api/src/main/java/org/apache/flink/api/common/watermark/LongWatermark.java`
- E-07: `flink-core-api/src/main/java/org/apache/flink/api/common/watermark/BoolWatermark.java`
- E-08: `flink-core-api/src/main/java/org/apache/flink/api/common/watermark/WatermarkCombinationPolicy.java`
- E-09: `flink-core-api/src/main/java/org/apache/flink/api/common/watermark/WatermarkDeclarations.java`
- E-10: `flink-core-api/src/main/java/org/apache/flink/api/common/state/StateDeclarations.java`
- E-11: `flink-core-api/src/main/java/org/apache/flink/types/NullFieldException.java`
- E-12: `flink-core-api/src/main/java/org/apache/flink/api/common/typeinfo/utils/TypeUtils.java`
- E-13: `flink-core-api/src/main/java/org/apache/flink/util/function/ThrowingConsumer.java`
- E-14: `flink-core-api/src/main/java/org/apache/flink/util/function/FunctionWithException.java`
- E-15: `flink-core-api/src/main/java/org/apache/flink/api/common/typeinfo/TypeDescriptors.java`
- E-16: `flink-core-api/src/main/java/org/apache/flink/api/common/state/StateDeclaration.java`
- E-17: `flink-core-api/src/main/java/org/apache/flink/api/common/state/ListStateDeclaration.java`
- E-18: `flink-core-api/src/main/java/org/apache/flink/api/common/watermark/WatermarkCombinationFunction.java`
- E-19: `flink-core-api/src/main/java/org/apache/flink/api/common/functions/AggregateFunction.java`
- E-20: `flink-core-api/src/main/java/org/apache/flink/api/common/functions/ReduceFunction.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MemorySizeコンストラクタは正の値で作成可能 | E-01 (L75-80) | ○ |
| C-02 | MemorySizeコンストラクタは0で作成可能 | E-01 (L76) | ○ |
| C-03 | MemorySizeコンストラクタは負の値でIllegalArgumentException | E-01 (L76-78) | ○ |
| C-04 | ofMeBiBytesでメビバイト単位作成 | E-01 (L82-84) | ○ |
| C-05 | getBytesでバイト数取得 | E-01 (L89-91) | ○ |
| C-06 | getKibiBytesでキビバイト数取得 | E-01 (L94-96) | ○ |
| C-07 | getMebiBytesでメビバイト数取得 | E-01 (L99-101) | ○ |
| C-08 | getGibiBytesでギビバイト数取得 | E-01 (L104-106) | ○ |
| C-09 | getTebiBytesでテビバイト数取得 | E-01 (L109-111) | ○ |
| C-10 | addで加算可能 | E-01 (L199-201) | ○ |
| C-11 | addでオーバーフロー時ArithmeticException | E-01 (L200, Math.addExact使用) | ○ |
| C-12 | subtractで減算可能 | E-01 (L203-205) | ○ |
| C-13 | subtractでアンダーフロー時ArithmeticException | E-01 (L204, Math.subtractExact使用) | ○ |
| C-14 | multiplyで乗算可能 | E-01 (L207-218) | ○ |
| C-15 | multiplyで負の乗数IllegalArgumentException | E-01 (L208-210) | ○ |
| C-16 | multiplyでオーバーフロー時ArithmeticException | E-01 (L214-216) | ○ |
| C-17 | divideで除算可能 | E-01 (L220-225) | ○ |
| C-18 | divideで負の除数IllegalArgumentException | E-01 (L221-223) | ○ |
| C-19 | parseで数字のみ文字列をバイトとしてパース | E-01 (L238-240, L300) | ○ |
| C-20 | parseでkb単位パース | E-01 (L315-318) | ○ |
| C-21 | parseでmb単位パース | E-01 (L319-320) | ○ |
| C-22 | parseでgb単位パース | E-01 (L321-322) | ○ |
| C-23 | parseでtb単位パース | E-01 (L323-324) | ○ |
| C-24 | parseでnull入力時NullPointerException | E-01 (L268) | ○ |
| C-25 | parseで空文字列IllegalArgumentException | E-01 (L271-273) | ○ |
| C-26 | parseで不正な単位IllegalArgumentException | E-01 (L325-331) | ○ |
| C-27 | parseで数字なしNumberFormatException | E-01 (L286-288) | ○ |
| C-28 | compareToで比較 | E-01 (L191-193) | ○ |
| C-29 | equalsで同値比較 | E-01 (L121-126) | ○ |
| C-30 | equalsで異値比較 | E-01 (L121-126) | ○ |
| C-31 | hashCode実装 | E-01 (L116-118) | ○ |
| C-32 | toString実装 | E-01 (L129-135) | ○ |
| C-33 | toHumanReadableString実装 | E-01 (L159-165) | ○ |
| C-34 | MemoryUnit.hasUnitで単位あり判定 | E-01 (L391-411) | ○ |
| C-35 | MemoryUnit.hasUnitで単位なし判定 | E-01 (L391-411) | ○ |
| C-36 | MemoryUnit.hasUnitでnull時NullPointerException | E-01 (L392) | ○ |
| C-37 | Tuple.newInstanceでarity=0 | E-02 (L124-125) | ○ |
| C-38 | Tuple.newInstanceでarity=2 | E-02 (L128-129) | ○ |
| C-39 | Tuple.newInstanceでarity=25 | E-02 (L174-175) | ○ |
| C-40 | Tuple.newInstanceでarity=-1 | E-02 (L176-178) | ○ |
| C-41 | Tuple.newInstanceでarity=26 | E-02 (L176-178) | ○ |
| C-42 | Tuple.getTupleClassでarity=2 | E-02 (L108-114) | ○ |
| C-43 | Tuple.getTupleClassでarity=-1 | E-02 (L109-111) | ○ |
| C-44 | Tuple.getTupleClassでarity=26 | E-02 (L109-111) | ○ |
| C-45 | Tuple.getFieldNotNullで非null取得 | E-02 (L65-72) | ○ |
| C-46 | Tuple.getFieldNotNullでnull時NullFieldException | E-02 (L70-71) | ○ |
| C-47 | Tuple2コンストラクタで2値作成 | E-03 (L70-73) | ○ |
| C-48 | Tuple2デフォルトコンストラクタ | E-03 (L62) | ○ |
| C-49 | Tuple2.getArityで2返却 | E-03 (L76-78) | ○ |
| C-50 | Tuple2.getFieldでpos=0 | E-03 (L82-91) | ○ |
| C-51 | Tuple2.getFieldでpos=1 | E-03 (L82-91) | ○ |
| C-52 | Tuple2.getFieldでpos=2 | E-03 (L88-89) | ○ |
| C-53 | Tuple2.getFieldでpos=-1 | E-03 (L88-89) | ○ |
| C-54 | Tuple2.setFieldでpos=0 | E-03 (L95-106) | ○ |
| C-55 | Tuple2.setFieldでpos=2 | E-03 (L103-104) | ○ |
| C-56 | Tuple2.setFields | E-03 (L114-117) | ○ |
| C-57 | Tuple2.swap | E-03 (L124-126) | ○ |
| C-58 | Tuple2.copy | E-03 (L180-184) | ○ |
| C-59 | Tuple2.equals同値 | E-03 (L150-166) | ○ |
| C-60 | Tuple2.equals異値 | E-03 (L150-166) | ○ |
| C-61 | Tuple2.equalsでnullフィールド | E-03 (L159-164) | ○ |
| C-62 | Tuple2.hashCode | E-03 (L169-173) | ○ |
| C-63 | Tuple2.toString | E-03 (L138-141) | ○ |
| C-64 | Tuple2.of | E-03 (L192-194) | ○ |
| C-65 | SlotSharingGroup.Builder.newBuilder | E-04 (L109-111) | ○ |
| C-66 | SlotSharingGroup.Builder.setCpuCores正常 | E-04 (L153-159) | ○ |
| C-67 | SlotSharingGroup.Builder.setCpuCores異常 | E-04 (L154-156) | ○ |
| C-68 | SlotSharingGroup.Builder.setTaskHeapMemory正常 | E-04 (L162-168) | ○ |
| C-69 | SlotSharingGroup.Builder.setTaskHeapMemory異常 | E-04 (L163-165) | ○ |
| C-70 | SlotSharingGroup.Builder.setTaskHeapMemoryMB正常 | E-04 (L171-177) | ○ |
| C-71 | SlotSharingGroup.Builder.setTaskHeapMemoryMB異常 | E-04 (L172-174) | ○ |
| C-72 | SlotSharingGroup.Builder.build正常 | E-04 (L213-235) | ○ |
| C-73 | SlotSharingGroup.Builder.build最小構成 | E-04 (L232-233) | ○ |
| C-74 | SlotSharingGroup.Builder.build必須フィールド不足 | E-04 (L224-231) | ○ |
| C-75 | SlotSharingGroup.equals | E-04 (L114-126) | ○ |
| C-76 | SlotSharingGroup.hashCode | E-04 (L129-136) | ○ |
| C-77 | TaggedUnion.one | E-05 (L55-57) | ○ |
| C-78 | TaggedUnion.two | E-05 (L59-61) | ○ |
| C-79 | TaggedUnion.isOneでone作成時 | E-05 (L39-41) | ○ |
| C-80 | TaggedUnion.isOneでtwo作成時 | E-05 (L39-41) | ○ |
| C-81 | TaggedUnion.isTwo | E-05 (L43-45) | ○ |
| C-82 | TaggedUnion.getOne | E-05 (L47-49) | ○ |
| C-83 | TaggedUnion.getTwo | E-05 (L51-53) | ○ |
| C-84 | TaggedUnion.equals同値 | E-05 (L64-75) | ○ |
| C-85 | TaggedUnion.equals異タイプ | E-05 (L64-75) | ○ |
| C-86 | LongWatermarkコンストラクタ | E-06 (L37-40) | ○ |
| C-87 | LongWatermark.getValue | E-06 (L42-44) | ○ |
| C-88 | LongWatermark.getIdentifier | E-06 (L47-49) | ○ |
| C-89 | LongWatermark.equals | E-06 (L52-61) | ○ |
| C-90 | LongWatermark.hashCode | E-06 (L64-66) | ○ |
| C-91 | BoolWatermarkコンストラクタ | E-07 (L38-41) | ○ |
| C-92 | BoolWatermark.getValue | E-07 (L43-45) | ○ |
| C-93 | BoolWatermark.getIdentifier | E-07 (L48-50) | ○ |
| C-94 | BoolWatermark.equals | E-07 (L53-61) | ○ |
| C-95 | WatermarkCombinationPolicyコンストラクタ | E-08 (L47-52) | ○ |
| C-96 | WatermarkCombinationPolicy.getWatermarkCombinationFunction | E-08 (L54-56) | ○ |
| C-97 | WatermarkCombinationPolicy.isCombineWaitForAllChannels | E-08 (L58-60) | ○ |
| C-98 | WatermarkCombinationPolicy.equals | E-08 (L63-72) | ○ |
| C-99 | WatermarkDeclarations.newBuilder | E-09 (L29-31) | ○ |
| C-100 | LongWatermarkDeclarationBuilder.typeLong | E-09 (L43-45) | ○ |
| C-101 | LongWatermarkDeclarationBuilder.combineFunctionMax | E-09 (L65-68) | ○ |
| C-102 | LongWatermarkDeclarationBuilder.combineFunctionMin | E-09 (L71-74) | ○ |
| C-103 | LongWatermarkDeclarationBuilder.build | E-09 (L109-115) | ○ |
| C-104 | BoolWatermarkDeclarationBuilder.typeBool | E-09 (L47-49) | ○ |
| C-105 | BoolWatermarkDeclarationBuilder.combineFunctionOR | E-09 (L132-135) | ○ |
| C-106 | BoolWatermarkDeclarationBuilder.combineFunctionAND | E-09 (L138-141) | ○ |
| C-107 | BoolWatermarkDeclarationBuilder.build | E-09 (L176-182) | ○ |
| C-108 | StateDeclarations.valueState | E-10 (L117-120) | ○ |
| C-109 | StateDeclarations.listState | E-10 (L108-111) | ○ |
| C-110 | StateDeclarations.mapState | E-10 (L95-101) | ○ |
| C-111 | StateDeclarations.reducingState | E-10 (L85-88) | ○ |
| C-112 | StateDeclarations.aggregatingState | E-10 (L72-78) | ○ |
| C-113 | ListStateDeclarationBuilder.redistributeBy | E-10 (L308-313) | ○ |
| C-114 | ListStateDeclarationBuilder.build | E-10 (L321-344) | ○ |
| C-115 | MapStateDeclarationBuilder.buildBroadcast | E-10 (L241-264) | ○ |
| C-116 | NullFieldExceptionデフォルトコンストラクタ | E-11 (L35-38) | ○ |
| C-117 | NullFieldExceptionメッセージコンストラクタ | E-11 (L45-48) | ○ |
| C-118 | NullFieldExceptionフィールドインデックスコンストラクタ | E-11 (L56-59) | ○ |
| C-119 | NullFieldExceptioncause付きコンストラクタ | E-11 (L68-71) | ○ |
| C-120 | NullFieldException.getFieldPos | E-11 (L79-81) | ○ |
| C-121 | TypeUtils.getInstance正常 | E-12 (L30-44) | ○ |
| C-122 | TypeUtils.getInstance存在しないクラス | E-12 (L32) | ○ |
| C-123 | TypeUtils.getInstance適合コンストラクタなし | E-12 (L43) | ○ |
| C-124 | ThrowingConsumer.accept | E-13 (L42) | ○ |
| C-125 | ThrowingConsumer.unchecked | E-13 (L51-59) | ○ |
| C-126 | FunctionWithException.apply | E-14 (L43) | ○ |
| C-127 | FunctionWithException.unchecked | E-14 (L53-63) | ○ |
| C-128 | TypeDescriptors.STRING | E-15 (L64, L77-82) | ○ |
| C-129 | TypeDescriptors.INT | E-15 (L65, L84-90) | ○ |
| C-130 | TypeDescriptors.LONG | E-15 (L67, L100-106) | ○ |
| C-131 | TypeDescriptors.value | E-15 (L32-39) | ○ |
| C-132 | TypeDescriptors.map | E-15 (L42-51) | ○ |
| C-133 | TypeDescriptors.list | E-15 (L54-61) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの項目はありません
- 追加で検討すべき観点:
  - 既存のテストコード（`src/test/java`配下）との重複確認
  - パフォーマンス観点のテスト（大量データ処理時の挙動）
  - シリアライズ/デシリアライズのテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されている
- 注意点:
  - Tupleクラス（Tuple0-Tuple25）は生成コードであり、代表としてTuple2のみを対象とした
  - TupleBuilderクラス群も同様に代表的なパターンのみをカバー
  - インターフェース（State, Watermark等）の実装クラスは別モジュールに存在する可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースの網羅性が十分か確認（特にTuple以外のクラス）
- [ ] 異常系テストケースで想定される例外が正しいか確認
- [ ] 境界値テストが適切な値を使用しているか確認
- [ ] 既存のテストコードとの重複がないか確認
- [ ] インターフェースの実装クラスのテストが必要か検討
- [ ] 実際のFlink環境での統合テストが必要か検討
