---
generated_at: 2026-02-02 17:30:00
metrics:
  claims_total: 195
  claims_with_evidence: 185
  claims_without_evidence: 10
confidence_derived: 0.95
---

# 根拠レポート：flink-core単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：185 / 195、根拠なし：10
- 優先レビュー（高）
  1. **FileSystem関連テストケース（C-192〜C-195）**：初期化やファクトリメソッドの詳細動作は実装依存
  2. **TimeUtils関連テストケース（C-179〜C-191）**：ISO-8601パース等のエッジケース
  3. **MemorySegment複合操作（C-118〜C-124）**：wrap/compare/swapの詳細挙動

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flink-core/src/main/java/org/apache/flink/configuration/Configuration.java`
- E-02: `flink-core/src/main/java/org/apache/flink/util/Preconditions.java`
- E-03: `flink-core/src/main/java/org/apache/flink/util/StringUtils.java`
- E-04: `flink-core/src/main/java/org/apache/flink/types/Row.java`
- E-05: `flink-core/src/main/java/org/apache/flink/core/memory/MemorySegment.java`
- E-06: `flink-core/src/main/java/org/apache/flink/util/FileUtils.java`
- E-07: `flink-core/src/main/java/org/apache/flink/util/ExceptionUtils.java`
- E-08: `flink-core/src/main/java/org/apache/flink/util/MathUtils.java`
- E-09: `flink-core/src/main/java/org/apache/flink/util/TimeUtils.java`
- E-10: `flink-core/src/main/java/org/apache/flink/core/fs/FileSystem.java`
- E-11: `flink-core/src/test/java/org/apache/flink/configuration/ConfigurationTest.java`（既存テスト参照）
- E-12: `flink-core/src/test/java/org/apache/flink/types/RowTest.java`（既存テスト参照）
- E-13: `flink-core/src/test/java/org/apache/flink/core/memory/MemorySegmentTestBase.java`（既存テスト参照）

## 3) Claims と根拠の対応（レビューの主戦場）

### Configuration クラス (C-01〜C-31)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getString正常系：キーに対応する文字列値が取得される | E-01 (L120-124) | ○ |
| C-02 | getString異常系：存在しないキーでデフォルト値返却 | E-01 (L120-124) | ○ |
| C-03 | setString正常系：キーと値のペアが設定される | E-01 (L136-138) | ○ |
| C-04 | setString異常系：keyがnullでNPE | E-01 (L469-472) | ○ |
| C-05 | setString異常系：valueがnullでNPE | E-01 (L473-475) | ○ |
| C-06 | getBytes正常系：バイト配列が取得される | E-01 (L148-163) | ○ |
| C-07 | getBytes異常系：不正な型でIllegalArgumentException | E-01 (L152-159) | ○ |
| C-08 | get(ConfigOption)正常系：設定値取得 | E-01 (L347-350) | ○ |
| C-09 | get(ConfigOption)正常系：デフォルト値 | E-01 (L349) | ○ |
| C-10 | getOptional正常系：値存在時Optional.of() | E-01 (L367-386) | ○ |
| C-11 | getOptional正常系：値不在時Optional.empty() | E-01 (L367-386) | ○ |
| C-12 | set正常系：ConfigOptionで値設定 | E-01 (L388-393) | ○ |
| C-13 | containsKey正常系：存在するキーでtrue | E-01 (L286-290) | ○ |
| C-14 | containsKey正常系：存在しないキーでfalse | E-01 (L286-290) | ○ |
| C-15 | contains正常系：ConfigOption存在でtrue | E-01 (L299-312) | ○ |
| C-16 | keySet正常系：全キーのSet返却 | E-01 (L226-230) | ○ |
| C-17 | keySet境界値：空Configで空Set | E-01 (L226-230) | ○ |
| C-18 | toMap正常系：Map変換 | E-01 (L397-407) | ○ |
| C-19 | clone正常系：コピー作成 | E-01 (L272-278) | ○ |
| C-20 | addAll正常系：設定マージ | E-01 (L241-247) | ○ |
| C-21 | removeConfig正常系：削除成功 | E-01 (L439-451) | ○ |
| C-22 | removeConfig正常系：削除失敗 | E-01 (L439-451) | ○ |
| C-23 | removeKey正常系：キー削除 | E-01 (L459-465) | ○ |
| C-24 | fromMap正常系：Map→Configuration | E-01 (L100-104) | ○ |
| C-25 | read正常系：デシリアライズ | E-01 (L544-589) | ○ |
| C-26 | write正常系：シリアライズ | E-01 (L591-633) | ○ |
| C-27 | equals正常系：同内容でequal | E-01 (L646-674) | ○ |
| C-28 | equals正常系：異内容でnot equal | E-01 (L646-674) | ○ |
| C-29 | hashCode正常系：同内容で同ハッシュ | E-01 (L638-644) | ○ |
| C-30 | getEnum正常系：Enum値取得 | E-01 (L199-217) | ○ |
| C-31 | getEnum異常系：不正Enumで例外 | E-01 (L208-216) | ○ |

### Preconditions クラス (C-32〜C-46)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | checkNotNull正常系：非nullでそのまま返却 | E-02 (L57-62) | ○ |
| C-33 | checkNotNull異常系：nullでNPE | E-02 (L57-62) | ○ |
| C-34 | checkNotNull異常系：メッセージ付きNPE | E-02 (L74-79) | ○ |
| C-35 | checkArgument正常系：trueで例外なし | E-02 (L120-124) | ○ |
| C-36 | checkArgument異常系：falseでIAE | E-02 (L120-124) | ○ |
| C-37 | checkArgument異常系：メッセージ付きIAE | E-02 (L136-140) | ○ |
| C-38 | checkState正常系：trueで例外なし | E-02 (L175-179) | ○ |
| C-39 | checkState異常系：falseでISE | E-02 (L175-179) | ○ |
| C-40 | checkElementIndex正常系：有効インデックス | E-02 (L228-233) | ○ |
| C-41 | checkElementIndex異常系：負インデックス | E-02 (L228-233) | ○ |
| C-42 | checkElementIndex異常系：範囲外インデックス | E-02 (L228-233) | ○ |
| C-43 | checkElementIndex異常系：負サイズ | E-02 (L229) | ○ |
| C-44 | checkCompletedNormally正常系：正常完了 | E-02 (L260-269) | ○ |
| C-45 | checkCompletedNormally異常系：未完了 | E-02 (L261) | ○ |
| C-46 | checkCompletedNormally異常系：例外完了 | E-02 (L262-267) | ○ |

### StringUtils クラス (C-47〜C-63)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | byteToHexString正常系：16進変換 | E-03 (L61-75) | ○ |
| C-48 | byteToHexString異常系：nullでIAE | E-03 (L62-64) | ○ |
| C-49 | byteToHexString境界値：空配列 | E-03 (L61-75) | ○ |
| C-50 | hexStringToByte正常系：バイト配列変換 | E-03 (L95-101) | ○ |
| C-51 | hexStringToByte境界値：空文字列 | E-03 (L95-101) | ○ |
| C-52 | showControlCharacters正常系：制御文字エスケープ | E-03 (L123-151) | ○ |
| C-53 | getRandomString正常系：ランダム文字列 | E-03 (L162-170) | ○ |
| C-54 | generateRandomAlphanumericString正常系 | E-03 (L202-211) | ○ |
| C-55 | generateRandomAlphanumericString異常系：負の長さ | E-03 (L204) | ○ |
| C-56 | isNullOrWhitespaceOnly正常系：null | E-03 (L291-303) | ○ |
| C-57 | isNullOrWhitespaceOnly正常系：空文字列 | E-03 (L291-303) | ○ |
| C-58 | isNullOrWhitespaceOnly正常系：空白のみ | E-03 (L291-303) | ○ |
| C-59 | isNullOrWhitespaceOnly正常系：通常文字列 | E-03 (L291-303) | ○ |
| C-60 | concatenateWithAnd正常系：両方非null | E-03 (L315-321) | ○ |
| C-61 | concatenateWithAnd正常系：s1がnull | E-03 (L315-321) | ○ |
| C-62 | concatenateWithAnd正常系：s2がnull | E-03 (L315-321) | ○ |
| C-63 | concatenateWithAnd正常系：両方null | E-03 (L315-321) | ○ |

### Row クラス (C-64〜C-87)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | withPositions正常系：位置ベースRow作成 | E-04 (L171-173) | ○ |
| C-65 | withPositions正常系：RowKind指定 | E-04 (L154-156) | ○ |
| C-66 | withNames正常系：名前ベースRow作成 | E-04 (L202-204) | ○ |
| C-67 | getField(int)正常系：位置でフィールド取得 | E-04 (L253-260) | ○ |
| C-68 | getField(int)異常系：名前ベースRowでIAE | E-04 (L256-259) | ○ |
| C-69 | getField(String)正常系：名前でフィールド取得 | E-04 (L285-300) | ○ |
| C-70 | getField(String)異常系：位置ベースRowでIAE | E-04 (L296-299) | ○ |
| C-71 | setField(int)正常系：位置でフィールド設定 | E-04 (L325-332) | ○ |
| C-72 | setField(String)正常系：名前でフィールド設定 | E-04 (L342-360) | ○ |
| C-73 | setField正常系：null値設定 | E-04 (L325-332) | ○ |
| C-74 | getArity正常系：アリティ取得 | E-04 (L236-243) | ○ |
| C-75 | getKind正常系：RowKind取得 | E-04 (L213-215) | ○ |
| C-76 | setKind正常系：RowKind設定 | E-04 (L224-227) | ○ |
| C-77 | setKind異常系：nullでNPE | E-04 (L225) | ○ |
| C-78 | clear正常系：全フィールドクリア | E-04 (L382-389) | ○ |
| C-79 | of正常系：可変長引数からRow作成 | E-04 (L448-454) | ○ |
| C-80 | of境界値：空引数 | E-04 (L448-454) | ○ |
| C-81 | ofKind正常系：RowKindと値からRow作成 | E-04 (L478-484) | ○ |
| C-82 | copy正常系：Rowコピー | E-04 (L491-509) | ○ |
| C-83 | project(int[])正常系：位置射影 | E-04 (L520-526) | ○ |
| C-84 | join正常系：Row結合 | E-04 (L554-592) | ○ |
| C-85 | join異常系：名前ベースRowでIAE | E-04 (L555-563) | ○ |
| C-86 | equals正常系：同内容でequal | E-04 (L396-414) | ○ |
| C-87 | equals正常系：異内容でnot equal | E-04 (L396-414) | ○ |

### MemorySegment クラス (C-88〜C-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | size正常系：サイズ取得 | E-05 (L219-221) | ○ |
| C-89 | get正常系：バイト読み取り | E-05 (L381-391) | ○ |
| C-90 | get異常系：負インデックスでIOOBE | E-05 (L387-390) | ○ |
| C-91 | get異常系：範囲外でIOOBE | E-05 (L387-390) | ○ |
| C-92 | get異常系：解放済みでISE | E-05 (L385-386) | ○ |
| C-93 | put正常系：バイト書き込み | E-05 (L401-411) | ○ |
| C-94 | put異常系：負インデックスでIOOBE | E-05 (L407-410) | ○ |
| C-95 | getInt正常系：整数読み取り | E-05 (L793-803) | ○ |
| C-96 | getInt異常系：境界超過でIOOBE | E-05 (L795-802) | ○ |
| C-97 | putInt正常系：整数書き込み | E-05 (L860-870) | ○ |
| C-98 | getLong正常系：長整数読み取り | E-05 (L927-937) | ○ |
| C-99 | putLong正常系：長整数書き込み | E-05 (L994-1004) | ○ |
| C-100 | getFloat正常系：浮動小数点読み取り | E-05 (L1061-1063) | ○ |
| C-101 | putFloat正常系：浮動小数点書き込み | E-05 (L1112-1114) | ○ |
| C-102 | getDouble正常系：倍精度読み取り | E-05 (L1163-1165) | ○ |
| C-103 | putDouble正常系：倍精度書き込み | E-05 (L1214-1216) | ○ |
| C-104 | getBoolean正常系：ブール値読み取り | E-05 (L512-514) | ○ |
| C-105 | putBoolean正常系：ブール値書き込み | E-05 (L524-526) | ○ |
| C-106 | getShort正常系：短整数読み取り | E-05 (L663-673) | ○ |
| C-107 | putShort正常系：短整数書き込み | E-05 (L726-736) | ○ |
| C-108 | getChar正常系：文字読み取り | E-05 (L537-547) | ○ |
| C-109 | putChar正常系：文字書き込み | E-05 (L600-610) | ○ |
| C-110 | free正常系：メモリ解放 | E-05 (L240-256) | ○ |
| C-111 | free異常系：多重解放でISE | E-05 (L241-245) | ○ |
| C-112 | isFreed正常系：未解放でfalse | E-05 (L229-231) | ○ |
| C-113 | isFreed正常系：解放済みでtrue | E-05 (L229-231) | ○ |
| C-114 | isOffHeap正常系：オフヒープでtrue | E-05 (L264-266) | ○ |
| C-115 | isOffHeap正常系：オンヒープでfalse | E-05 (L264-266) | ○ |
| C-116 | getArray正常系：オンヒープで配列取得 | E-05 (L274-280) | ○ |
| C-117 | getArray異常系：オフヒープでISE | E-05 (L277-279) | ○ |
| C-118 | wrap正常系：ByteBufferでラップ | E-05 (L321-346) | ○ |
| C-119 | wrap異常系：ラップ禁止でUOE | E-05 (L322-325) | ○ |
| C-120 | copyTo正常系：データコピー | E-05 (L1439-1459) | ○ |
| C-121 | compare正常系：同内容で0 | E-05 (L1517-1542) | ○ |
| C-122 | compare正常系：異内容で非ゼロ | E-05 (L1517-1542) | ○ |
| C-123 | equalTo正常系：同内容でtrue | E-05 (L1610-1631) | ○ |
| C-124 | swapBytes正常系：バイト交換 | E-05 (L1569-1599) | ○ |

### FileUtils クラス (C-125〜C-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | deleteFileOrDirectory正常系：ファイル削除 | E-06 (L246-250) | ○ |
| C-126 | deleteFileOrDirectory正常系：ディレクトリ削除 | E-06 (L307-315) | ○ |
| C-127 | deleteFileOrDirectory正常系：存在しないファイル | E-06 (L246-250) | ○ |
| C-128 | deleteDirectory正常系：ディレクトリ削除 | E-06 (L264-268) | ○ |
| C-129 | deleteDirectory異常系：ファイルでIOException | E-06 (L335-339) | ○ |
| C-130 | cleanDirectory正常系：ディレクトリクリーニング | E-06 (L301-305) | ○ |
| C-131 | cleanDirectory異常系：存在しないでFNFE | E-06 (L369-371) | ○ |
| C-132 | readFile正常系：ファイル読み取り | E-06 (L138-141) | ○ |
| C-133 | readFileUtf8正常系：UTF-8読み取り | E-06 (L143-145) | ○ |
| C-134 | writeFile正常系：ファイル書き込み | E-06 (L147-150) | ○ |
| C-135 | getRandomFilename正常系：ランダムファイル名 | E-06 (L123-132) | ○ |
| C-136 | listDirectory正常系：ディレクトリ一覧 | E-06 (L107-112) | ○ |
| C-137 | isJarFile正常系：JARファイル判定 | E-06 (L661-665) | ○ |
| C-138 | isJarFile正常系：非JAR判定 | E-06 (L661-665) | ○ |
| C-139 | stripFileExtension正常系：拡張子除去 | E-06 (L673-681) | ○ |
| C-140 | stripFileExtension正常系：拡張子なし | E-06 (L673-681) | ○ |

### ExceptionUtils クラス (C-141〜C-158)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-141 | stringifyException正常系：例外文字列化 | E-07 (L65-79) | ○ |
| C-142 | stringifyException正常系：nullで"(null)" | E-07 (L66-68) | ○ |
| C-143 | isJvmFatalError正常系：InternalErrorでtrue | E-07 (L95-99) | ○ |
| C-144 | isJvmFatalError正常系：RuntimeExceptionでfalse | E-07 (L95-99) | ○ |
| C-145 | isJvmFatalOrOutOfMemoryError正常系：OOMでtrue | E-07 (L113-115) | ○ |
| C-146 | rethrowIfFatalError正常系：致命的エラー再スロー | E-07 (L244-248) | ○ |
| C-147 | rethrowIfFatalError正常系：非致命的で何もしない | E-07 (L244-248) | ○ |
| C-148 | firstOrSuppressed正常系：previousがnull | E-07 (L297-306) | ○ |
| C-149 | firstOrSuppressed正常系：previousが非null | E-07 (L297-306) | ○ |
| C-150 | rethrow正常系：Error再スロー | E-07 (L315-323) | ○ |
| C-151 | rethrow正常系：RuntimeException再スロー | E-07 (L315-323) | ○ |
| C-152 | rethrow正常系：チェック例外ラップ | E-07 (L315-323) | ○ |
| C-153 | findThrowable正常系：例外チェーン内に存在 | E-07 (L471-487) | ○ |
| C-154 | findThrowable正常系：存在しない | E-07 (L471-487) | ○ |
| C-155 | findThrowableWithMessage正常系：メッセージ検索 | E-07 (L579-595) | ○ |
| C-156 | stripExecutionException正常系：アンラップ | E-07 (L615-617) | ○ |
| C-157 | stripCompletionException正常系：アンラップ | E-07 (L626-628) | ○ |
| C-158 | checkInterrupted正常系：割り込みフラグ設定 | E-07 (L677-681) | ○ |

### MathUtils クラス (C-159〜C-178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-159 | log2floor正常系：対数計算 | E-08 (L34-40) | ○ |
| C-160 | log2floor正常系：切り捨て | E-08 (L34-40) | ○ |
| C-161 | log2floor異常系：0でArithmeticException | E-08 (L35-37) | ○ |
| C-162 | log2strict正常系：2の累乗で正しい対数 | E-08 (L51-60) | ○ |
| C-163 | log2strict異常系：非2の累乗でIAE | E-08 (L55-58) | ○ |
| C-164 | roundDownToPowerOf2正常系：切り下げ | E-08 (L69-71) | ○ |
| C-165 | roundDownToPowerOf2正常系：2の累乗 | E-08 (L69-71) | ○ |
| C-166 | roundUpToPowerOfTwo正常系：切り上げ | E-08 (L163-171) | ○ |
| C-167 | roundUpToPowerOfTwo正常系：2の累乗 | E-08 (L163-171) | ○ |
| C-168 | checkedDownCast正常系：int範囲内 | E-08 (L85-92) | ○ |
| C-169 | checkedDownCast異常系：オーバーフロー | E-08 (L87-90) | ○ |
| C-170 | isPowerOf2正常系：2の累乗でtrue | E-08 (L100-102) | ○ |
| C-171 | isPowerOf2正常系：非2の累乗でfalse | E-08 (L100-102) | ○ |
| C-172 | jenkinsHash正常系：ハッシュ計算 | E-08 (L117-125) | ○ |
| C-173 | murmurHash正常系：ハッシュ計算 | E-08 (L137-155) | ○ |
| C-174 | divideRoundUp正常系：切り上げ除算 | E-08 (L221-225) | ○ |
| C-175 | divideRoundUp境界値：被除数0 | E-08 (L224) | ○ |
| C-176 | divideRoundUp異常系：負の被除数 | E-08 (L222) | ○ |
| C-177 | divideRoundUp異常系：除数0 | E-08 (L223) | ○ |
| C-178 | flipSignBit正常系：符号ビット反転 | E-08 (L209-211) | ○ |

### TimeUtils クラス (C-179〜C-191)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-179 | parseDuration正常系：ミリ秒パース | E-09 (L64-128) | ○ |
| C-180 | parseDuration正常系：秒パース | E-09 (L64-128) | ○ |
| C-181 | parseDuration正常系：分パース | E-09 (L64-128) | ○ |
| C-182 | parseDuration正常系：時間パース | E-09 (L64-128) | ○ |
| C-183 | parseDuration正常系：日パース | E-09 (L64-128) | ○ |
| C-184 | parseDuration正常系：単位なしでミリ秒 | E-09 (L106-107) | ○ |
| C-185 | parseDuration正常系：ISO-8601パース | E-09 (L82-95) | △ |
| C-186 | parseDuration異常系：空文字列 | E-09 (L68) | ○ |
| C-187 | parseDuration異常系：不正単位 | E-09 (L111-117) | ○ |
| C-188 | parseDuration異常系：負のDuration | E-09 (L85-88) | △ |
| C-189 | getStringInMillis正常系：ミリ秒文字列変換 | E-09 (L152-154) | ○ |
| C-190 | formatWithHighestUnit正常系：最適単位フォーマット | E-09 (L168-176) | △ |
| C-191 | formatWithHighestUnit正常系：端数あり | E-09 (L168-176) | △ |

### FileSystem クラス (C-192〜C-195)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-192 | get正常系：URIからFileSystem取得 | E-10 | △ |
| C-193 | getUnguardedFileSystem正常系 | E-10 | △ |
| C-194 | initialize正常系：設定で初期化 | E-10 (L290-293) | △ |
| C-195 | getLocalFileSystem正常系 | E-10 | △ |

## 4) 不足情報（Unknown / Missing）
- **FileSystemの詳細な初期化シーケンス**：プラグインマネージャとの連携部分
  - 候補：FileSystem.java / PluginManager.java / FileSystemFactory実装
- **TimeUtilsのISO-8601パースの全エッジケース**：負の期間、オーバーフロー等
  - 候補：TimeUtils.java / Duration.parse()のJavadoc
- **MemorySegmentのUnsafeメモリ操作の詳細挙動**：プラットフォーム依存の可能性
  - 候補：MemoryUtils.java / sun.misc.Unsafeのドキュメント
- **既存テストコードとの整合性確認**：全195件のテストケースが既存テストとカバレッジ重複していないか
  - 候補：flink-core/src/test/java/ 配下の既存テスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Configuration, Preconditions, StringUtils, Row, MathUtilsの基本テスト
- **1 (中リスク)**: MemorySegmentのオフヒープ操作、FileUtilsのOS依存操作
- **2 (高リスク)**: FileSystemの初期化（プラグイン連携）、TimeUtilsのISO-8601パース

## 6) レビュアーチェックリスト（最小）
- [ ] Configuration関連テスト（C-01〜C-31）：基本的なget/set操作の網羅性確認
- [ ] Preconditions関連テスト（C-32〜C-46）：例外スローの条件が正確か確認
- [ ] Row関連テスト（C-64〜C-87）：位置/名前ベースモードの切り替え動作確認
- [ ] MemorySegment関連テスト（C-88〜C-124）：オンヒープ/オフヒープ両方でのテスト必要性確認
- [ ] FileUtils関連テスト（C-125〜C-140）：OS依存（Windows/Mac）の動作確認
- [ ] ExceptionUtils関連テスト（C-141〜C-158）：例外チェーン操作の正確性確認
- [ ] TimeUtils関連テスト（C-179〜C-191）：ISO-8601パースの△項目の詳細確認
- [ ] FileSystem関連テスト（C-192〜C-195）：△項目の詳細実装確認
